/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.opends.guitools.controlpanel.event.SchemaElementSelectionEvent;
import org.opends.guitools.controlpanel.event.SchemaElementSelectionListener;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.UnsavedChangesDialog;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;

public abstract class SchemaElementPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -8556383593966382604L;
    private Set<SchemaElementSelectionListener> listeners = new HashSet<SchemaElementSelectionListener>();
    protected Border PANEL_BORDER = new EmptyBorder(10, 10, 10, 10);

    public void addSchemaElementSelectionListener(SchemaElementSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSchemaElementSelectionListener(SchemaElementSelectionListener listener) {
        this.listeners.add(listener);
    }

    protected void notifySchemaSelectionListeners(Object schemaElement) {
        for (SchemaElementSelectionListener listener : this.listeners) {
            listener.schemaElementSelected(new SchemaElementSelectionEvent(this, schemaElement));
        }
    }

    public boolean mustCheckUnsavedChanges() {
        return false;
    }

    public UnsavedChangesDialog.Result checkUnsavedChanges() {
        return UnsavedChangesDialog.Result.DO_NOT_SAVE;
    }

    protected void objectClassSelected(JList list) {
        ObjectClass oc;
        Schema schema;
        String o = (String)list.getSelectedValue();
        if (o != null && (schema = this.getInfo().getServerDescriptor().getSchema()) != null && (oc = schema.getObjectClass(o.toLowerCase())) != null) {
            this.notifySchemaSelectionListeners(oc);
        }
    }

    protected Set<String> getAliases(AttributeType attr) {
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        Iterable<String> ocNames = attr.getNormalizedNames();
        String primaryName = attr.getPrimaryName();
        if (primaryName == null) {
            primaryName = "";
        }
        for (String name : ocNames) {
            if (name.equalsIgnoreCase(primaryName)) continue;
            aliases.add(name);
        }
        return aliases;
    }

    protected Set<String> getAliases(ObjectClass oc) {
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        Iterable<String> ocNames = oc.getNormalizedNames();
        String primaryName = oc.getPrimaryName();
        if (primaryName == null) {
            primaryName = "";
        }
        for (String name : ocNames) {
            if (name.equalsIgnoreCase(primaryName)) continue;
            aliases.add(name);
        }
        return aliases;
    }
}

