/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.ObjectClassValue;
import org.opends.guitools.controlpanel.datamodel.SortableListModel;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.AddRemovePanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.Schema;

public class ObjectClassEditorPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 6632731109835897496L;
    private JComboBox structural;
    private AddRemovePanel<String> auxiliary;
    private ObjectClassValue value;
    private boolean valueChanged;

    public ObjectClassEditorPanel() {
        this.createLayout();
    }

    public void setValue(ObjectClassValue value) {
        this.value = value;
        String struct = value.getStructural();
        if (struct != null) {
            DefaultComboBoxModel structuralModel = (DefaultComboBoxModel)this.structural.getModel();
            for (int i = 0; i < structuralModel.getSize(); ++i) {
                if (!struct.equalsIgnoreCase((String)structuralModel.getElementAt(i))) continue;
                this.structural.setSelectedIndex(i);
                break;
            }
        }
        SortableListModel<String> availableListModel = this.auxiliary.getAvailableListModel();
        SortableListModel<String> selectedListModel = this.auxiliary.getSelectedListModel();
        availableListModel.addAll(selectedListModel.getData());
        selectedListModel.clear();
        for (String oc : value.getAuxiliary()) {
            int index = -1;
            for (int i = 0; i < availableListModel.getSize(); ++i) {
                if (!availableListModel.getElementAt(i).equalsIgnoreCase(oc)) continue;
                index = i;
                break;
            }
            if (index == -1) continue;
            oc = availableListModel.getElementAt(index);
            selectedListModel.add(oc);
            availableListModel.remove(oc);
        }
        selectedListModel.fireContentsChanged(selectedListModel, 0, selectedListModel.getSize());
        availableListModel.fireContentsChanged(availableListModel, 0, availableListModel.getSize());
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.structural;
    }

    @Override
    public void cancelClicked() {
        this.valueChanged = false;
        super.cancelClicked();
    }

    public ObjectClassValue getObjectClassValue() {
        return this.value;
    }

    @Override
    public void okClicked() {
        String struct = (String)this.structural.getSelectedItem();
        TreeSet<String> aux = new TreeSet<String>();
        aux.addAll(this.auxiliary.getSelectedListModel().getData());
        aux.add("top");
        ObjectClassValue newValue = new ObjectClassValue(struct, aux);
        this.valueChanged = !newValue.equals(this.value);
        this.value = newValue;
        Utilities.getParentDialog(this).setVisible(false);
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_EDIT_OBJECTCLASS_TITLE.get();
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        Schema schema = ev.getNewDescriptor().getSchema();
        if (schema != null) {
            final TreeSet<String> auxiliaryOcs = new TreeSet<String>();
            final TreeSet<String> structuralOcs = new TreeSet<String>();
            for (ObjectClass oc : schema.getObjectClasses().values()) {
                if (oc.getObjectClassType() == ObjectClassType.AUXILIARY) {
                    if (oc.getNameOrOID().equals("top")) continue;
                    auxiliaryOcs.add(oc.getNameOrOID());
                    continue;
                }
                if (oc.getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
                structuralOcs.add(oc.getNameOrOID());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SortedSet<Object> currentAux;
                    String currentStruct = (String)ObjectClassEditorPanel.this.structural.getSelectedItem();
                    if (currentStruct != null) {
                        currentAux = ObjectClassEditorPanel.this.auxiliary.getSelectedListModel().getData();
                    } else if (ObjectClassEditorPanel.this.value != null) {
                        currentStruct = ObjectClassEditorPanel.this.value.getStructural();
                        currentAux = ObjectClassEditorPanel.this.value.getAuxiliary();
                    } else {
                        currentAux = new TreeSet();
                    }
                    SortableListModel<String> availableListModel = ObjectClassEditorPanel.this.auxiliary.getAvailableListModel();
                    SortableListModel<String> selectedListModel = ObjectClassEditorPanel.this.auxiliary.getSelectedListModel();
                    DefaultComboBoxModel structuralModel = (DefaultComboBoxModel)ObjectClassEditorPanel.this.structural.getModel();
                    structuralModel.removeAllElements();
                    availableListModel.clear();
                    selectedListModel.clear();
                    for (String string : structuralOcs) {
                        structuralModel.addElement(string);
                    }
                    for (String string : auxiliaryOcs) {
                        availableListModel.add(string);
                    }
                    if (currentStruct != null) {
                        ObjectClassEditorPanel.this.structural.setSelectedItem(currentStruct);
                    }
                    for (String string : currentAux) {
                        availableListModel.remove(string);
                        selectedListModel.add(string);
                    }
                    selectedListModel.fireContentsChanged(selectedListModel, 0, selectedListModel.getSize());
                    availableListModel.fireContentsChanged(availableListModel, 0, availableListModel.getSize());
                    ObjectClassEditorPanel.this.setEnabledOK(true);
                }
            });
        } else {
            this.updateErrorPane(this.errorPane, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_SUMMARY.get(), ColorAndFontConstants.errorTitleFont, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get(), ColorAndFontConstants.defaultFont);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ObjectClassEditorPanel.this.setEnabledOK(false);
                }
            });
        }
    }

    public boolean valueChanged() {
        return this.valueChanged;
    }

    @Override
    public boolean requiresScroll() {
        return false;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 2;
        this.addErrorPane(gbc);
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        JLabel l = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_STRUCTURAL_OBJECTCLASS_LABEL.get());
        this.add((Component)l, gbc);
        ++gbc.gridx;
        gbc.insets.left = 10;
        gbc.anchor = 17;
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.structural = Utilities.createComboBox();
        this.structural.setModel(model);
        gbc.weightx = 1.0;
        this.add((Component)this.structural, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        l = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_AUXILIARY_OBJECTCLASS_LABEL.get());
        this.add((Component)l, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.auxiliary = new AddRemovePanel<String>(String.class);
        gbc.insets.left = 30;
        this.add(this.auxiliary, gbc);
    }
}

