/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.opends.guitools.controlpanel.ui.NewOrganizationPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class NewDomainPanel
extends NewOrganizationPanel {
    private static final long serialVersionUID = -595396547491445219L;

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_NEW_DOMAIN_PANEL_TITLE.get();
    }

    @Override
    protected Message getProgressDialogTitle() {
        return AdminToolMessages.INFO_CTRL_NEW_DOMAIN_PANEL_TITLE.get();
    }

    @Override
    protected void checkSyntax(ArrayList<Message> errors) {
        for (JLabel label : this.labels) {
            this.setPrimaryValid(label);
        }
        JTextField[] requiredFields = new JTextField[]{this.name};
        Message[] msgs = new Message[]{AdminToolMessages.ERR_CTRL_PANEL_NAME_OF_DOMAIN_REQUIRED.get()};
        for (int i = 0; i < requiredFields.length; ++i) {
            String v = requiredFields[i].getText().trim();
            if (v.length() != 0) continue;
            errors.add(msgs[i]);
        }
    }

    @Override
    protected void updateDNValue() {
        String value = this.name.getText().trim();
        if (value.length() > 0) {
            String rdn = Utilities.getRDNString("dc", value);
            this.dn.setText(rdn + "," + this.parentNode.getDN());
        } else {
            this.dn.setText("," + this.parentNode.getDN());
        }
    }

    @Override
    protected String getLDIF() {
        StringBuilder sb = new StringBuilder();
        sb.append("dn: " + this.dn.getText() + "\n");
        String[] attrNames = new String[]{"dc", "description"};
        JTextField[] textFields = new JTextField[]{this.name, this.description};
        sb.append("objectclass: top\n");
        sb.append("objectclass: domain\n");
        for (int i = 0; i < attrNames.length; ++i) {
            String value = textFields[i].getText().trim();
            if (value.length() <= 0) continue;
            sb.append(attrNames[i] + ": " + value + "\n");
        }
        return sb.toString();
    }
}

