/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ControlCenterMainPane;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.GenericMenuBar;
import org.opends.guitools.controlpanel.ui.RefreshOptionsPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class MainMenuBar
extends GenericMenuBar {
    private static final long serialVersionUID = 6441273044772077947L;
    private GenericDialog dlg;
    private RefreshOptionsPanel panel;

    public MainMenuBar(ControlPanelInfo info) {
        super(info);
        this.addMenus();
        if (Utilities.isMacOS()) {
            this.setMacOSQuitHandler();
        }
    }

    protected void addMenus() {
        this.add(this.createFileMenuBar());
        this.add(this.createViewMenuBar());
        this.add(this.createHelpMenuBar());
    }

    public void quitClicked() {
        HashSet<String> runningTasks = new HashSet<String>();
        for (Task task : this.getInfo().getTasks()) {
            if (task.getState() != Task.State.RUNNING) continue;
            runningTasks.add(task.getTaskDescription().toString());
        }
        boolean confirmed = true;
        if (runningTasks.size() > 0) {
            String allTasks = Utilities.getStringFromCollection(runningTasks, "<br>");
            Message title = AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get();
            Message msg = AdminToolMessages.INFO_CTRL_PANEL_RUNNING_TASKS_CONFIRMATION_DETAILS.get(allTasks);
            confirmed = Utilities.displayConfirmationDialog(Utilities.getParentDialog(this), title, msg);
        }
        if (confirmed) {
            System.exit(0);
        }
    }

    protected JMenu createFileMenuBar() {
        JMenu menu = Utilities.createMenu(AdminToolMessages.INFO_CTRL_PANEL_FILE_MENU.get(), AdminToolMessages.INFO_CTRL_PANEL_FILE_MENU_DESCRIPTION.get());
        menu.setMnemonic(70);
        JMenuItem menuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_CONNECT_TO_SERVER_MENU.get());
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainMenuBar.this.connectToServerClicked();
            }
        });
        menu.add(menuItem);
        if (!Utilities.isMacOS()) {
            menuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_EXIT_MENU.get());
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    MainMenuBar.this.quitClicked();
                }
            });
            menu.add(menuItem);
        }
        return menu;
    }

    protected JMenu createViewMenuBar() {
        JMenu menu = Utilities.createMenu(AdminToolMessages.INFO_CTRL_PANEL_VIEW_MENU.get(), AdminToolMessages.INFO_CTRL_PANEL_HELP_VIEW_DESCRIPTION.get());
        menu.setMnemonic(86);
        JMenuItem menuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_REFRESH_MENU.get());
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainMenuBar.this.refreshOptionsClicked();
            }
        });
        menu.add(menuItem);
        return menu;
    }

    private void setMacOSQuitHandler() {
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
            Object macApplication = applicationClass.getConstructor(null).newInstance(null);
            InvocationHandler adapter = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object event = args[0];
                    if (method.getName().equals("handleQuit")) {
                        MainMenuBar.this.quitClicked();
                        Method setHandledMethod = event.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
                        setHandledMethod.invoke(event, Boolean.FALSE);
                    }
                    return null;
                }
            };
            Method addListenerMethod = applicationClass.getDeclaredMethod("addApplicationListener", applicationListenerClass);
            Object proxy = Proxy.newProxyInstance(MainMenuBar.class.getClassLoader(), new Class[]{applicationListenerClass}, adapter);
            addListenerMethod.invoke(macApplication, proxy);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void refreshOptionsClicked() {
        if (this.panel == null) {
            this.panel = new RefreshOptionsPanel();
            this.panel.setInfo(this.getInfo());
            this.dlg = new GenericDialog(Utilities.getFrame(this), this.panel);
            this.dlg.setModal(true);
            Utilities.centerGoldenMean(this.dlg, Utilities.getFrame(this));
        }
        this.dlg.setVisible(true);
        if (!this.panel.isCanceled()) {
            this.getInfo().setPoolingPeriod(this.panel.getPoolingPeriod());
            this.getInfo().stopPooling();
            this.getInfo().startPooling();
        }
    }

    protected void connectToServerClicked() {
        HashSet<String> runningTasks = new HashSet<String>();
        for (Task task : this.getInfo().getTasks()) {
            if (task.getState() != Task.State.RUNNING) continue;
            runningTasks.add(task.getTaskDescription().toString());
        }
        boolean confirmed = true;
        if (runningTasks.size() > 0) {
            String allTasks = Utilities.getStringFromCollection(runningTasks, "<br>");
            Message title = AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get();
            Message msg = AdminToolMessages.INFO_CTRL_PANEL_RUNNING_TASKS_CHANGE_SERVER_CONFIRMATION_DETAILS.get(allTasks);
            confirmed = Utilities.displayConfirmationDialog(Utilities.getParentDialog(this), title, msg);
        }
        if (confirmed) {
            GenericDialog dlg = ControlCenterMainPane.getLocalOrRemoteDialog(this.getInfo());
            Utilities.centerGoldenMean(dlg, Utilities.getFrame(this));
            dlg.setVisible(true);
        }
    }
}

