/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.ui.AbstractBrowseEntriesPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.GenericFrame;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.Message;

public class LDAPEntrySelectionPanel
extends AbstractBrowseEntriesPanel {
    private Message title;
    private Filter f;
    private String[] dns;
    private static final long serialVersionUID = -8140540064410029902L;

    public void setMultipleSelection(boolean multiple) {
        this.treePane.getTree().getSelectionModel().setSelectionMode(multiple ? 4 : 1);
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        super.toBeDisplayed(visible);
        if (visible) {
            this.dns = new String[0];
        }
    }

    @Override
    public Message getTitle() {
        return this.title;
    }

    @Override
    public void okClicked() {
        this.dns = this.retrieveDNs();
        super.closeClicked();
    }

    public String[] getDNs() {
        return this.dns;
    }

    private String[] retrieveDNs() {
        String[] dns;
        TreePath[] paths = this.treePane.getTree().getSelectionPaths();
        if (paths != null) {
            dns = new String[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                dns[i] = ((BasicNode)paths[i].getLastPathComponent()).getDN();
            }
        } else {
            dns = new String[]{};
        }
        return dns;
    }

    @Override
    public GenericDialog.ButtonType getBrowseButtonType() {
        return GenericDialog.ButtonType.OK_CANCEL;
    }

    @Override
    protected Component createMainPanel() {
        JComponent p = this.createTreePane();
        final JTree tree = this.treePane.getTree();
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                TreePath[] paths = tree.getSelectionPaths();
                LDAPEntrySelectionPanel.this.setEnabledOK(paths != null && paths.length > 0);
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 2) {
                    LDAPEntrySelectionPanel.this.okClicked();
                }
            }
        };
        tree.addMouseListener(mouseListener);
        JScrollPane treeScroll = Utilities.createScrollPane(p);
        treeScroll.setPreferredSize(new Dimension(treeScroll.getPreferredSize().width + 30, 4 * treeScroll.getPreferredSize().height));
        return treeScroll;
    }

    public Filter getFilter() {
        return this.f;
    }

    public void setFilter(Filter filter) {
        this.f = filter;
        switch (this.f) {
            case USERS: {
                this.filterAttribute.setSelectedItem(USER_FILTER);
                this.filter.setText("*");
                break;
            }
            case GROUPS: {
                this.filterAttribute.setSelectedItem(GROUP_FILTER);
                this.filter.setText("*");
                break;
            }
            case DYNAMIC_GROUPS: {
                this.filterAttribute.setSelectedItem(LDAP_FILTER);
                this.filter.setText("objectClass=groupOfURLs");
                break;
            }
            case STATIC_GROUPS: {
                this.filterAttribute.setSelectedItem(LDAP_FILTER);
                this.filter.setText("objectClass=groupOfUniqueNames");
                break;
            }
            case DEFAULT: {
                Object o = this.filterAttribute.getItemAt(0);
                this.filterAttribute.setSelectedItem(o);
                this.filter.setText("");
            }
        }
        if (this.controller != null) {
            this.applyButtonClicked();
        }
    }

    public void setTitle(Message title) {
        this.title = title;
        Window w = Utilities.getParentDialog(this);
        if (w instanceof GenericDialog) {
            ((GenericDialog)w).updateTitle();
        } else if (w instanceof GenericFrame) {
            ((GenericFrame)w).updateTitle();
        }
    }

    public static enum Filter {
        USERS,
        GROUPS,
        DYNAMIC_GROUPS,
        STATIC_GROUPS,
        DEFAULT;

    }
}

