/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.SortableTableModel;
import org.opends.guitools.controlpanel.event.BrowseActionListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.LabelWithHelpIcon;
import org.opends.guitools.controlpanel.ui.renderer.AttributeCellEditor;
import org.opends.guitools.controlpanel.ui.renderer.LDAPEntryTableCellRenderer;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.util.Utils;
import org.opends.server.tools.JavaPropertiesTool;
import org.opends.server.types.OpenDsException;

public class JavaPropertiesPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -7886215660289880597L;
    private JTextField javaHome;
    private JRadioButton useOpenDSJavaHome;
    private JRadioButton useSpecifiedJavaHome;
    private JButton browse;
    private JLabel lJavaHome;
    private JRadioButton useOpenDSJavaArgs;
    private JRadioButton useSpecifiedJavaArgs;
    private JLabel lJavaArgs;
    private JTable argumentsTable;
    private JavaArgumentsTableModel argumentsTableModel;
    private JScrollPane argumentsScroll;
    private AttributeCellEditor editor;
    private JEditorPane lInitContents;
    private JCheckBox showAll;
    private Set<JavaArgumentsDescriptor> readJavaArguments = new HashSet<JavaArgumentsDescriptor>();
    private Set<JavaArgumentsDescriptor> currentJavaArguments = new HashSet<JavaArgumentsDescriptor>();
    private Set<String> allScriptNames = new HashSet<String>();
    private Set<String> relevantScriptNames;
    private String readJavaHome;
    private boolean readUseOpenDSJavaHome;
    private boolean readUseOpenDSJavaArgs;
    private boolean initialized;
    private boolean previousLocal;
    private Message READING_JAVA_SETTINGS;
    JComponent[] comps;

    public JavaPropertiesPanel() {
        String[] names;
        for (String name : names = new String[]{"start-ds", "import-ldif.offline", "backup.online", "base64", "create-rc-script", "dsconfig", "dsreplication", "dsframework", "export-ldif.online", "import-ldif.online", "ldapcompare", "ldapdelete", "ldapmodify", "ldappasswordmodify", "ldapsearch", "list-backends", "manage-account", "manage-tasks", "restore.online", "stop-ds", "status", "control-panel", "uninstall", "setup", "backup.offline", "encode-password", "export-ldif.offline", "ldif-diff", "ldifmodify", "ldifsearch", "make-ldif", "rebuild-index", "restore.offline", "upgrade", "verify-index", "dbtest"}) {
            this.allScriptNames.add(name);
        }
        this.relevantScriptNames = new HashSet<String>();
        String[] relevantNames = new String[]{"start-ds", "import-ldif.offline", "backup.offline", "export-ldif.offline", "ldif-diff", "make-ldif", "rebuild-index", "restore.offline", "verify-index", "dbtest"};
        for (String name : relevantNames) {
            this.relevantScriptNames.add(name);
        }
        this.initialized = false;
        this.previousLocal = true;
        this.READING_JAVA_SETTINGS = AdminToolMessages.INFO_CTRL_PANEL_READING_JAVA_SETTINGS_SUMMARY.get();
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_JAVA_PROPERTIES_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.javaHome;
    }

    @Override
    public boolean requiresScroll() {
        return false;
    }

    @Override
    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        if (this.editor != null) {
            this.editor.setInfo(info);
        }
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.lJavaHome = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_JAVA_HOME_LABEL.get());
        this.useOpenDSJavaHome = Utilities.createRadioButton(Message.EMPTY);
        this.useOpenDSJavaHome.setOpaque(false);
        this.useOpenDSJavaHome.getAccessibleContext().setAccessibleName(AdminToolMessages.INFO_CTRL_PANEL_USE_OPENDS_JAVA_HOME.get().toString() + " " + AdminToolMessages.INFO_CTRL_PANEL_USE_OPENDS_JAVA_HOME_HELP.get());
        this.lJavaHome.setLabelFor(this.useOpenDSJavaHome);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        this.add((Component)this.lJavaHome, gbc);
        gbc.insets.left = 10;
        ++gbc.gridx;
        this.add((Component)this.useOpenDSJavaHome, gbc);
        gbc.gridwidth = 3;
        ++gbc.gridx;
        LabelWithHelpIcon useOpenDSJavaHomeLabel = new LabelWithHelpIcon(AdminToolMessages.INFO_CTRL_PANEL_USE_OPENDS_JAVA_HOME.get(), AdminToolMessages.INFO_CTRL_PANEL_USE_OPENDS_JAVA_HOME_HELP.get());
        gbc.insets.left = 0;
        this.add((Component)useOpenDSJavaHomeLabel, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        this.useSpecifiedJavaHome = Utilities.createRadioButton(Message.EMPTY);
        this.useSpecifiedJavaHome.setOpaque(false);
        this.useSpecifiedJavaHome.getAccessibleContext().setAccessibleName(AdminToolMessages.INFO_CTRL_PANEL_USE_SPECIFIED_OPENDS_JAVA_HOME.get().toString() + " " + AdminToolMessages.INFO_CTRL_PANEL_USE_SPECIFIED_OPENDS_JAVA_HOME_HELP.get());
        useOpenDSJavaHomeLabel.setLabelFor(this.useSpecifiedJavaHome);
        LabelWithHelpIcon useSpecifiedJavaHomeLabel = new LabelWithHelpIcon(AdminToolMessages.INFO_CTRL_PANEL_USE_SPECIFIED_OPENDS_JAVA_HOME.get(), AdminToolMessages.INFO_CTRL_PANEL_USE_SPECIFIED_OPENDS_JAVA_HOME_HELP.get());
        gbc.insets.left = 10;
        this.add((Component)this.useSpecifiedJavaHome, gbc);
        ++gbc.gridx;
        gbc.insets.left = 0;
        this.add((Component)useSpecifiedJavaHomeLabel, gbc);
        ++gbc.gridx;
        this.javaHome = Utilities.createTextField();
        useSpecifiedJavaHomeLabel.setLabelFor(this.javaHome);
        gbc.weightx = 1.0;
        gbc.insets.left = 5;
        this.add((Component)this.javaHome, gbc);
        gbc.weightx = 0.0;
        this.browse = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
        this.browse.addActionListener(new BrowseActionListener(this.javaHome, BrowseActionListener.BrowseType.LOCATION_DIRECTORY, this));
        this.browse.setOpaque(false);
        ++gbc.gridx;
        this.add((Component)this.browse, gbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.useSpecifiedJavaHome);
        group.add(this.useOpenDSJavaHome);
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        ++gbc.gridy;
        this.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)p, gbc);
        gbc.insets.top = 10;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.lJavaArgs = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_JAVA_ARGUMENTS_LABEL.get());
        this.useSpecifiedJavaArgs = Utilities.createRadioButton(Message.EMPTY);
        this.useSpecifiedJavaArgs.getAccessibleContext().setAccessibleName(AdminToolMessages.INFO_CTRL_PANEL_USE_OPENDS_JAVA_ARGS.get().toString() + " " + AdminToolMessages.INFO_CTRL_PANEL_USE_OPENDS_JAVA_ARGS_HELP.get());
        this.useSpecifiedJavaArgs.setOpaque(false);
        this.useOpenDSJavaArgs = Utilities.createRadioButton(Message.EMPTY);
        this.useOpenDSJavaArgs.setOpaque(false);
        this.lJavaArgs.setLabelFor(this.useOpenDSJavaArgs);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.insets.top = 10;
        p.add((Component)this.lJavaArgs, gbc);
        gbc.insets.left = 10;
        ++gbc.gridx;
        gbc.gridwidth = 1;
        p.add((Component)this.useOpenDSJavaArgs, gbc);
        ++gbc.gridx;
        LabelWithHelpIcon useOpenDSJavaArgsLabel = new LabelWithHelpIcon(AdminToolMessages.INFO_CTRL_PANEL_USE_OPENDS_JAVA_ARGS.get(), AdminToolMessages.INFO_CTRL_PANEL_USE_OPENDS_JAVA_ARGS_HELP.get());
        gbc.insets.left = 0;
        p.add((Component)useOpenDSJavaArgsLabel, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.insets.left = 10;
        p.add((Component)this.useSpecifiedJavaArgs, gbc);
        useOpenDSJavaArgsLabel.setLabelFor(this.useSpecifiedJavaArgs);
        this.useSpecifiedJavaArgs.getAccessibleContext().setAccessibleName(AdminToolMessages.INFO_CTRL_PANEL_USE_SPECIFIED_OPENDS_JAVA_ARGS.get().toString() + " " + AdminToolMessages.INFO_CTRL_PANEL_USE_SPECIFIED_OPENDS_JAVA_ARGS_HELP.get());
        ++gbc.gridx;
        LabelWithHelpIcon useSpecifiedJavaArgsLabel = new LabelWithHelpIcon(AdminToolMessages.INFO_CTRL_PANEL_USE_SPECIFIED_OPENDS_JAVA_ARGS.get(), AdminToolMessages.INFO_CTRL_PANEL_USE_SPECIFIED_OPENDS_JAVA_ARGS_HELP.get());
        gbc.insets.left = 0;
        p.add((Component)useSpecifiedJavaArgsLabel, gbc);
        group = new ButtonGroup();
        group.add(this.useSpecifiedJavaArgs);
        group.add(this.useOpenDSJavaArgs);
        useSpecifiedJavaArgsLabel.setLabelFor(this.useOpenDSJavaArgs);
        this.argumentsTableModel = new JavaArgumentsTableModel();
        LDAPEntryTableCellRenderer renderer = new LDAPEntryTableCellRenderer();
        this.argumentsTable = Utilities.createSortableTable(this.argumentsTableModel, renderer);
        this.editor = new AttributeCellEditor();
        if (this.getInfo() != null) {
            this.editor.setInfo(this.getInfo());
        }
        this.argumentsTable.getColumnModel().getColumn(1).setCellEditor(this.editor);
        renderer.setTable(this.argumentsTable);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.gridwidth = 2;
        this.argumentsScroll = Utilities.createScrollPane(this.argumentsTable);
        p.add((Component)this.argumentsScroll, gbc);
        this.lInitContents = Utilities.makePlainTextPane(this.READING_JAVA_SETTINGS.toString(), ColorAndFontConstants.defaultFont);
        gbc.fill = 0;
        gbc.anchor = 10;
        p.add((Component)this.lInitContents, gbc);
        this.lInitContents.setVisible(false);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        this.showAll = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_DISPLAY_ALL_COMMAND_LINES.get());
        this.showAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JavaPropertiesPanel.this.editor.stopCellEditing();
                JavaPropertiesPanel.this.currentJavaArguments = JavaPropertiesPanel.this.getCurrentJavaArguments();
                JavaPropertiesPanel.this.argumentsTableModel.setData(JavaPropertiesPanel.this.filterJavaArguments(JavaPropertiesPanel.this.currentJavaArguments));
                Utilities.updateTableSizes(JavaPropertiesPanel.this.argumentsTable, 7);
            }
        });
        ++gbc.gridy;
        gbc.insets.top = 5;
        p.add((Component)this.showAll, gbc);
        JLabel inlineHelp = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_ONLINE_COMMAND_HELP.get());
        gbc.insets.top = 3;
        ++gbc.gridy;
        p.add((Component)inlineHelp, gbc);
        inlineHelp = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_OFFLINE_COMMAND_HELP.get());
        ++gbc.gridy;
        p.add((Component)inlineHelp, gbc);
        HashSet<JavaArgumentsDescriptor> fakeArguments = new HashSet<JavaArgumentsDescriptor>();
        fakeArguments.add(new JavaArgumentsDescriptor("start-ds", "-server -XM256j"));
        fakeArguments.add(new JavaArgumentsDescriptor("stop-ds", "-client"));
        fakeArguments.add(new JavaArgumentsDescriptor("import-ds.online", "-server"));
        fakeArguments.add(new JavaArgumentsDescriptor("import-ds.offline", "-server"));
        fakeArguments.add(new JavaArgumentsDescriptor("export-ds.online", "-server"));
        this.argumentsTableModel.setData(fakeArguments);
        Utilities.updateTableSizes(this.argumentsTable, 7);
        this.comps = new JComponent[]{this.javaHome, this.useOpenDSJavaHome, this.useSpecifiedJavaHome, this.browse, this.useOpenDSJavaArgs, this.useSpecifiedJavaArgs, this.showAll};
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        final boolean isLocal = ev.getNewDescriptor().isLocal();
        if (isLocal != this.previousLocal) {
            this.previousLocal = isLocal;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!isLocal) {
                        JavaPropertiesPanel.this.displayErrorMessage(AdminToolMessages.INFO_CTRL_PANEL_SERVER_REMOTE_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_SERVER_MUST_BE_LOCAL_JAVA_PROPERTIES_SUMMARY.get());
                        JavaPropertiesPanel.this.setEnabledOK(false);
                    } else {
                        JavaPropertiesPanel.this.displayMainPanel();
                        JavaPropertiesPanel.this.setEnabledOK(true);
                    }
                }
            });
        }
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        boolean isLocal = true;
        if (this.getInfo() != null) {
            isLocal = this.getInfo().getServerDescriptor().isLocal();
        }
        if (visible && isLocal && (!this.initialized || !this.updatedByUser())) {
            this.initialized = true;
            this.initContents();
        }
    }

    protected Set<String> getAllCommandLineNames() {
        return this.allScriptNames;
    }

    protected Set<String> getRelevantCommandLineNames() {
        return this.relevantScriptNames;
    }

    private boolean updatedByUser() {
        boolean updatedByUser = !this.javaHome.getText().equals(this.readJavaHome) || this.useOpenDSJavaHome.isSelected() != this.readUseOpenDSJavaHome || this.useOpenDSJavaArgs.isSelected() != this.readUseOpenDSJavaArgs || !this.readJavaArguments.equals(this.getCurrentJavaArguments());
        return updatedByUser;
    }

    private Set<JavaArgumentsDescriptor> getCurrentJavaArguments() {
        HashSet<JavaArgumentsDescriptor> args = new HashSet<JavaArgumentsDescriptor>(this.currentJavaArguments);
        HashSet<JavaArgumentsDescriptor> tableArgs = new HashSet<JavaArgumentsDescriptor>();
        for (int i = 0; i < this.argumentsTableModel.getRowCount(); ++i) {
            tableArgs.add(this.argumentsTableModel.getJavaArguments(i));
        }
        for (JavaArgumentsDescriptor arg : tableArgs) {
            JavaArgumentsDescriptor foundJavaArgument = null;
            for (JavaArgumentsDescriptor arg1 : args) {
                if (!arg1.getCommandName().equals(arg.getCommandName())) continue;
                foundJavaArgument = arg1;
                break;
            }
            if (foundJavaArgument != null) {
                args.remove(foundJavaArgument);
            }
            args.add(arg);
        }
        return args;
    }

    private Set<JavaArgumentsDescriptor> filterJavaArguments(Set<JavaArgumentsDescriptor> args) {
        if (this.showAll.isSelected()) {
            return args;
        }
        HashSet<JavaArgumentsDescriptor> filteredArgs = new HashSet<JavaArgumentsDescriptor>();
        block0: for (String relevantName : this.getRelevantCommandLineNames()) {
            for (JavaArgumentsDescriptor arg : args) {
                if (!arg.getCommandName().equals(relevantName)) continue;
                filteredArgs.add(arg);
                continue block0;
            }
        }
        return filteredArgs;
    }

    private void initContents() {
        this.disableComponents();
        BackgroundTask<Void> worker = new BackgroundTask<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void processBackgroundTask() throws Throwable {
                String propertiesFile = JavaPropertiesPanel.this.getPropertiesFile();
                Properties properties = new Properties();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(propertiesFile));
                    JavaPropertiesTool.updateProperties(reader, properties);
                }
                catch (Throwable t) {
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                String v = properties.getProperty("overwrite-env-java-home");
                JavaPropertiesPanel.this.readUseOpenDSJavaHome = v == null || "false".equalsIgnoreCase(v.trim());
                v = properties.getProperty("overwrite-env-java-args");
                JavaPropertiesPanel.this.readUseOpenDSJavaArgs = v == null || "false".equalsIgnoreCase(v.trim());
                JavaPropertiesPanel.this.readJavaHome = properties.getProperty("default.java-home");
                if (JavaPropertiesPanel.this.readJavaHome == null) {
                    for (String script : JavaPropertiesPanel.this.getAllCommandLineNames()) {
                        JavaPropertiesPanel.this.readJavaHome = properties.getProperty(script + ".java-home");
                        if (JavaPropertiesPanel.this.readJavaHome == null) continue;
                        break;
                    }
                }
                JavaPropertiesPanel.this.readJavaArguments.clear();
                for (String script : JavaPropertiesPanel.this.getAllCommandLineNames()) {
                    v = properties.getProperty(script + ".java-args");
                    if (v != null) {
                        JavaPropertiesPanel.this.readJavaArguments.add(new JavaArgumentsDescriptor(script, v));
                        continue;
                    }
                    JavaPropertiesPanel.this.readJavaArguments.add(new JavaArgumentsDescriptor(script, ""));
                }
                return null;
            }

            @Override
            public void backgroundTaskCompleted(Void returnValue, Throwable t) {
                if (t == null) {
                    JavaPropertiesPanel.this.updateContentsOfPanelWithReadValues();
                    Utilities.updateTableSizes(JavaPropertiesPanel.this.argumentsTable, 7);
                } else {
                    String arg = t instanceof OpenDsException ? ((OpenDsException)t).getMessageObject().toString() : t.toString();
                    Message title = AdminToolMessages.ERR_CTRL_PANEL_ERR_READING_JAVA_SETTINGS_SUMMARY.get();
                    Message details = AdminToolMessages.ERR_CTRL_PANEL_READING_JAVA_SETTINGS_DETAILS.get(arg);
                    JavaPropertiesPanel.this.updateErrorPane(JavaPropertiesPanel.this.errorPane, title, ColorAndFontConstants.errorTitleFont, details, JavaPropertiesPanel.this.errorPane.getFont());
                    JavaPropertiesPanel.this.packParentDialog();
                    JavaPropertiesPanel.this.errorPane.setVisible(true);
                }
                JavaPropertiesPanel.this.enableComponents();
            }
        };
        worker.startBackgroundTask();
    }

    private void disableComponents() {
        this.setEnabledOK(false);
        this.lInitContents.setVisible(true);
        this.argumentsScroll.setVisible(false);
        for (JComponent comp : this.comps) {
            comp.setEnabled(false);
        }
    }

    private void enableComponents() {
        for (JComponent comp : this.comps) {
            comp.setEnabled(true);
        }
        this.lInitContents.setVisible(false);
        this.argumentsScroll.setVisible(true);
        this.setEnabledOK(true);
    }

    @Override
    public void cancelClicked() {
        this.updateContentsOfPanelWithReadValues();
        super.cancelClicked();
    }

    @Override
    public void okClicked() {
        this.editor.stopCellEditing();
        ArrayList<Message> javaHomeErrors = new ArrayList<Message>();
        String f = this.javaHome.getText().trim();
        if (f.length() > 0) {
            File file = new File(f);
            if (!file.exists()) {
                javaHomeErrors.add(AdminToolMessages.ERR_CTRL_PANEL_JAVA_PATH_DOES_NOT_EXIST.get(f));
            } else if (!file.isDirectory()) {
                javaHomeErrors.add(AdminToolMessages.ERR_CTRL_PANEL_JAVA_PATH_NOT_A_DIRECTORY.get(f));
            } else {
                File javaFile = this.getJavaFile(file);
                if (!javaFile.exists()) {
                    javaHomeErrors.add(AdminToolMessages.ERR_CTRL_PANEL_JAVA_BINARY_NOT_FOUND.get(javaFile.toString()));
                }
            }
        }
        if (javaHomeErrors.size() == 0) {
            final HashSet<String> providedArguments = new HashSet<String>();
            for (JavaArgumentsDescriptor cmd : this.getCurrentJavaArguments()) {
                String args = cmd.getJavaArguments().trim();
                if (args.length() <= 0) continue;
                providedArguments.add(args);
            }
            this.disableComponents();
            this.lInitContents.setText(AdminToolMessages.INFO_CTRL_PANEL_CHECKING_JAVA_OPTIONS_SUMMARY.get().toString());
            BackgroundTask<List<Message>> worker = new BackgroundTask<List<Message>>(){
                private boolean isConfirmation = false;

                @Override
                public List<Message> processBackgroundTask() throws Throwable {
                    String userJVM = JavaPropertiesPanel.this.javaHome.getText();
                    ArrayList<Message> errorMessages = new ArrayList<Message>();
                    ArrayList<Message> confirmationMessages = new ArrayList<Message>();
                    String defaultJVM = System.getenv("OPENDJ_JAVA_HOME");
                    if (defaultJVM == null) {
                        defaultJVM = System.getProperty("java.home");
                    }
                    String[] jvms = JavaPropertiesPanel.this.useSpecifiedJavaHome.isSelected() ? new String[]{userJVM} : (userJVM != null && userJVM.trim().length() > 0 ? new String[]{defaultJVM, userJVM} : new String[]{defaultJVM});
                    for (String jvm : jvms) {
                        HashSet<String> notWorkingArgs = new HashSet<String>();
                        String installPath = JavaPropertiesPanel.this.getInfo().getServerDescriptor().getInstallPath();
                        if (!Utils.supportsOption("", jvm, installPath)) {
                            if (jvm == userJVM && !JavaPropertiesPanel.this.useSpecifiedJavaHome.isSelected()) {
                                errorMessages.add(AdminToolMessages.ERR_CTRL_PANEL_NOT_WORKING_FALLBACK_JVM_DETAILS.get(jvm));
                            } else {
                                errorMessages.add(AdminToolMessages.ERR_CTRL_PANEL_NOT_WORKING_JVM_DETAILS.get(jvm));
                            }
                        } else {
                            for (String arg : providedArguments) {
                                if (Utils.supportsOption(arg, jvm, installPath)) continue;
                                notWorkingArgs.add(arg);
                            }
                        }
                        if (notWorkingArgs.size() <= 0) continue;
                        File javaFile = JavaPropertiesPanel.this.getJavaFile(new File(jvm));
                        Message confirmationMessage = JavaPropertiesPanel.this.useSpecifiedJavaArgs.isSelected() ? AdminToolMessages.INFO_CTRL_PANEL_CONFIRM_NOT_WORKING_ARGUMENTS_DETAILS.get(javaFile.toString(), Utilities.getStringFromCollection(notWorkingArgs, "<br>-")) : AdminToolMessages.INFO_CTRL_PANEL_CONFIRM_NOT_WORKING_FALLBACK_ARGUMENTS_DETAILS.get(javaFile.toString(), Utilities.getStringFromCollection(notWorkingArgs, "<br>-"));
                        confirmationMessages.add(confirmationMessage);
                    }
                    this.isConfirmation = errorMessages.isEmpty();
                    if (!errorMessages.isEmpty()) {
                        return errorMessages;
                    }
                    return confirmationMessages;
                }

                @Override
                public void backgroundTaskCompleted(List<Message> returnValue, Throwable t) {
                    if (t == null) {
                        boolean confirm = false;
                        if (this.isConfirmation && !returnValue.isEmpty()) {
                            confirm = JavaPropertiesPanel.this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), returnValue.iterator().next());
                        } else if (!this.isConfirmation && !returnValue.isEmpty()) {
                            JavaPropertiesPanel.this.displayErrorDialog(returnValue);
                        } else {
                            confirm = true;
                        }
                        if (confirm) {
                            JavaPropertiesPanel.this.launchTask();
                        }
                    } else {
                        String arg = t instanceof OpenDsException ? ((OpenDsException)t).getMessageObject().toString() : t.toString();
                        Message title = AdminToolMessages.ERR_CTRL_PANEL_ERROR_CHECKING_JAVA_SETTINGS_SUMMARY.get();
                        Message details = AdminToolMessages.ERR_CTRL_PANEL_ERROR_CHECKING_JAVA_SETTINGS_DETAILS.get(arg);
                        JavaPropertiesPanel.this.updateErrorPane(JavaPropertiesPanel.this.errorPane, title, ColorAndFontConstants.errorTitleFont, details, JavaPropertiesPanel.this.errorPane.getFont());
                        JavaPropertiesPanel.this.packParentDialog();
                        JavaPropertiesPanel.this.errorPane.setVisible(true);
                    }
                    JavaPropertiesPanel.this.enableComponents();
                    JavaPropertiesPanel.this.lInitContents.setText(JavaPropertiesPanel.this.READING_JAVA_SETTINGS.toString());
                }
            };
            worker.startBackgroundTask();
            return;
        }
        if (this.useSpecifiedJavaHome.isSelected()) {
            this.displayErrorDialog(javaHomeErrors);
        } else {
            Message msg2;
            ArrayList<String> s = new ArrayList<String>();
            for (Message msg2 : javaHomeErrors) {
                s.add(msg2.toString());
            }
            ArrayList<Message> msgs = new ArrayList<Message>();
            msg2 = AdminToolMessages.ERR_CTRL_PANEL_GENERIC_ERROR_FALLBACK_JAVAHOME.get(f, Utilities.getStringFromCollection(s, "<br>-"));
            msgs.add(msg2);
            this.displayErrorDialog(msgs);
        }
    }

    private File getJavaFile(File javaHome) {
        File javaFile = new File(javaHome, "bin");
        javaFile = Utilities.isWindows() ? new File(javaFile, "java.exe") : new File(javaFile, "java");
        return javaFile;
    }

    private void launchTask() {
        ArrayList<Message> errors = new ArrayList<Message>();
        ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_JAVA_PROPERTIES_TITLE.get(), this.getInfo());
        JavaPropertiesTask newTask = new JavaPropertiesTask(this.getInfo(), dlg);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        if (errors.size() == 0) {
            this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_UPDATING_JAVA_SETTINGS_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_UPDATING_JAVA_SETTINGS_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_UPDATING_JAVA_SETTINGS_SUCCESSFUL.get(), AdminToolMessages.ERR_CTRL_PANEL_UPDATING_JAVA_SETTINGS_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_UPDATING_JAVA_SETTINGS_ERROR_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_UPDATING_JAVA_SETTINGS_ERROR_CODE, dlg);
            dlg.setVisible(true);
            Utilities.getParentDialog(this).setVisible(false);
            this.readJavaHome = this.javaHome.getText();
            this.readUseOpenDSJavaHome = this.useOpenDSJavaHome.isSelected();
            this.readUseOpenDSJavaArgs = this.useOpenDSJavaArgs.isSelected();
            this.readJavaArguments = this.getCurrentJavaArguments();
        } else {
            this.displayErrorDialog(errors);
        }
    }

    private String getPropertiesFile() {
        String installPath = this.getInfo().getServerDescriptor().getInstancePath();
        String propertiesFile = Utils.getPath(Utilities.getInstanceRootDirectory(installPath).getAbsolutePath(), Installation.RELATIVE_JAVA_PROPERTIES_FILE);
        return propertiesFile;
    }

    private void updateContentsOfPanelWithReadValues() {
        if (this.readJavaHome != null) {
            this.javaHome.setText(this.readJavaHome);
        } else {
            this.javaHome.setText("");
        }
        this.useOpenDSJavaHome.setSelected(this.readUseOpenDSJavaHome);
        this.useSpecifiedJavaHome.setSelected(!this.readUseOpenDSJavaHome);
        this.useOpenDSJavaArgs.setSelected(this.readUseOpenDSJavaArgs);
        this.useSpecifiedJavaArgs.setSelected(!this.readUseOpenDSJavaArgs);
        this.currentJavaArguments.clear();
        this.currentJavaArguments.addAll(this.readJavaArguments);
        this.argumentsTableModel.setData(this.filterJavaArguments(this.currentJavaArguments));
    }

    protected class JavaPropertiesTask
    extends Task {
        private Set<String> backendSet;
        private String defaultJavaHome;
        private boolean overwriteOpenDSJavaHome;
        private boolean overwriteOpenDSJavaArgs;
        Set<JavaArgumentsDescriptor> arguments;

        public JavaPropertiesTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(info, dlg);
            this.arguments = new HashSet<JavaArgumentsDescriptor>();
            this.backendSet = new HashSet<String>();
            this.defaultJavaHome = JavaPropertiesPanel.this.javaHome.getText().trim();
            this.overwriteOpenDSJavaHome = JavaPropertiesPanel.this.useSpecifiedJavaHome.isSelected();
            this.overwriteOpenDSJavaArgs = JavaPropertiesPanel.this.useSpecifiedJavaArgs.isSelected();
            this.arguments = JavaPropertiesPanel.this.getCurrentJavaArguments();
        }

        @Override
        public Task.Type getType() {
            return Task.Type.JAVA_SETTINGS_UPDATE;
        }

        @Override
        public Set<String> getBackends() {
            return this.backendSet;
        }

        @Override
        public Message getTaskDescription() {
            return AdminToolMessages.INFO_CTRL_PANEL_UPDATE_JAVA_SETTINGS_TASK_DESCRIPTION.get();
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (!this.isServerRunning() && this.state == Task.State.RUNNING && this.runningOnSameServer(taskToBeLaunched)) {
                TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
                backends.retainAll(this.getBackends());
                if (backends.size() > 0) {
                    incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                    canLaunch = false;
                }
            }
            return canLaunch;
        }

        @Override
        protected String getCommandLinePath() {
            return null;
        }

        protected ArrayList<String> getCommandLineArguments() {
            return new ArrayList<String>();
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                this.returnCode = this.updateJavaSettings();
                this.state = this.returnCode == 0 ? Task.State.FINISHED_SUCCESSFULLY : Task.State.FINISHED_WITH_ERROR;
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int updateJavaSettings() throws IOException {
            final String propertiesFile = JavaPropertiesPanel.this.getPropertiesFile();
            ArrayList<String> commentLines = new ArrayList<String>();
            BufferedReader reader = null;
            try {
                String trimmedLine;
                String line;
                reader = new BufferedReader(new FileReader(propertiesFile));
                while ((line = reader.readLine()) != null && ((trimmedLine = line.trim()).startsWith("#") || trimmedLine.length() == 0)) {
                    commentLines.add(line);
                }
            }
            catch (IOException ioe) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable t) {}
                }
            }
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(propertiesFile, false));
                for (String comment : commentLines) {
                    writer.write(comment);
                    writer.newLine();
                }
                writer.newLine();
                writer.write("overwrite-env-java-home=" + this.overwriteOpenDSJavaHome);
                writer.newLine();
                writer.write("overwrite-env-java-args=" + this.overwriteOpenDSJavaArgs);
                writer.newLine();
                writer.newLine();
                if (this.defaultJavaHome != null && this.defaultJavaHome.length() > 0) {
                    writer.write("default.java-home=" + this.defaultJavaHome);
                    writer.newLine();
                    writer.newLine();
                }
                for (JavaArgumentsDescriptor desc : this.arguments) {
                    String args = desc.getJavaArguments();
                    if (args.trim().length() <= 0) continue;
                    writer.newLine();
                    writer.write(desc.getCommandName() + ".java-args=" + args);
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable t) {}
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JavaPropertiesTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_ACTION_TO_UPDATE_JAVA_PROPERTIES.get(propertiesFile, JavaPropertiesTask.this.getCommandLinePath("dsjavaproperties")).toString(), ColorAndFontConstants.progressFont));
                }
            });
            String[] args = new String[]{"--quiet"};
            return JavaPropertiesTool.mainCLI(args);
        }
    }

    protected class JavaArgumentsTableModel
    extends SortableTableModel
    implements Comparator<JavaArgumentsDescriptor> {
        private static final long serialVersionUID = 8288418995255677560L;
        private Set<JavaArgumentsDescriptor> data = new HashSet<JavaArgumentsDescriptor>();
        private ArrayList<String[]> dataArray = new ArrayList();
        private ArrayList<JavaArgumentsDescriptor> argsArray = new ArrayList();
        private final String[] COLUMN_NAMES = new String[]{this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_COMMAND_LINE_NAME_COLUMN.get(), 40), this.getHeader(AdminToolMessages.INFO_CTRL_PANEL_JAVA_ARGUMENTS_COLUMN.get(), 40)};
        private int sortColumn = 0;
        private boolean sortAscending = true;

        protected JavaArgumentsTableModel() {
        }

        public void setData(Set<JavaArgumentsDescriptor> newData) {
            if (!newData.equals(this.data)) {
                this.data.clear();
                this.data.addAll(newData);
                this.updateDataArray();
                this.fireTableDataChanged();
            }
        }

        @Override
        public int compare(JavaArgumentsDescriptor desc1, JavaArgumentsDescriptor desc2) {
            int[] possibleResults = new int[]{desc1.getCommandName().compareTo(desc2.getCommandName()), desc1.getJavaArguments().compareTo(desc2.getJavaArguments())};
            int result = possibleResults[this.sortColumn];
            if (result == 0) {
                for (int i : possibleResults) {
                    if (i == 0) continue;
                    result = i;
                    break;
                }
            }
            if (!this.sortAscending) {
                result = -result;
            }
            return result;
        }

        @Override
        public void forceResort() {
            this.updateDataArray();
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return this.dataArray.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.dataArray.get(row)[col];
        }

        @Override
        public String getColumnName(int col) {
            return this.COLUMN_NAMES[col];
        }

        public JavaArgumentsDescriptor getJavaArguments(int row) {
            return this.argsArray.get(row);
        }

        @Override
        public boolean isSortAscending() {
            return this.sortAscending;
        }

        @Override
        public void setSortAscending(boolean sortAscending) {
            this.sortAscending = sortAscending;
        }

        @Override
        public int getSortColumn() {
            return this.sortColumn;
        }

        @Override
        public void setSortColumn(int sortColumn) {
            this.sortColumn = sortColumn;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.dataArray.get((int)row)[col] = (String)value;
            JavaArgumentsDescriptor currentArg = this.argsArray.get(row);
            JavaArgumentsDescriptor newArg = new JavaArgumentsDescriptor(currentArg.getCommandName(), (String)value);
            this.argsArray.set(row, newArg);
            this.data.remove(currentArg);
            this.data.add(newArg);
            this.fireTableCellUpdated(row, col);
        }

        private void updateDataArray() {
            TreeSet<JavaArgumentsDescriptor> sortedSet = new TreeSet<JavaArgumentsDescriptor>(this);
            sortedSet.addAll(this.data);
            this.dataArray.clear();
            this.argsArray.clear();
            for (JavaArgumentsDescriptor arg : sortedSet) {
                String[] s = this.getLine(arg);
                this.dataArray.add(s);
                this.argsArray.add(arg);
            }
        }

        protected String[] getLine(JavaArgumentsDescriptor desc) {
            String cmd = desc.getCommandName();
            if (cmd.equalsIgnoreCase("start-ds")) {
                cmd = AdminToolMessages.INFO_CTRL_PANEL_SERVER_RUNTIME_CELL.get(desc.getCommandName()).toString();
            } else if (cmd.endsWith(".online")) {
                int index = cmd.lastIndexOf(".online");
                cmd = AdminToolMessages.INFO_CTRL_PANEL_ONLINE_COMMAND_LINE_CELL.get(cmd.substring(0, index)).toString();
            } else if (desc.getCommandName().endsWith(".offline")) {
                int index = cmd.lastIndexOf(".offline");
                cmd = AdminToolMessages.INFO_CTRL_PANEL_OFFLINE_COMMAND_LINE_CELL.get(cmd.substring(0, index)).toString();
            }
            return new String[]{cmd, desc.getJavaArguments()};
        }
    }

    private class JavaArgumentsDescriptor {
        private String commandName;
        private String javaArguments;
        private int hashCode;
        private String toString;

        public JavaArgumentsDescriptor(String commandName, String javaArguments) {
            this.commandName = commandName;
            this.javaArguments = javaArguments;
            this.hashCode = commandName.hashCode() + javaArguments.hashCode();
            this.toString = commandName + ": " + javaArguments;
        }

        public String getCommandName() {
            return this.commandName;
        }

        public String getJavaArguments() {
            return this.javaArguments;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.toString;
        }

        public boolean equals(Object o) {
            boolean equals;
            boolean bl = equals = o == this;
            if (!equals && o instanceof JavaArgumentsDescriptor) {
                equals = this.commandName.equals(((JavaArgumentsDescriptor)o).getCommandName()) && this.javaArguments.equals(((JavaArgumentsDescriptor)o).getJavaArguments());
            }
            return equals;
        }
    }
}

