/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.opends.guitools.controlpanel.datamodel.BasicMonitoringAttributes;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.ui.GeneralMonitoringPanel;
import org.opends.guitools.controlpanel.ui.components.BasicExpander;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;

public class JavaInformationMonitoringPanel
extends GeneralMonitoringPanel {
    private static final long serialVersionUID = 9031734563799969830L;
    private List<BasicMonitoringAttributes> generalAttributes = new ArrayList<BasicMonitoringAttributes>();
    private List<BasicMonitoringAttributes> extraAttributes;
    private ArrayList<JComponent> generalMonitoringComps;
    private List<String> memoryAttributes;
    private List<JLabel> memoryLabels;
    private JPanel memoryPanel;

    public JavaInformationMonitoringPanel() {
        this.generalAttributes.add(BasicMonitoringAttributes.JVM_VERSION);
        this.generalAttributes.add(BasicMonitoringAttributes.JVM_VENDOR);
        this.generalAttributes.add(BasicMonitoringAttributes.JVM_ARCHITECTURE);
        this.generalAttributes.add(BasicMonitoringAttributes.JVM_ARGUMENTS);
        this.generalAttributes.add(BasicMonitoringAttributes.CLASS_PATH);
        this.generalAttributes.add(BasicMonitoringAttributes.JAVA_VERSION);
        this.generalAttributes.add(BasicMonitoringAttributes.JAVA_VENDOR);
        this.extraAttributes = new ArrayList<BasicMonitoringAttributes>();
        this.extraAttributes.add(BasicMonitoringAttributes.CLASS_PATH);
        this.extraAttributes.add(BasicMonitoringAttributes.JAVA_VERSION);
        this.extraAttributes.add(BasicMonitoringAttributes.JAVA_VENDOR);
        this.generalMonitoringComps = new ArrayList();
        for (int i = 0; i < this.generalAttributes.size(); ++i) {
            if (this.generalAttributes.get(i) == BasicMonitoringAttributes.CLASS_PATH || this.generalAttributes.get(i) == BasicMonitoringAttributes.JVM_ARGUMENTS) {
                JEditorPane pane = new JEditorPane();
                pane.setEditable(false);
                pane.setBorder(new EmptyBorder(0, 0, 0, 0));
                pane.setOpaque(false);
                pane.setFocusCycleRoot(false);
                this.generalMonitoringComps.add(pane);
                continue;
            }
            this.generalMonitoringComps.add(Utilities.createDefaultLabel());
        }
        this.memoryAttributes = new ArrayList<String>();
        this.memoryLabels = new ArrayList<JLabel>();
        this.createLayout();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.generalMonitoringComps.get(0);
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel lTitle = Utilities.createTitleLabel(AdminToolMessages.INFO_CTRL_PANEL_JAVA_INFORMATION.get());
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.top = 5;
        gbc.insets.bottom = 7;
        this.add((Component)lTitle, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        for (int i = 0; i < this.generalAttributes.size(); ++i) {
            if (this.extraAttributes.contains(this.generalAttributes.get(i))) continue;
            JLabel l = Utilities.createPrimaryLabel(JavaInformationMonitoringPanel.getLabel(this.generalAttributes.get(i)));
            ++gbc.gridy;
            gbc.insets.left = 0;
            gbc.insets.right = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            boolean isTextComponent = this.generalMonitoringComps.get(i) instanceof JTextComponent;
            gbc.anchor = isTextComponent ? 18 : 17;
            this.add((Component)l, gbc);
            gbc.insets.left = 10;
            gbc.gridx = 1;
            if (isTextComponent) {
                gbc.insets.right = 10;
                gbc.weightx = 1.0;
                gbc.fill = 1;
                this.add((Component)this.generalMonitoringComps.get(i), gbc);
                continue;
            }
            gbc.weightx = 0.0;
            gbc.fill = 2;
            this.add((Component)this.generalMonitoringComps.get(i), gbc);
        }
        final BasicExpander extraExpander = new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_EXTRA_JAVA_ATTRIBUTES.get());
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        ++gbc.gridy;
        this.add((Component)extraExpander, gbc);
        final JPanel extraGeneralPanel = new JPanel(new GridBagLayout());
        gbc.insets.left = 15;
        ++gbc.gridy;
        this.add((Component)extraGeneralPanel, gbc);
        extraGeneralPanel.setOpaque(false);
        extraGeneralPanel.setVisible(false);
        final BasicExpander memoryExpander = new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_JAVA_MEMORY_ATTRIBUTES.get());
        ++gbc.gridy;
        gbc.insets.left = 0;
        this.add((Component)memoryExpander, gbc);
        this.memoryPanel = new JPanel(new GridBagLayout());
        gbc.insets.left = 15;
        ++gbc.gridy;
        this.add((Component)this.memoryPanel, gbc);
        this.memoryPanel.setOpaque(false);
        this.memoryPanel.setVisible(false);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.fill = 2;
        gbc1.gridy = 0;
        gbc1.gridx = 0;
        gbc1.gridwidth = 1;
        for (int i = 0; i < this.extraAttributes.size(); ++i) {
            int index = this.generalAttributes.indexOf(this.extraAttributes.get(i));
            JLabel l = Utilities.createPrimaryLabel(JavaInformationMonitoringPanel.getLabel(this.extraAttributes.get(i)));
            gbc1.insets.left = 0;
            gbc1.insets.right = 0;
            gbc1.gridx = 0;
            gbc1.weightx = 0.0;
            gbc1.gridwidth = 1;
            gbc1.fill = 0;
            boolean isTextComponent = this.generalMonitoringComps.get(index) instanceof JTextComponent;
            gbc1.anchor = isTextComponent ? 18 : 17;
            extraGeneralPanel.add((Component)l, gbc1);
            gbc1.insets.left = 10;
            gbc1.gridx = 1;
            if (isTextComponent) {
                gbc1.insets.right = 10;
                gbc1.weightx = 1.0;
                gbc1.fill = 1;
                extraGeneralPanel.add((Component)this.generalMonitoringComps.get(index), gbc1);
            } else {
                gbc1.weightx = 1.0;
                gbc1.fill = 2;
                extraGeneralPanel.add((Component)this.generalMonitoringComps.get(index), gbc1);
            }
            gbc1.insets.top = 10;
            ++gbc1.gridy;
        }
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                extraGeneralPanel.setVisible(extraExpander.isSelected());
            }
        };
        extraExpander.addChangeListener(changeListener);
        changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JavaInformationMonitoringPanel.this.memoryPanel.setVisible(memoryExpander.isSelected());
            }
        };
        memoryExpander.addChangeListener(changeListener);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        this.add(Box.createGlue(), gbc);
        this.setBorder(this.PANEL_BORDER);
    }

    public void updateContents() {
        int i;
        ServerDescriptor server = null;
        if (this.getInfo() != null) {
            server = this.getInfo().getServerDescriptor();
        }
        CustomSearchResult csrSystem = null;
        CustomSearchResult csrMemory = null;
        if (server != null) {
            csrSystem = server.getSystemInformationMonitor();
            csrMemory = server.getJvmMemoryUsageMonitor();
        }
        if (csrSystem != null) {
            for (i = 0; i < this.generalAttributes.size(); ++i) {
                String string = JavaInformationMonitoringPanel.getMonitoringValue(this.generalAttributes.get(i), csrSystem);
                JComponent l = this.generalMonitoringComps.get(i);
                if (l instanceof JLabel) {
                    ((JLabel)l).setText(string);
                    continue;
                }
                if (l instanceof JTextComponent) {
                    ((JTextComponent)l).setText(string);
                    continue;
                }
                throw new RuntimeException("Unexpected component: " + l);
            }
        } else {
            for (JComponent jComponent : this.generalMonitoringComps) {
                if (jComponent instanceof JLabel) {
                    ((JLabel)jComponent).setText(NO_VALUE_SET.toString());
                    continue;
                }
                if (jComponent instanceof JTextComponent) {
                    ((JTextComponent)jComponent).setText(NO_VALUE_SET.toString());
                    continue;
                }
                throw new RuntimeException("Unexpected component: " + jComponent);
            }
        }
        if (csrMemory != null) {
            if (this.memoryAttributes.isEmpty()) {
                SortedSet<String> allNames = csrMemory.getAttributeNames();
                TreeSet<String> treeSet = new TreeSet<String>();
                for (String attrName : allNames) {
                    if (attrName.equalsIgnoreCase("objectclass") || attrName.equalsIgnoreCase("cn")) continue;
                    treeSet.add(attrName);
                }
                this.memoryAttributes.addAll(treeSet);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.anchor = 17;
                gbc.gridwidth = 1;
                for (String attrName : this.memoryAttributes) {
                    JLabel l = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OPERATION_NAME_AS_LABEL.get(attrName));
                    gbc.insets.left = 0;
                    gbc.insets.right = 0;
                    gbc.gridx = 0;
                    gbc.weightx = 0.0;
                    gbc.fill = 0;
                    this.memoryPanel.add((Component)l, gbc);
                    gbc.insets.left = 10;
                    gbc.gridx = 1;
                    gbc.weightx = 1.0;
                    gbc.fill = 2;
                    JLabel valueLabel = Utilities.createDefaultLabel();
                    this.memoryLabels.add(valueLabel);
                    this.memoryPanel.add((Component)valueLabel, gbc);
                    ++gbc.gridy;
                    gbc.insets.top = 10;
                }
            }
            for (i = 0; i < this.memoryAttributes.size(); ++i) {
                Object object = Utilities.getFirstMonitoringValue(csrMemory, this.memoryAttributes.get(i));
                if (object != null) {
                    this.memoryLabels.get(i).setText(object.toString());
                    continue;
                }
                this.memoryLabels.get(i).setText(NO_VALUE_SET.toString());
            }
        } else {
            for (JLabel jLabel : this.memoryLabels) {
                jLabel.setText(NO_VALUE_SET.toString());
            }
        }
    }
}

