/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.server.util.DynamicConstants;

public class GenericDialog
extends JDialog {
    private static final long serialVersionUID = -2643144936460484112L;
    private static final Color buttonPanelBackground = ColorAndFontConstants.greyBackground;
    private JButton okButton;
    protected JButton closeButton;
    private JButton cancelButton;
    protected StatusGenericPanel panel;
    private Component lastComponentWithFocus;

    public GenericDialog(JFrame parentFrame, StatusGenericPanel panel) {
        super(parentFrame);
        JMenuBar menu;
        this.panel = panel;
        if (panel.requiresBorder()) {
            this.setDefaultBorder(panel);
        }
        if ((menu = panel.getMenuBar()) != null) {
            parentFrame.setJMenuBar(menu);
        }
        this.setResizable(true);
        JScrollPane scroll = Utilities.createScrollPane(panel);
        JPanel inputPanel = new JPanel(new GridBagLayout());
        this.setContentPane(inputPanel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        if (panel.requiresScroll()) {
            inputPanel.add((Component)scroll, gbc);
        } else {
            inputPanel.add((Component)panel, gbc);
        }
        if (panel.getButtonType() != ButtonType.NO_BUTTON) {
            ++gbc.gridy;
            gbc.weighty = 0.0;
            inputPanel.add((Component)this.createButtonsPanel(panel), gbc);
        }
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GenericDialog.this.setVisible(false);
            }
        };
        this.getRootPane().registerKeyboardAction(actionListener, stroke, 2);
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent ev) {
                GenericDialog.this.lastComponentWithFocus = ev.getComponent();
            }
        };
        this.addFocusListener(focusListener, panel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GenericDialog.this.panel.closeClicked();
            }
        });
        this.pack();
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
    }

    private void addFocusListener(FocusListener focusListener, Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component comp = container.getComponent(i);
            if (comp instanceof AbstractButton || comp instanceof JTextComponent || comp instanceof JList || comp instanceof JComboBox || comp instanceof JTable) {
                comp.addFocusListener(focusListener);
                continue;
            }
            if (!(comp instanceof JPanel) && !(comp instanceof JScrollPane) && !(comp instanceof JViewport)) continue;
            this.addFocusListener(focusListener, (Container)comp);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.lastComponentWithFocus == null) {
            this.lastComponentWithFocus = this.panel.getPreferredFocusComponent();
        }
        if (visible && this.lastComponentWithFocus != null && this.lastComponentWithFocus.isVisible()) {
            if (this.lastComponentWithFocus == null) {
                this.lastComponentWithFocus = this.panel.getPreferredFocusComponent();
            }
            this.lastComponentWithFocus.requestFocusInWindow();
        }
        this.updateDefaultButton(this.panel);
        this.panel.toBeDisplayed(visible);
        this.updateTitle();
        super.setVisible(visible);
    }

    public void setEnabledOK(boolean enable) {
        this.okButton.setEnabled(enable);
    }

    public void setEnabledCancel(boolean enable) {
        this.cancelButton.setEnabled(enable);
    }

    public void setEnabledClose(boolean enable) {
        this.closeButton.setEnabled(enable);
    }

    public void updateTitle() {
        if (this.panel.getTitle() != null) {
            this.setTitle(AdminToolMessages.INFO_CTRL_PANEL_GENERIC_TITLE.get(DynamicConstants.PRODUCT_NAME, this.panel.getTitle().toString()).toString());
        }
    }

    private void setDefaultBorder(JComponent comp) {
        Utilities.setBorder(comp, new EmptyBorder(20, 20, 20, 20));
    }

    private JPanel createButtonsPanel(final StatusGenericPanel panel) {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        ButtonType buttonType = panel.getButtonType();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        buttonsPanel.add(Box.createHorizontalGlue(), gbc);
        buttonsPanel.setOpaque(true);
        buttonsPanel.setBackground(buttonPanelBackground);
        gbc.insets = new Insets(10, 0, 10, 0);
        gbc.insets.left = 5;
        if (buttonType == ButtonType.OK_CANCEL) {
            ++gbc.gridx;
            gbc.weightx = 0.0;
            this.okButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_OK_BUTTON_LABEL.get());
            this.okButton.setOpaque(false);
            buttonsPanel.add((Component)this.okButton, gbc);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    panel.okClicked();
                }
            });
            this.okButton.setEnabled(panel.isEnableOK());
            ++gbc.gridx;
            this.cancelButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CANCEL_BUTTON_LABEL.get());
            this.cancelButton.setOpaque(false);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    panel.cancelClicked();
                }
            });
            this.cancelButton.setEnabled(panel.isEnableCancel());
            gbc.insets.right = 10;
            buttonsPanel.add((Component)this.cancelButton, gbc);
        }
        if (buttonType == ButtonType.OK) {
            ++gbc.gridx;
            gbc.weightx = 0.0;
            this.okButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_OK_BUTTON_LABEL.get());
            this.okButton.setOpaque(false);
            gbc.insets.right = 10;
            buttonsPanel.add((Component)this.okButton, gbc);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    panel.okClicked();
                }
            });
            this.okButton.setEnabled(panel.isEnableOK());
        }
        if (buttonType == ButtonType.CLOSE) {
            ++gbc.gridx;
            gbc.weightx = 0.0;
            this.closeButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CLOSE_BUTTON_LABEL.get());
            this.closeButton.setOpaque(false);
            gbc.insets.right = 10;
            buttonsPanel.add((Component)this.closeButton, gbc);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    panel.closeClicked();
                }
            });
            this.closeButton.setEnabled(panel.isEnableClose());
        }
        buttonsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorAndFontConstants.defaultBorderColor));
        return buttonsPanel;
    }

    private void updateDefaultButton(StatusGenericPanel panel) {
        ButtonType buttonType = panel.getButtonType();
        if (buttonType == ButtonType.OK_CANCEL) {
            this.getRootPane().setDefaultButton(this.okButton);
        } else if (buttonType == ButtonType.OK) {
            this.getRootPane().setDefaultButton(this.okButton);
        } else if (buttonType == ButtonType.CLOSE) {
            this.getRootPane().setDefaultButton(this.closeButton);
        }
    }

    public static enum ButtonType {
        OK_CANCEL,
        OK,
        CLOSE,
        NO_BUTTON;

    }
}

