/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigChangeListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.LocalOrRemotePanel;
import org.opends.guitools.controlpanel.ui.LoginPanel;
import org.opends.guitools.controlpanel.ui.MainActionsPane;
import org.opends.guitools.controlpanel.ui.StatusPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class ControlCenterMainPane
extends JPanel {
    private static final long serialVersionUID = -8939025523701408656L;
    private StatusPanel statusPane;
    private JLabel lAuthenticatedAs = Utilities.createInlineHelpLabel(Message.EMPTY);
    private static GenericDialog localOrRemoteDlg;
    private static GenericDialog loginDlg;

    public ControlCenterMainPane(ControlPanelInfo info) {
        super(new GridBagLayout());
        this.setOpaque(true);
        JSplitPane split = new JSplitPane(1);
        split.setOpaque(true);
        this.statusPane = new StatusPanel();
        this.statusPane.setInfo(info);
        MainActionsPane mainActionsPane = new MainActionsPane();
        mainActionsPane.setInfo(info);
        JScrollPane accordionScroll = Utilities.createScrollPane(mainActionsPane);
        accordionScroll.getViewport().setBackground(ColorAndFontConstants.greyBackground);
        split.setLeftComponent(accordionScroll);
        split.setRightComponent(this.statusPane);
        split.setResizeWeight(0.0);
        split.setDividerLocation(accordionScroll.getPreferredSize().width + 2);
        split.setPreferredSize(new Dimension(split.getPreferredSize().width + 4, split.getPreferredSize().height));
        info.addConfigChangeListener(new ConfigChangeListener(){
            private boolean lastStatusStopped;

            @Override
            public void configurationChanged(final ConfigurationChangeEvent ev) {
                boolean displayLogin;
                if (ev.getNewDescriptor().getStatus() != ServerDescriptor.ServerStatus.STARTED) {
                    this.lastStatusStopped = true;
                    displayLogin = false;
                } else if (this.lastStatusStopped && !ev.getNewDescriptor().isAuthenticated()) {
                    this.lastStatusStopped = false;
                    displayLogin = true;
                } else {
                    displayLogin = false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ControlCenterMainPane.this.updateAuthenticationLabel(ev.getNewDescriptor());
                        if (displayLogin) {
                            ControlCenterMainPane.this.getLoginDialog().setVisible(true);
                            ControlCenterMainPane.this.getLoginDialog().toFront();
                        }
                    }
                });
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)split, gbc);
        JPanel infoPanel = new JPanel(new GridBagLayout());
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        this.add((Component)infoPanel, gbc);
        infoPanel.setOpaque(false);
        infoPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorAndFontConstants.defaultBorderColor));
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        infoPanel.add((Component)this.lAuthenticatedAs, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        gbc.insets.right = 0;
        this.lAuthenticatedAs.setText("Qjlabel");
        infoPanel.add(Box.createVerticalStrut(this.lAuthenticatedAs.getPreferredSize().height), gbc);
        if (info.getServerDescriptor() != null) {
            this.updateAuthenticationLabel(info.getServerDescriptor());
        } else {
            this.lAuthenticatedAs.setText("");
        }
    }

    private GenericDialog getLoginDialog() {
        return this.statusPane.getLoginDialog();
    }

    private void updateAuthenticationLabel(ServerDescriptor server) {
        if (server.getStatus() == ServerDescriptor.ServerStatus.STARTED) {
            if (server.isAuthenticated()) {
                try {
                    String bindDN = ConnectionUtils.getBindDN(this.statusPane.getInfo().getDirContext());
                    this.lAuthenticatedAs.setText(AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATED_AS.get(bindDN).toString());
                }
                catch (Throwable throwable) {}
            } else {
                this.lAuthenticatedAs.setText(AdminToolMessages.INFO_CTRL_PANEL_NOT_AUTHENTICATED.get().toString());
            }
        } else if (server.isLocal()) {
            this.lAuthenticatedAs.setText(AdminToolMessages.INFO_CTRL_PANEL_NOT_AUTHENTICATED_SERVER_NOT_RUNNING.get().toString());
        } else {
            this.lAuthenticatedAs.setText(AdminToolMessages.INFO_CTRL_PANEL_NOT_AUTHENTICATED_SERVER_REMOTE.get(server.getHostname()).toString());
        }
    }

    public static GenericDialog getLocalOrRemoteDialog(ControlPanelInfo info) {
        if (localOrRemoteDlg == null) {
            LocalOrRemotePanel localOrRemotePanel = new LocalOrRemotePanel();
            localOrRemotePanel.setInfo(info);
            localOrRemoteDlg = new GenericDialog(Utilities.createFrame(), localOrRemotePanel);
            localOrRemoteDlg.setModal(true);
            localOrRemoteDlg.pack();
        }
        return localOrRemoteDlg;
    }

    public static GenericDialog getLocalServerLoginDialog(ControlPanelInfo info) {
        if (loginDlg == null) {
            LoginPanel loginPanel = new LoginPanel();
            loginDlg = new GenericDialog(Utilities.createFrame(), loginPanel);
            loginPanel.setInfo(info);
            loginDlg.setModal(true);
        }
        return loginDlg;
    }
}

