/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.LinkedHashSet;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;

public class BaseDNPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 2742173517231794830L;
    private JTextField dn;
    private JLabel dnLabel;
    private String baseDn;

    public BaseDNPanel() {
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_OTHER_BASE_DN_TITLE.get();
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.dnLabel = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BASE_DN_LABEL.get());
        this.add((Component)this.dnLabel, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.dn = Utilities.createLongTextField();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.dn, gbc);
        this.addBottomGlue(gbc);
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.dn;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    @Override
    public void okClicked() {
        this.setPrimaryValid(this.dnLabel);
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        if ("".equals(this.dn.getText().trim())) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_BASE_DN_PROVIDED.get());
        } else {
            try {
                DN.decode(this.dn.getText());
            }
            catch (OpenDsException ode) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_BASE_DN_PROVIDED.get(ode.getMessageObject().toString()));
            }
        }
        if (errors.size() > 0) {
            this.setPrimaryInvalid(this.dnLabel);
        }
        if (errors.isEmpty()) {
            this.baseDn = this.dn.getText().trim();
            Utilities.getParentDialog(this).setVisible(false);
        } else {
            this.displayErrorDialog(errors);
            this.dn.setSelectionStart(0);
            this.dn.setSelectionEnd(this.dn.getText().length());
            this.dn.requestFocusInWindow();
        }
    }

    @Override
    public void cancelClicked() {
        this.setPrimaryValid(this.dnLabel);
        this.baseDn = null;
        super.cancelClicked();
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        super.toBeDisplayed(visible);
        if (visible) {
            this.baseDn = null;
        }
    }
}

