/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.NewEntryTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;

public abstract class AbstractNewEntryPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 6894546787832469213L;
    protected BasicNode parentNode;
    protected BrowserController controller;

    public void setParent(BasicNode parentNode, BrowserController controller) {
        this.parentNode = parentNode;
        this.controller = controller;
    }

    protected abstract Message getProgressDialogTitle();

    protected abstract String getLDIF();

    protected abstract void checkSyntax(ArrayList<Message> var1);

    protected boolean checkSyntaxBackground() {
        return false;
    }

    @Override
    public void okClicked() {
        final ArrayList<Message> errors = new ArrayList<Message>();
        if (this.checkSyntaxBackground()) {
            BackgroundTask<Void> worker = new BackgroundTask<Void>(){

                @Override
                public Void processBackgroundTask() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    AbstractNewEntryPanel.this.checkSyntax(errors);
                    return null;
                }

                @Override
                public void backgroundTaskCompleted(Void returnValue, Throwable t) {
                    if (t != null) {
                        errors.add(AdminToolMessages.ERR_CTRL_PANEL_UNEXPECTED_DETAILS.get(t.toString()));
                    }
                    AbstractNewEntryPanel.this.displayMainPanel();
                    AbstractNewEntryPanel.this.setEnabledCancel(true);
                    AbstractNewEntryPanel.this.setEnabledOK(true);
                    AbstractNewEntryPanel.this.handleErrorsAndLaunchTask(errors);
                }
            };
            this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_CHECKING_SUMMARY.get());
            this.setEnabledCancel(false);
            this.setEnabledOK(false);
            worker.startBackgroundTask();
        } else {
            this.checkSyntax(errors);
            this.handleErrorsAndLaunchTask(errors);
        }
    }

    private void handleErrorsAndLaunchTask(ArrayList<Message> errors) {
        Entry entry = null;
        if (errors.size() == 0) {
            try {
                entry = this.getEntry();
            }
            catch (Throwable t) {
                throw new RuntimeException("Unexpected error: " + t, t);
            }
            String dn = entry.getDN().toString();
            if (this.entryExists(dn)) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_ENTRY_ALREADY_EXISTS.get(dn));
            }
        }
        if (errors.size() == 0) {
            final ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), this.getProgressDialogTitle(), this.getInfo());
            try {
                NewEntryTask newTask = new NewEntryTask(this.getInfo(), dlg, entry, this.getLDIF(), this.parentNode, this.controller);
                for (Task task : this.getInfo().getTasks()) {
                    task.canLaunch(newTask, errors);
                }
                if (errors.size() == 0) {
                    this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_CREATING_NEW_ENTRY_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CREATING_NEW_ENTRY_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CREATING_NEW_ENTRY_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_CREATING_NEW_ENTRY_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_CREATING_NEW_ENTRY_ERROR_DETAILS.get(), null, dlg);
                    dlg.setVisible(true);
                    Utilities.getParentDialog(this).setVisible(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dlg.toFront();
                        }
                    });
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Unexpected error: " + t, t);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        this.updateErrorPaneIfServerRunningAndAuthRequired(ev.getNewDescriptor(), AdminToolMessages.INFO_CTRL_PANEL_NEW_ENTRY_REQUIRES_SERVER_RUNNING.get(), AdminToolMessages.INFO_CTRL_PANEL_NEW_ENTRY_REQUIRES_AUTHENTICATION.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry getEntry() throws LDIFException, IOException {
        Entry entry;
        LDIFImportConfig ldifImportConfig = null;
        try {
            String ldif = this.getLDIF();
            if (ldif.trim().length() == 0) {
                throw new LDIFException(AdminToolMessages.ERR_LDIF_REPRESENTATION_REQUIRED.get());
            }
            ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
            LDIFReader reader = new LDIFReader(ldifImportConfig);
            entry = reader.readEntry(this.checkSchema());
            if (entry == null) {
                throw new LDIFException(AdminToolMessages.ERR_LDIF_REPRESENTATION_REQUIRED.get());
            }
            if (entry.getObjectClasses().size() == 0) {
                throw new LDIFException(AdminToolMessages.ERR_OBJECTCLASS_FOR_ENTRY_REQUIRED.get());
            }
        }
        finally {
            if (ldifImportConfig != null) {
                ldifImportConfig.close();
            }
        }
        return entry;
    }

    protected boolean checkSchema() {
        return this.getInfo().getServerDescriptor().isSchemaEnabled();
    }
}

