/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.StartServerTask;
import org.opends.guitools.controlpanel.task.StartStopTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class RestartServerTask
extends StartStopTask {
    private boolean starting;
    private StartServerTask startTask;

    public RestartServerTask(ControlPanelInfo info, ProgressDialog dlg) {
        super(info, dlg);
        this.startTask = new StartServerTask(info, dlg);
    }

    @Override
    public Task.Type getType() {
        if (this.starting) {
            return Task.Type.START_SERVER;
        }
        return Task.Type.STOP_SERVER;
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_RESTART_SERVER_TASK_DESCRIPTION.get();
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    private String getStartCommandLineName() {
        return this.startTask.getCommandLinePath();
    }

    private ArrayList<String> getStartCommandLineArguments() {
        return this.startTask.getCommandLineArguments();
    }

    private String getStopCommandLineName() {
        return this.getCommandLinePath("stop-ds");
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.starting = false;
        this.lastException = null;
        final ProgressDialog dlg = this.getProgressDialog();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String cmdLine = RestartServerTask.this.getStopCommandLineName();
                RestartServerTask.this.printEquivalentCommandLine(cmdLine, RestartServerTask.this.getCommandLineArguments(), AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_STOP_SERVER.get());
                dlg.setSummary(Message.raw(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_STOPPING_SERVER_SUMMARY.get().toString(), ColorAndFontConstants.defaultFont), new Object[0]));
            }
        });
        this.getInfo().regenerateDescriptor();
        this.getInfo().stopPooling();
        try {
            ArrayList<String> arguments = this.getCommandLineArguments();
            String[] args = new String[arguments.size()];
            arguments.toArray(args);
            this.returnCode = this.executeCommandLine(this.getStopCommandLineName(), args);
            if (this.returnCode != 0) {
                this.state = Task.State.FINISHED_WITH_ERROR;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RestartServerTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                        dlg.getProgressBar().setValue(30);
                        dlg.appendProgressHtml(Utilities.applyFont("<b>" + AdminToolMessages.INFO_CTRL_PANEL_SERVER_STOPPED.get() + "</b><br><br>", ColorAndFontConstants.progressFont));
                        String cmdLine = RestartServerTask.this.getStartCommandLineName();
                        RestartServerTask.this.printEquivalentCommandLine(cmdLine, RestartServerTask.this.getStartCommandLineArguments(), AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_START_SERVER.get());
                        dlg.setSummary(Message.raw(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_STARTING_SERVER_SUMMARY.get().toString(), ColorAndFontConstants.defaultFont), new Object[0]));
                    }
                });
                this.starting = true;
                this.getInfo().regenerateDescriptor();
                arguments = this.getStartCommandLineArguments();
                args = new String[arguments.size()];
                arguments.toArray(args);
                this.returnCode = this.executeCommandLine(this.getStartCommandLineName(), args);
                this.state = this.returnCode != 0 ? Task.State.FINISHED_WITH_ERROR : Task.State.FINISHED_SUCCESSFULLY;
            }
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
        this.getInfo().startPooling();
    }
}

