/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.NewSchemaElementsTask;
import org.opends.guitools.controlpanel.task.OfflineUpdateException;
import org.opends.guitools.controlpanel.task.OnlineUpdateException;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Attributes;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.Schema;
import org.opends.server.types.SchemaFileElement;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;

public class DeleteSchemaElementsTask
extends Task {
    LinkedHashSet<ObjectClass> providedOcsToDelete = new LinkedHashSet();
    LinkedHashSet<AttributeType> providedAttrsToDelete = new LinkedHashSet();
    LinkedHashSet<ObjectClass> ocsToDelete = new LinkedHashSet();
    LinkedHashSet<AttributeType> attrsToDelete = new LinkedHashSet();
    LinkedHashSet<ObjectClass> ocsToAdd = new LinkedHashSet();
    LinkedHashSet<AttributeType> attrsToAdd = new LinkedHashSet();

    public DeleteSchemaElementsTask(ControlPanelInfo info, ProgressDialog dlg, LinkedHashSet<ObjectClass> ocsToDelete, LinkedHashSet<AttributeType> attrsToDelete) {
        super(info, dlg);
        this.providedOcsToDelete.addAll(ocsToDelete);
        this.providedAttrsToDelete.addAll(attrsToDelete);
        Schema schema = info.getServerDescriptor().getSchema();
        LinkedHashSet<AttributeType> allAttrsToDelete = DeleteSchemaElementsTask.getOrderedAttributesToDelete(attrsToDelete, schema);
        LinkedHashSet<ObjectClass> allOcsToDelete = null;
        if (!attrsToDelete.isEmpty()) {
            allOcsToDelete = DeleteSchemaElementsTask.getOrderedObjectClassesToDeleteFromAttrs(attrsToDelete, schema);
        }
        if (!ocsToDelete.isEmpty()) {
            if (allOcsToDelete == null) {
                allOcsToDelete = DeleteSchemaElementsTask.getOrderedObjectClassesToDelete(ocsToDelete, schema);
            } else {
                allOcsToDelete.addAll(DeleteSchemaElementsTask.getOrderedObjectClassesToDelete(ocsToDelete, schema));
            }
        }
        ArrayList<AttributeType> lAttrsToDelete = new ArrayList<AttributeType>(allAttrsToDelete);
        for (int i = lAttrsToDelete.size() - 1; i >= 0; --i) {
            AttributeType attrToAdd;
            AttributeType attrToDelete = lAttrsToDelete.get(i);
            if (attrsToDelete.contains(attrToDelete) || (attrToAdd = this.getAttributeToAdd(attrToDelete)) == null) continue;
            this.attrsToAdd.add(attrToAdd);
        }
        assert (allOcsToDelete != null);
        ArrayList<ObjectClass> lOcsToDelete = new ArrayList<ObjectClass>(allOcsToDelete);
        for (int i = lOcsToDelete.size() - 1; i >= 0; --i) {
            ObjectClass ocToDelete = lOcsToDelete.get(i);
            if (ocsToDelete.contains(ocToDelete)) continue;
            this.ocsToAdd.add(this.getObjectClassToAdd(lOcsToDelete.get(i)));
        }
        this.ocsToDelete.addAll(allOcsToDelete);
        this.attrsToDelete.addAll(allAttrsToDelete);
    }

    @Override
    public Set<String> getBackends() {
        return Collections.emptySet();
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (this.state == Task.State.RUNNING && (taskToBeLaunched.getType() == Task.Type.DELETE_SCHEMA_ELEMENT || taskToBeLaunched.getType() == Task.Type.MODIFY_SCHEMA_ELEMENT || taskToBeLaunched.getType() == Task.Type.NEW_SCHEMA_ELEMENT)) {
            incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
            canLaunch = false;
        }
        return canLaunch;
    }

    @Override
    public Task.Type getType() {
        return Task.Type.NEW_SCHEMA_ELEMENT;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            this.updateSchema();
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    @Override
    protected List<String> getCommandLineArguments() {
        return Collections.emptyList();
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_DELETE_SCHEMA_ELEMENT_TASK_DESCRIPTION.get();
    }

    private void updateSchema() throws OpenDsException {
        int fNumberDeleted;
        ModificationItem mod;
        final boolean[] isFirst = new boolean[]{true};
        final int totalNumber = this.ocsToDelete.size() + this.attrsToDelete.size();
        int numberDeleted = 0;
        Iterator i$ = this.ocsToDelete.iterator();
        while (i$.hasNext()) {
            ObjectClass objectClass;
            final ObjectClass fObjectclass = objectClass = (ObjectClass)i$.next();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!isFirst[0]) {
                        DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml("<br><br>");
                    }
                    isFirst[0] = false;
                    DeleteSchemaElementsTask.this.printEquivalentCommandToDelete(fObjectclass);
                    DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_DELETING_OBJECTCLASS.get(fObjectclass.getNameOrOID()), ColorAndFontConstants.progressFont));
                }
            });
            if (this.isServerRunning()) {
                try {
                    BasicAttribute attr = new BasicAttribute(this.getSchemaFileAttributeName(objectClass));
                    attr.add(this.getSchemaFileAttributeValue(objectClass));
                    mod = new ModificationItem(3, attr);
                    this.getInfo().getDirContext().modifyAttributes("cn=schema", new ModificationItem[]{mod});
                }
                catch (NamingException ne) {
                    throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_SCHEMA.get(ne.toString()), (Throwable)ne);
                }
            } else {
                this.updateSchemaFile(objectClass);
            }
            fNumberDeleted = ++numberDeleted;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeleteSchemaElementsTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                    DeleteSchemaElementsTask.this.getProgressDialog().getProgressBar().setValue(fNumberDeleted * 100 / totalNumber);
                    DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                }
            });
        }
        i$ = this.attrsToDelete.iterator();
        while (i$.hasNext()) {
            AttributeType attribute;
            final AttributeType fAttribute = attribute = (AttributeType)i$.next();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!isFirst[0]) {
                        DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml("<br><br>");
                    }
                    isFirst[0] = false;
                    DeleteSchemaElementsTask.this.printEquivalentCommandToDelete(fAttribute);
                    DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_DELETING_ATTRIBUTE.get(fAttribute.getNameOrOID()), ColorAndFontConstants.progressFont));
                }
            });
            if (this.isServerRunning()) {
                try {
                    BasicAttribute attr = new BasicAttribute(this.getSchemaFileAttributeName(attribute));
                    attr.add(this.getSchemaFileAttributeValue(attribute));
                    mod = new ModificationItem(3, attr);
                    this.getInfo().getDirContext().modifyAttributes("cn=schema", new ModificationItem[]{mod});
                }
                catch (NamingException ne) {
                    throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_SCHEMA.get(ne.toString()), (Throwable)ne);
                }
            } else {
                this.updateSchemaFile(attribute);
            }
            fNumberDeleted = ++numberDeleted;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeleteSchemaElementsTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                    DeleteSchemaElementsTask.this.getProgressDialog().getProgressBar().setValue(fNumberDeleted * 100 / totalNumber);
                    DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                }
            });
        }
        if (!this.ocsToAdd.isEmpty() || !this.attrsToAdd.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeleteSchemaElementsTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont("<br><br>" + AdminToolMessages.INFO_CTRL_PANEL_EXPLANATION_TO_DELETE_REFERENCED_ELEMENTS.get() + "<br><br>", ColorAndFontConstants.progressFont));
                }
            });
            NewSchemaElementsTask createTask = new NewSchemaElementsTask(this.getInfo(), this.getProgressDialog(), this.ocsToAdd, this.attrsToAdd);
            createTask.runTask();
        }
    }

    private void updateSchemaFile(CommonSchemaElements schemaElement) throws OpenDsException {
        String schemaFile = this.getSchemaFile((SchemaFileElement)((Object)schemaElement));
        LDIFExportConfig exportConfig = new LDIFExportConfig(schemaFile, ExistingFileBehavior.OVERWRITE);
        LDIFReader reader = null;
        LDIFWriter writer = null;
        try {
            reader = new LDIFReader(new LDIFImportConfig(schemaFile));
            Entry schemaEntry = reader.readEntry();
            Modification mod = new Modification(ModificationType.DELETE, Attributes.create(this.getSchemaFileAttributeName(schemaElement).toLowerCase(), this.getSchemaFileAttributeValue(schemaElement)));
            schemaEntry.applyModification(mod);
            writer = new LDIFWriter(exportConfig);
            writer.writeEntry(schemaEntry);
            exportConfig.getWriter().newLine();
        }
        catch (IOException e) {
            try {
                throw new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_SCHEMA.get(e.toString()), (Throwable)e);
            }
            catch (Throwable throwable) {
                StaticUtils.close(reader, exportConfig, writer);
                throw throwable;
            }
        }
        StaticUtils.close(reader, exportConfig, writer);
    }

    private String getSchemaFile(SchemaFileElement element) {
        File f;
        String schemaFile = element.getSchemaFile();
        if (schemaFile == null) {
            schemaFile = "99-user.ldif";
        }
        if (!(f = new File(schemaFile)).isAbsolute()) {
            f = new File(DirectoryServer.getEnvironmentConfig().getSchemaDirectory(), schemaFile);
        }
        schemaFile = f.getAbsolutePath();
        return schemaFile;
    }

    private String getSchemaFileAttributeName(CommonSchemaElements element) {
        if (element instanceof AttributeType) {
            return "attributeTypes";
        }
        return "objectClasses";
    }

    private String getSchemaFileAttributeValue(CommonSchemaElements element) {
        if (element instanceof AttributeType) {
            return ((AttributeType)element).getDefinition();
        }
        return ((ObjectClass)element).getDefinition();
    }

    private void printEquivalentCommandToDelete(CommonSchemaElements element) {
        String schemaFile = this.getSchemaFile((SchemaFileElement)((Object)element));
        String attrName = this.getSchemaFileAttributeName(element);
        String attrValue = this.getSchemaFileAttributeValue(element);
        if (!this.isServerRunning()) {
            Message msg = element instanceof AttributeType ? AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DELETE_ATTRIBUTE_OFFLINE.get(element.getNameOrOID(), schemaFile) : AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DELETE_OBJECTCLASS_OFFLINE.get(element.getNameOrOID(), schemaFile);
            this.getProgressDialog().appendProgressHtml(Utilities.applyFont(msg + "<br><b>" + attrName + ": " + attrValue + "</b><br><br>", ColorAndFontConstants.progressFont));
        } else {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-a");
            args.addAll(this.getObfuscatedCommandLineArguments(this.getConnectionCommandLineArguments(true, true)));
            args.add(this.getNoPropertiesFileArgument());
            String equiv = DeleteSchemaElementsTask.getEquivalentCommandLine(this.getCommandLinePath("ldapmodify"), args);
            Message msg = element instanceof AttributeType ? AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DELETE_ATTRIBUTE_ONLINE.get(element.getNameOrOID()) : AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DELETE_OBJECTCLASS_ONLINE.get(element.getNameOrOID());
            StringBuilder sb = new StringBuilder();
            sb.append(msg).append("<br><b>");
            sb.append(equiv);
            sb.append("<br>");
            sb.append("dn: cn=schema<br>");
            sb.append("changetype: modify<br>");
            sb.append("delete: ").append(attrName).append("<br>");
            sb.append(attrName).append(": ").append(attrValue);
            sb.append("</b><br><br>");
            this.getProgressDialog().appendProgressHtml(Utilities.applyFont(sb.toString(), ColorAndFontConstants.progressFont));
        }
    }

    private AttributeType getAttributeToAdd(AttributeType attrToDelete) {
        AttributeType attrToAdd;
        boolean isSuperior = false;
        for (AttributeType attr : this.providedAttrsToDelete) {
            if (!attr.equals(attrToDelete.getSuperiorType())) continue;
            isSuperior = true;
            for (AttributeType newSuperior = attr.getSuperiorType(); newSuperior != null && this.providedAttrsToDelete.contains(newSuperior); newSuperior = newSuperior.getSuperiorType()) {
            }
        }
        if (isSuperior) {
            ArrayList<String> allNames = new ArrayList<String>();
            for (String str : attrToDelete.getNormalizedNames()) {
                allNames.add(str);
            }
            Map<String, List<String>> extraProperties = DeleteSchemaElementsTask.cloneExtraProperties(attrToDelete);
            attrToAdd = new AttributeType("", attrToDelete.getPrimaryName(), allNames, attrToDelete.getOID(), attrToDelete.getDescription(), null, attrToDelete.getSyntax(), attrToDelete.getApproximateMatchingRule(), attrToDelete.getEqualityMatchingRule(), attrToDelete.getOrderingMatchingRule(), attrToDelete.getSubstringMatchingRule(), attrToDelete.getUsage(), attrToDelete.isCollective(), attrToDelete.isNoUserModification(), attrToDelete.isObsolete(), attrToDelete.isSingleValue(), extraProperties);
        } else {
            attrToAdd = attrToDelete;
        }
        return attrToAdd;
    }

    private ObjectClass getObjectClassToAdd(ObjectClass ocToDelete) {
        ObjectClass ocToAdd;
        boolean containsAttribute = false;
        for (AttributeType attr : this.providedAttrsToDelete) {
            if (!ocToDelete.getRequiredAttributeChain().contains(attr) && !ocToDelete.getOptionalAttributeChain().contains(attr)) continue;
            containsAttribute = true;
            break;
        }
        boolean hasSuperior = false;
        LinkedHashSet<ObjectClass> newSuperiors = new LinkedHashSet<ObjectClass>();
        for (ObjectClass sup : ocToDelete.getSuperiorClasses()) {
            boolean isFound = false;
            for (ObjectClass oc : this.providedOcsToDelete) {
                if (!sup.equals(oc)) continue;
                hasSuperior = true;
                isFound = true;
                newSuperiors.addAll(this.getNewSuperiors(oc));
                break;
            }
            if (isFound) continue;
            newSuperiors.add(sup);
        }
        if (containsAttribute || hasSuperior) {
            Set<AttributeType> optional;
            Set<AttributeType> required;
            ArrayList<String> allNames = new ArrayList<String>();
            for (String str : ocToDelete.getNormalizedNames()) {
                allNames.add(str);
            }
            Map<String, List<String>> extraProperties = DeleteSchemaElementsTask.cloneExtraProperties(ocToDelete);
            if (containsAttribute) {
                required = new HashSet<AttributeType>(ocToDelete.getRequiredAttributes());
                optional = new HashSet<AttributeType>(ocToDelete.getOptionalAttributes());
                required.removeAll(this.providedAttrsToDelete);
                optional.removeAll(this.providedAttrsToDelete);
            } else {
                required = ocToDelete.getRequiredAttributes();
                optional = ocToDelete.getOptionalAttributes();
            }
            ocToAdd = new ObjectClass("", ocToDelete.getPrimaryName(), allNames, ocToDelete.getOID(), ocToDelete.getDescription(), newSuperiors, required, optional, ocToDelete.getObjectClassType(), ocToDelete.isObsolete(), extraProperties);
        } else {
            ocToAdd = ocToDelete;
        }
        return ocToAdd;
    }

    private Set<ObjectClass> getNewSuperiors(ObjectClass currentSup) {
        LinkedHashSet<ObjectClass> newSuperiors = new LinkedHashSet<ObjectClass>();
        if (currentSup.getSuperiorClasses() != null && !currentSup.getSuperiorClasses().isEmpty()) {
            for (ObjectClass o : currentSup.getSuperiorClasses()) {
                if (this.providedOcsToDelete.contains(o)) {
                    newSuperiors.addAll(this.getNewSuperiors(o));
                    continue;
                }
                newSuperiors.add(o);
            }
        }
        return newSuperiors;
    }

    public static LinkedHashSet<AttributeType> getOrderedAttributesToDelete(Collection<AttributeType> attrsToDelete, Schema schema) {
        LinkedHashSet<AttributeType> orderedAttributes = new LinkedHashSet<AttributeType>();
        for (AttributeType attribute : attrsToDelete) {
            orderedAttributes.addAll(DeleteSchemaElementsTask.getOrderedChildrenToDelete(attribute, schema));
            orderedAttributes.add(attribute);
        }
        return orderedAttributes;
    }

    public static LinkedHashSet<ObjectClass> getOrderedObjectClassesToDelete(Collection<ObjectClass> ocsToDelete, Schema schema) {
        LinkedHashSet<ObjectClass> orderedOcs = new LinkedHashSet<ObjectClass>();
        for (ObjectClass oc : ocsToDelete) {
            orderedOcs.addAll(DeleteSchemaElementsTask.getOrderedChildrenToDelete(oc, schema));
            orderedOcs.add(oc);
        }
        return orderedOcs;
    }

    public static LinkedHashSet<ObjectClass> getOrderedObjectClassesToDeleteFromAttrs(Collection<AttributeType> attrsToDelete, Schema schema) {
        LinkedHashSet<ObjectClass> orderedOcs = new LinkedHashSet<ObjectClass>();
        ArrayList<ObjectClass> dependentClasses = new ArrayList<ObjectClass>();
        for (AttributeType attr : attrsToDelete) {
            for (ObjectClass oc : schema.getObjectClasses().values()) {
                if (oc.getRequiredAttributeChain().contains(attr)) {
                    dependentClasses.add(oc);
                    continue;
                }
                if (!oc.getOptionalAttributeChain().contains(attr)) continue;
                dependentClasses.add(oc);
            }
        }
        for (ObjectClass oc : dependentClasses) {
            orderedOcs.addAll(DeleteSchemaElementsTask.getOrderedChildrenToDelete(oc, schema));
            orderedOcs.add(oc);
        }
        return orderedOcs;
    }

    public static Map<String, List<String>> cloneExtraProperties(CommonSchemaElements element) {
        HashMap<String, List<String>> extraProperties = new HashMap<String, List<String>>();
        for (String name : element.getExtraPropertyNames()) {
            ArrayList<String> values = new ArrayList<String>();
            Iterable<String> properties = element.getExtraProperty(name);
            for (String v : properties) {
                values.add(v);
            }
            extraProperties.put(name, values);
        }
        return extraProperties;
    }

    private static LinkedHashSet<AttributeType> getOrderedChildrenToDelete(AttributeType attribute, Schema schema) {
        LinkedHashSet<AttributeType> children = new LinkedHashSet<AttributeType>();
        for (AttributeType attr : schema.getAttributeTypes().values()) {
            if (!attribute.equals(attr.getSuperiorType())) continue;
            children.addAll(DeleteSchemaElementsTask.getOrderedChildrenToDelete(attr, schema));
            children.add(attr);
        }
        return children;
    }

    private static LinkedHashSet<ObjectClass> getOrderedChildrenToDelete(ObjectClass objectClass, Schema schema) {
        LinkedHashSet<ObjectClass> children = new LinkedHashSet<ObjectClass>();
        for (ObjectClass oc : schema.getObjectClasses().values()) {
            if (!oc.getSuperiorClasses().contains(objectClass)) continue;
            children.addAll(DeleteSchemaElementsTask.getOrderedChildrenToDelete(oc, schema));
            children.add(oc);
        }
        return children;
    }
}

