/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.Date;

public class ScheduleType {
    private Type type;
    private Date launchLaterDate;
    private String cronValue;
    private String toString;
    private int hashCode;

    private ScheduleType() {
    }

    public static ScheduleType createLaunchNow() {
        ScheduleType schedule = new ScheduleType();
        schedule.type = Type.LAUNCH_NOW;
        schedule.toString = schedule.calculateToString();
        schedule.hashCode = schedule.calculateHashCode();
        return schedule;
    }

    public static ScheduleType createLaunchLater(Date date) {
        ScheduleType schedule = new ScheduleType();
        schedule.type = Type.LAUNCH_LATER;
        schedule.launchLaterDate = date;
        schedule.toString = schedule.calculateToString();
        schedule.hashCode = schedule.calculateHashCode();
        return schedule;
    }

    public static ScheduleType createCron(String cron) {
        ScheduleType schedule = new ScheduleType();
        schedule.type = Type.LAUNCH_PERIODICALLY;
        schedule.cronValue = cron;
        schedule.toString = schedule.calculateToString();
        schedule.hashCode = schedule.calculateHashCode();
        return schedule;
    }

    public Type getType() {
        return this.type;
    }

    public Date getLaunchLaterDate() {
        return this.launchLaterDate;
    }

    public String getCronValue() {
        return this.cronValue;
    }

    public boolean equals(Object o) {
        boolean equals = o != null ? (o == this ? true : this.toString().equals(o.toString())) : false;
        return equals;
    }

    public String toString() {
        return this.toString;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        return 32 + this.toString.hashCode();
    }

    private String calculateToString() {
        String toString;
        switch (this.type) {
            case LAUNCH_NOW: {
                toString = "Schedule Type: Launch Now";
                break;
            }
            case LAUNCH_LATER: {
                toString = "Schedule Type: Launch Later at date " + this.launchLaterDate;
                break;
            }
            case LAUNCH_PERIODICALLY: {
                toString = "Schedule Type: periodical schedule " + this.cronValue;
                break;
            }
            default: {
                throw new RuntimeException("Invalid type: " + (Object)((Object)this.type));
            }
        }
        return toString;
    }

    public static enum Type {
        LAUNCH_NOW,
        LAUNCH_LATER,
        LAUNCH_PERIODICALLY;

    }
}

