/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Function;
import org.forgerock.opendj.ldap.Functions;
import org.forgerock.opendj.rest2ldap.AbstractLDAPAttributeMapper;
import org.forgerock.opendj.rest2ldap.Context;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;

public final class SimpleAttributeMapper
extends AbstractLDAPAttributeMapper<SimpleAttributeMapper> {
    private Function<ByteString, ?, Void> decoder = null;
    private Function<Object, ByteString, Void> encoder = null;

    SimpleAttributeMapper(AttributeDescription ldapAttributeName) {
        super(ldapAttributeName);
    }

    public SimpleAttributeMapper decoder(Function<ByteString, ?, Void> f) {
        this.decoder = f;
        return this;
    }

    public SimpleAttributeMapper defaultJSONValue(Object defaultValue) {
        this.defaultJSONValues = defaultValue != null ? Collections.singletonList(defaultValue) : Collections.emptyList();
        return this;
    }

    public SimpleAttributeMapper encoder(Function<Object, ByteString, Void> f) {
        this.encoder = f;
        return this;
    }

    public SimpleAttributeMapper isBinary() {
        this.decoder = Utils.byteStringToBase64();
        this.encoder = Utils.base64ToByteString();
        return this;
    }

    public String toString() {
        return "simple(" + this.ldapAttributeName.toString() + ")";
    }

    @Override
    void getLDAPFilter(Context c, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion, ResultHandler<Filter> h) {
        if (subPath.isEmpty()) {
            try {
                ByteString va = valueAssertion != null ? (ByteString)this.encoder().apply(valueAssertion, null) : null;
                h.handleResult((Object)Utils.toFilter(c, type, this.ldapAttributeName.toString(), va));
            }
            catch (Exception e) {
                h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because it contained an illegal filter assertion value '%s' for field '%s'", String.valueOf(valueAssertion), path), (Throwable)e));
            }
        } else {
            h.handleResult((Object)Filter.alwaysFalse());
        }
    }

    @Override
    void getNewLDAPAttributes(Context c, JsonPointer path, List<Object> newValues, ResultHandler<Attribute> h) {
        try {
            h.handleResult((Object)Utils.jsonToAttribute(newValues, this.ldapAttributeName, this.encoder()));
        }
        catch (Exception ex) {
            h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because an error occurred while encoding the values for the field '%s': %s", path, ex.getMessage())));
        }
    }

    @Override
    SimpleAttributeMapper getThis() {
        return this;
    }

    @Override
    void read(Context c, JsonPointer path, Entry e, ResultHandler<JsonValue> h) {
        try {
            Set s;
            Object value = this.attributeIsSingleValued() ? e.parseAttribute(this.ldapAttributeName).as(this.decoder(), this.defaultJSONValues.isEmpty() ? null : this.defaultJSONValues.get(0)) : ((s = e.parseAttribute(this.ldapAttributeName).asSetOf(this.decoder(), (Collection)this.defaultJSONValues)).isEmpty() ? null : new ArrayList(s));
            h.handleResult((Object)(value != null ? new JsonValue(value) : null));
        }
        catch (Exception ex) {
            h.handleError(Rest2LDAP.asResourceException(ex));
        }
    }

    private Function<ByteString, ? extends Object, Void> decoder() {
        return this.decoder == null ? Functions.fixedFunction(Utils.byteStringToJson(), (Object)this.ldapAttributeName) : this.decoder;
    }

    private Function<Object, ByteString, Void> encoder() {
        return this.encoder == null ? Functions.fixedFunction(Utils.jsonToByteString(), (Object)this.ldapAttributeName) : this.encoder;
    }
}

