/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Function;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.Context;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;

public final class ObjectAttributeMapper
extends AttributeMapper {
    private final Map<String, Mapping> mappings = new LinkedHashMap<String, Mapping>();

    ObjectAttributeMapper() {
    }

    public ObjectAttributeMapper attribute(String name, AttributeMapper mapper) {
        this.mappings.put(Utils.toLowerCase(name), new Mapping(name, mapper));
        return this;
    }

    public String toString() {
        return "object(" + this.mappings.values().toString() + ")";
    }

    @Override
    void create(Context c, JsonPointer path, JsonValue v, ResultHandler<List<Attribute>> h) {
        try {
            Map<String, Mapping> missingMappings = this.checkMapping(path, v);
            ResultHandler<List<Attribute>> handler = this.accumulator(h);
            if (v != null && !v.isNull()) {
                for (Map.Entry entry : v.asMap().entrySet()) {
                    Mapping mapping = this.getMapping((String)entry.getKey());
                    JsonValue subValue = new JsonValue(entry.getValue());
                    mapping.mapper.create(c, path.child((String)entry.getKey()), subValue, handler);
                }
            }
            for (Mapping mapping : missingMappings.values()) {
                mapping.mapper.create(c, path.child(mapping.name), null, handler);
            }
        }
        catch (Exception e) {
            h.handleError(Rest2LDAP.asResourceException(e));
        }
    }

    @Override
    void getLDAPAttributes(Context c, JsonPointer path, JsonPointer subPath, Set<String> ldapAttributes) {
        if (subPath.isEmpty()) {
            for (Mapping mapping : this.mappings.values()) {
                mapping.mapper.getLDAPAttributes(c, path.child(mapping.name), subPath, ldapAttributes);
            }
        } else {
            Mapping mapping = this.getMapping(subPath);
            if (mapping != null) {
                mapping.mapper.getLDAPAttributes(c, path.child(subPath.get(0)), subPath.relativePointer(), ldapAttributes);
            }
        }
    }

    @Override
    void getLDAPFilter(Context c, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion, ResultHandler<Filter> h) {
        Mapping mapping = this.getMapping(subPath);
        if (mapping != null) {
            mapping.mapper.getLDAPFilter(c, path.child(subPath.get(0)), subPath.relativePointer(), type, operator, valueAssertion, h);
        } else {
            h.handleResult((Object)Filter.alwaysFalse());
        }
    }

    @Override
    void patch(Context c, JsonPointer path, PatchOperation operation, ResultHandler<List<Modification>> h) {
        try {
            JsonPointer field = operation.getField();
            JsonValue v = operation.getValue();
            if (field.isEmpty()) {
                Map<String, Mapping> missingMappings = this.checkMapping(path, v);
                ResultHandler<List<Modification>> handler = this.accumulator(this.mappings.size() - missingMappings.size(), h);
                if (!v.isNull()) {
                    for (Map.Entry me : v.asMap().entrySet()) {
                        Mapping mapping = this.getMapping((String)me.getKey());
                        JsonValue subValue = new JsonValue(me.getValue());
                        PatchOperation subOperation = PatchOperation.operation((String)operation.getOperation(), (JsonPointer)field, (Object)subValue);
                        mapping.mapper.patch(c, path.child((String)me.getKey()), subOperation, handler);
                    }
                }
            } else {
                String fieldName = field.get(0);
                Mapping mapping = this.getMapping(fieldName);
                if (mapping == null) {
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because it included an unrecognized field '%s'", path.child(fieldName)));
                }
                PatchOperation subOperation = PatchOperation.operation((String)operation.getOperation(), (JsonPointer)field.relativePointer(), (Object)v);
                mapping.mapper.patch(c, path.child(fieldName), subOperation, h);
            }
        }
        catch (Exception ex) {
            h.handleError(Rest2LDAP.asResourceException(ex));
        }
    }

    @Override
    void read(Context c, JsonPointer path, Entry e, ResultHandler<JsonValue> h) {
        ResultHandler<Map.Entry<String, JsonValue>> handler = Utils.accumulate(this.mappings.size(), Utils.transform(new Function<List<Map.Entry<String, JsonValue>>, JsonValue, Void>(){

            public JsonValue apply(List<Map.Entry<String, JsonValue>> value, Void p) {
                if (value.isEmpty()) {
                    return null;
                }
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(value.size());
                for (Map.Entry<String, JsonValue> e : value) {
                    result.put(e.getKey(), e.getValue().getObject());
                }
                return new JsonValue(result);
            }
        }, h));
        for (final Mapping mapping : this.mappings.values()) {
            mapping.mapper.read(c, path.child(mapping.name), e, Utils.transform(new Function<JsonValue, Map.Entry<String, JsonValue>, Void>(){

                public Map.Entry<String, JsonValue> apply(JsonValue value, Void p) {
                    return value != null ? new AbstractMap.SimpleImmutableEntry<String, JsonValue>(mapping.name, value) : null;
                }
            }, handler));
        }
    }

    @Override
    void update(Context c, JsonPointer path, Entry e, JsonValue v, ResultHandler<List<Modification>> h) {
        try {
            Map<String, Mapping> missingMappings = this.checkMapping(path, v);
            ResultHandler<List<Modification>> handler = this.accumulator(h);
            if (v != null && !v.isNull()) {
                for (Map.Entry entry : v.asMap().entrySet()) {
                    Mapping mapping = this.getMapping((String)entry.getKey());
                    JsonValue subValue = new JsonValue(entry.getValue());
                    mapping.mapper.update(c, path.child((String)entry.getKey()), e, subValue, handler);
                }
            }
            for (Mapping mapping : missingMappings.values()) {
                mapping.mapper.update(c, path.child(mapping.name), e, null, handler);
            }
        }
        catch (Exception ex) {
            h.handleError(Rest2LDAP.asResourceException(ex));
        }
    }

    private <T> ResultHandler<List<T>> accumulator(ResultHandler<List<T>> h) {
        return this.accumulator(this.mappings.size(), h);
    }

    private <T> ResultHandler<List<T>> accumulator(int size, ResultHandler<List<T>> h) {
        return Utils.accumulate(size, Utils.transform(new Function<List<List<T>>, List<T>, Void>(){

            public List<T> apply(List<List<T>> value, Void p) {
                switch (value.size()) {
                    case 0: {
                        return Collections.emptyList();
                    }
                    case 1: {
                        return value.get(0);
                    }
                }
                ArrayList attributes = new ArrayList(value.size());
                for (List a : value) {
                    attributes.addAll(a);
                }
                return attributes;
            }
        }, h));
    }

    private Map<String, Mapping> checkMapping(JsonPointer path, JsonValue v) throws ResourceException {
        LinkedHashMap<String, Mapping> missingMappings = new LinkedHashMap<String, Mapping>(this.mappings);
        if (v != null && !v.isNull()) {
            if (v.isMap()) {
                for (String attribute : v.asMap().keySet()) {
                    if (missingMappings.remove(Utils.toLowerCase(attribute)) != null) continue;
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because it included an unrecognized field '%s'", path.child(attribute)));
                }
            } else {
                throw new BadRequestException(Utils.i18n("The request cannot be processed because it included the field '%s' whose value is the wrong type: an object is expected", path));
            }
        }
        return missingMappings;
    }

    private Mapping getMapping(JsonPointer jsonAttribute) {
        return jsonAttribute.isEmpty() ? null : this.getMapping(jsonAttribute.get(0));
    }

    private Mapping getMapping(String jsonAttribute) {
        return this.mappings.get(Utils.toLowerCase(jsonAttribute));
    }

    private static final class Mapping {
        private final AttributeMapper mapper;
        private final String name;

        private Mapping(String name, AttributeMapper mapper) {
            this.name = name;
            this.mapper = mapper;
        }

        public String toString() {
            return this.name + " -> " + this.mapper;
        }
    }
}

