/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryFilter;
import org.forgerock.json.resource.QueryFilterVisitor;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResult;
import org.forgerock.json.resource.QueryResultHandler;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Resource;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ServerContext;
import org.forgerock.json.resource.UncategorizedException;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Function;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.PermissiveModifyRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadResponseControl;
import org.forgerock.opendj.ldap.controls.PreReadRequestControl;
import org.forgerock.opendj.ldap.controls.PreReadResponseControl;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.Config;
import org.forgerock.opendj.rest2ldap.Context;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.NameStrategy;
import org.forgerock.opendj.rest2ldap.ReadOnUpdatePolicy;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;

final class LDAPCollectionResourceProvider
implements CollectionResourceProvider {
    private static final ResourceException SUCCESS = new UncategorizedException(0, null, null);
    private final List<Attribute> additionalLDAPAttributes;
    private final AttributeMapper attributeMapper;
    private final DN baseDN;
    private final Config config;
    private final AttributeDescription etagAttribute;
    private final NameStrategy nameStrategy;

    LDAPCollectionResourceProvider(DN baseDN, AttributeMapper mapper, NameStrategy nameStrategy, AttributeDescription etagAttribute, Config config, List<Attribute> additionalLDAPAttributes) {
        this.baseDN = baseDN;
        this.attributeMapper = mapper;
        this.config = config;
        this.nameStrategy = nameStrategy;
        this.etagAttribute = etagAttribute;
        this.additionalLDAPAttributes = additionalLDAPAttributes;
    }

    public void actionCollection(ServerContext context, ActionRequest request, org.forgerock.json.resource.ResultHandler<JsonValue> handler) {
        handler.handleError((ResourceException)new NotSupportedException("Not yet implemented"));
    }

    public void actionInstance(ServerContext context, String resourceId, ActionRequest request, org.forgerock.json.resource.ResultHandler<JsonValue> handler) {
        handler.handleError((ResourceException)new NotSupportedException("Not yet implemented"));
    }

    public void createInstance(ServerContext context, final CreateRequest request, org.forgerock.json.resource.ResultHandler<Resource> handler) {
        final Context c = this.wrap(context);
        final org.forgerock.json.resource.ResultHandler<Resource> h = this.wrap(c, handler);
        c.run(h, new Runnable(){

            @Override
            public void run() {
                LDAPCollectionResourceProvider.this.attributeMapper.create(c, new JsonPointer(), request.getContent(), new org.forgerock.json.resource.ResultHandler<List<Attribute>>(){

                    public void handleError(ResourceException error) {
                        h.handleError(error);
                    }

                    public void handleResult(List<Attribute> result) {
                        AddRequest addRequest = Requests.newAddRequest((DN)DN.rootDN());
                        for (Attribute attribute : LDAPCollectionResourceProvider.this.additionalLDAPAttributes) {
                            addRequest.addAttribute(attribute);
                        }
                        for (Attribute attribute : result) {
                            addRequest.addAttribute(attribute);
                        }
                        try {
                            LDAPCollectionResourceProvider.this.nameStrategy.setResourceId(c, LDAPCollectionResourceProvider.this.getBaseDN(c), request.getNewResourceId(), (Entry)addRequest);
                        }
                        catch (ResourceException e) {
                            h.handleError(e);
                            return;
                        }
                        if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                            String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                            addRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, (String[])attributes));
                        }
                        c.getConnection().applyChangeAsync((ChangeRecord)addRequest, null, LDAPCollectionResourceProvider.this.postUpdateHandler(c, (org.forgerock.json.resource.ResultHandler<Resource>)h));
                    }
                });
            }
        });
    }

    public void deleteInstance(ServerContext context, String resourceId, final org.forgerock.json.resource.DeleteRequest request, org.forgerock.json.resource.ResultHandler<Resource> handler) {
        final Context c = this.wrap(context);
        final org.forgerock.json.resource.ResultHandler<Resource> h = this.wrap(c, handler);
        c.run(h, this.doUpdate(c, resourceId, request.getRevision(), new org.forgerock.json.resource.ResultHandler<DN>(){

            public void handleError(ResourceException error) {
                h.handleError(error);
            }

            public void handleResult(DN dn) {
                try {
                    DeleteRequest deleteRequest = Requests.newDeleteRequest((DN)dn);
                    if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                        String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                        deleteRequest.addControl((Control)PreReadRequestControl.newControl((boolean)false, (String[])attributes));
                    }
                    if (LDAPCollectionResourceProvider.this.config.useSubtreeDelete()) {
                        deleteRequest.addControl((Control)SubtreeDeleteRequestControl.newControl((boolean)true));
                    }
                    LDAPCollectionResourceProvider.this.addAssertionControl((ChangeRecord)deleteRequest, request.getRevision());
                    c.getConnection().applyChangeAsync((ChangeRecord)deleteRequest, null, LDAPCollectionResourceProvider.this.postUpdateHandler(c, (org.forgerock.json.resource.ResultHandler<Resource>)h));
                }
                catch (Exception e) {
                    h.handleError(Rest2LDAP.asResourceException(e));
                }
            }
        }));
    }

    public void patchInstance(ServerContext context, String resourceId, final PatchRequest request, org.forgerock.json.resource.ResultHandler<Resource> handler) {
        final Context c = this.wrap(context);
        final org.forgerock.json.resource.ResultHandler<Resource> h = this.wrap(c, handler);
        c.run(h, this.doUpdate(c, resourceId, request.getRevision(), new org.forgerock.json.resource.ResultHandler<DN>(){

            public void handleError(ResourceException error) {
                h.handleError(error);
            }

            public void handleResult(final DN dn) {
                org.forgerock.json.resource.ResultHandler<List<Modification>> handler = Utils.accumulate(request.getPatchOperations().size(), new org.forgerock.json.resource.ResultHandler<List<List<Modification>>>(){

                    public void handleError(ResourceException error) {
                        h.handleError(error);
                    }

                    public void handleResult(List<List<Modification>> result) {
                        try {
                            ModifyRequest modifyRequest = Requests.newModifyRequest((DN)dn);
                            if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                                String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                                modifyRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, (String[])attributes));
                            }
                            if (LDAPCollectionResourceProvider.this.config.usePermissiveModify()) {
                                modifyRequest.addControl((Control)PermissiveModifyRequestControl.newControl((boolean)true));
                            }
                            LDAPCollectionResourceProvider.this.addAssertionControl((ChangeRecord)modifyRequest, request.getRevision());
                            for (List<Modification> modifications : result) {
                                if (modifications == null) continue;
                                modifyRequest.getModifications().addAll(modifications);
                            }
                            c.getConnection().applyChangeAsync((ChangeRecord)modifyRequest, null, LDAPCollectionResourceProvider.this.postUpdateHandler(c, (org.forgerock.json.resource.ResultHandler<Resource>)h));
                        }
                        catch (Exception e) {
                            h.handleError(Rest2LDAP.asResourceException(e));
                        }
                    }
                });
                for (PatchOperation operation : request.getPatchOperations()) {
                    LDAPCollectionResourceProvider.this.attributeMapper.patch(c, new JsonPointer(), operation, handler);
                }
            }
        }));
    }

    public void queryCollection(ServerContext context, final QueryRequest request, QueryResultHandler handler) {
        final Context c = this.wrap(context);
        final QueryResultHandler h = this.wrap(c, handler);
        c.run((org.forgerock.json.resource.ResultHandler<?>)h, new Runnable(){

            @Override
            public void run() {
                LDAPCollectionResourceProvider.this.getLDAPFilter(c, request.getQueryFilter(), (org.forgerock.json.resource.ResultHandler<Filter>)((org.forgerock.json.resource.ResultHandler)new org.forgerock.json.resource.ResultHandler<Filter>(){

                    public void handleError(ResourceException error) {
                        h.handleError(error);
                    }

                    public void handleResult(Filter ldapFilter) {
                        if (ldapFilter == null || ldapFilter == Filter.alwaysFalse()) {
                            h.handleResult(new QueryResult());
                        } else {
                            String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                            SearchRequest request = Requests.newSearchRequest((DN)LDAPCollectionResourceProvider.this.getBaseDN(c), (SearchScope)SearchScope.SINGLE_LEVEL, (Filter)(ldapFilter == Filter.alwaysTrue() ? Filter.objectClassPresent() : ldapFilter), (String[])attributes);
                            c.getConnection().searchAsync(request, null, new SearchResultHandler(){
                                private final Object sequenceLock = new Object();
                                private int pendingResourceCount = 0;
                                private ResourceException pendingResult = null;
                                private boolean resultSent = false;

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public boolean handleEntry(SearchResultEntry entry) {
                                    Object object = this.sequenceLock;
                                    synchronized (object) {
                                        if (this.pendingResult != null) {
                                            return false;
                                        }
                                        ++this.pendingResourceCount;
                                    }
                                    final String id = LDAPCollectionResourceProvider.this.nameStrategy.getResourceId(c, (Entry)entry);
                                    final String revision = LDAPCollectionResourceProvider.this.getRevisionFromEntry((Entry)entry);
                                    LDAPCollectionResourceProvider.this.attributeMapper.read(c, new JsonPointer(), (Entry)entry, new org.forgerock.json.resource.ResultHandler<JsonValue>(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void handleError(ResourceException e) {
                                            Object object = sequenceLock;
                                            synchronized (object) {
                                                pendingResourceCount--;
                                                this.completeIfNecessary(e);
                                            }
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void handleResult(JsonValue result) {
                                            Object object = sequenceLock;
                                            synchronized (object) {
                                                pendingResourceCount--;
                                                if (!resultSent) {
                                                    h.handleResource(new Resource(id, revision, result));
                                                }
                                                this.completeIfNecessary();
                                            }
                                        }
                                    });
                                    return true;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void handleErrorResult(ErrorResultException error) {
                                    Object object = this.sequenceLock;
                                    synchronized (object) {
                                        this.completeIfNecessary(Rest2LDAP.asResourceException((Throwable)error));
                                    }
                                }

                                public boolean handleReference(SearchResultReference reference) {
                                    return true;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void handleResult(Result result) {
                                    Object object = this.sequenceLock;
                                    synchronized (object) {
                                        this.completeIfNecessary(SUCCESS);
                                    }
                                }

                                private void completeIfNecessary(ResourceException e) {
                                    if (this.pendingResult == null) {
                                        this.pendingResult = e;
                                    }
                                    this.completeIfNecessary();
                                }

                                private void completeIfNecessary() {
                                    if (this.pendingResourceCount == 0 && this.pendingResult != null && !this.resultSent) {
                                        if (this.pendingResult == SUCCESS) {
                                            h.handleResult(new QueryResult());
                                        } else {
                                            h.handleError(this.pendingResult);
                                        }
                                        this.resultSent = true;
                                    }
                                }
                            });
                        }
                    }
                }));
            }
        });
    }

    public void readInstance(ServerContext context, final String resourceId, final ReadRequest request, org.forgerock.json.resource.ResultHandler<Resource> handler) {
        final Context c = this.wrap(context);
        final org.forgerock.json.resource.ResultHandler<Resource> h = this.wrap(c, handler);
        c.run(h, new Runnable(){

            @Override
            public void run() {
                String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                SearchRequest request2 = LDAPCollectionResourceProvider.this.nameStrategy.createSearchRequest(c, LDAPCollectionResourceProvider.this.getBaseDN(c), resourceId).addAttribute(attributes);
                c.getConnection().searchSingleEntryAsync(request2, (ResultHandler)new ResultHandler<SearchResultEntry>(){

                    public void handleErrorResult(ErrorResultException error) {
                        h.handleError(Rest2LDAP.asResourceException((Throwable)error));
                    }

                    public void handleResult(SearchResultEntry entry) {
                        LDAPCollectionResourceProvider.this.adaptEntry(c, (Entry)entry, (org.forgerock.json.resource.ResultHandler<Resource>)h);
                    }
                });
            }
        });
    }

    public void updateInstance(ServerContext context, final String resourceId, final UpdateRequest request, org.forgerock.json.resource.ResultHandler<Resource> handler) {
        final Context c = this.wrap(context);
        final org.forgerock.json.resource.ResultHandler<Resource> h = this.wrap(c, handler);
        c.run(h, new Runnable(){

            @Override
            public void run() {
                String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, Collections.emptyList());
                SearchRequest searchRequest = LDAPCollectionResourceProvider.this.nameStrategy.createSearchRequest(c, LDAPCollectionResourceProvider.this.getBaseDN(c), resourceId).addAttribute(attributes);
                c.getConnection().searchSingleEntryAsync(searchRequest, (ResultHandler)new ResultHandler<SearchResultEntry>(){

                    public void handleErrorResult(ErrorResultException error) {
                        h.handleError(Rest2LDAP.asResourceException((Throwable)error));
                    }

                    public void handleResult(SearchResultEntry entry) {
                        try {
                            LDAPCollectionResourceProvider.this.ensureMVCCVersionMatches((Entry)entry, request.getRevision());
                            final ModifyRequest modifyRequest = Requests.newModifyRequest((DN)entry.getName());
                            if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                                String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                                modifyRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, (String[])attributes));
                            }
                            if (LDAPCollectionResourceProvider.this.config.usePermissiveModify()) {
                                modifyRequest.addControl((Control)PermissiveModifyRequestControl.newControl((boolean)true));
                            }
                            LDAPCollectionResourceProvider.this.addAssertionControl((ChangeRecord)modifyRequest, request.getRevision());
                            LDAPCollectionResourceProvider.this.attributeMapper.update(c, new JsonPointer(), (Entry)entry, request.getNewContent(), new org.forgerock.json.resource.ResultHandler<List<Modification>>(){

                                public void handleError(ResourceException error) {
                                    h.handleError(error);
                                }

                                public void handleResult(List<Modification> result) {
                                    modifyRequest.getModifications().addAll(result);
                                    c.getConnection().applyChangeAsync((ChangeRecord)modifyRequest, null, LDAPCollectionResourceProvider.this.postUpdateHandler(c, (org.forgerock.json.resource.ResultHandler<Resource>)h));
                                }
                            });
                        }
                        catch (Exception e) {
                            h.handleError(Rest2LDAP.asResourceException(e));
                        }
                    }
                });
            }
        });
    }

    private void adaptEntry(Context c, Entry entry, org.forgerock.json.resource.ResultHandler<Resource> handler) {
        final String actualResourceId = this.nameStrategy.getResourceId(c, entry);
        final String revision = this.getRevisionFromEntry(entry);
        this.attributeMapper.read(c, new JsonPointer(), entry, Utils.transform(new Function<JsonValue, Resource, Void>(){

            public Resource apply(JsonValue value, Void p) {
                return new Resource(actualResourceId, revision, new JsonValue((Object)value));
            }
        }, handler));
    }

    private void addAssertionControl(ChangeRecord request, String expectedRevision) throws ResourceException {
        if (expectedRevision != null) {
            this.ensureMVCCSupported();
            request.addControl((Control)AssertionRequestControl.newControl((boolean)true, (Filter)Filter.equality((String)this.etagAttribute.toString(), (Object)expectedRevision)));
        }
    }

    private Runnable doUpdate(final Context c, final String resourceId, final String revision, final org.forgerock.json.resource.ResultHandler<DN> updateHandler) {
        return new Runnable(){

            @Override
            public void run() {
                String ldapAttribute = LDAPCollectionResourceProvider.this.etagAttribute != null && revision != null ? LDAPCollectionResourceProvider.this.etagAttribute.toString() : "1.1";
                SearchRequest searchRequest = LDAPCollectionResourceProvider.this.nameStrategy.createSearchRequest(c, LDAPCollectionResourceProvider.this.getBaseDN(c), resourceId).addAttribute(new String[]{ldapAttribute});
                if (searchRequest.getScope().equals((Object)SearchScope.BASE_OBJECT)) {
                    updateHandler.handleResult((Object)searchRequest.getName());
                } else {
                    c.getConnection().searchSingleEntryAsync(searchRequest, (ResultHandler)new ResultHandler<SearchResultEntry>(){

                        public void handleErrorResult(ErrorResultException error) {
                            updateHandler.handleError(Rest2LDAP.asResourceException((Throwable)error));
                        }

                        public void handleResult(SearchResultEntry entry) {
                            try {
                                LDAPCollectionResourceProvider.this.ensureMVCCVersionMatches((Entry)entry, revision);
                                updateHandler.handleResult((Object)entry.getName());
                            }
                            catch (Exception e) {
                                updateHandler.handleError(Rest2LDAP.asResourceException(e));
                            }
                        }
                    });
                }
            }
        };
    }

    private void ensureMVCCSupported() throws NotSupportedException {
        if (this.etagAttribute == null) {
            throw new NotSupportedException(Utils.i18n("Multi-version concurrency control is not supported by this resource", new Object[0]));
        }
    }

    private void ensureMVCCVersionMatches(Entry entry, String expectedRevision) throws ResourceException {
        if (expectedRevision != null) {
            this.ensureMVCCSupported();
            String actualRevision = entry.parseAttribute(this.etagAttribute).asString();
            if (actualRevision == null) {
                throw new PreconditionFailedException(Utils.i18n("The resource could not be accessed because it did not contain any version information, when the version '%s' was expected", expectedRevision));
            }
            if (!expectedRevision.equals(actualRevision)) {
                throw new PreconditionFailedException(Utils.i18n("The resource could not be accessed because the expected version '%s' does not match the current version '%s'", expectedRevision, actualRevision));
            }
        }
    }

    private DN getBaseDN(Context context) {
        return this.baseDN;
    }

    private String[] getLDAPAttributes(Context c, Collection<JsonPointer> requestedAttributes) {
        LinkedHashSet<String> requestedLDAPAttributes;
        if (requestedAttributes.isEmpty()) {
            requestedLDAPAttributes = new LinkedHashSet<String>();
            this.attributeMapper.getLDAPAttributes(c, new JsonPointer(), new JsonPointer(), requestedLDAPAttributes);
        } else {
            requestedLDAPAttributes = new LinkedHashSet(requestedAttributes.size());
            for (JsonPointer requestedAttribute : requestedAttributes) {
                this.attributeMapper.getLDAPAttributes(c, new JsonPointer(), requestedAttribute, requestedLDAPAttributes);
            }
        }
        this.nameStrategy.getLDAPAttributes(c, requestedLDAPAttributes);
        if (this.etagAttribute != null) {
            requestedLDAPAttributes.add(this.etagAttribute.toString());
        }
        return requestedLDAPAttributes.toArray(new String[requestedLDAPAttributes.size()]);
    }

    private void getLDAPFilter(final Context c, QueryFilter queryFilter, org.forgerock.json.resource.ResultHandler<Filter> h) {
        QueryFilterVisitor<Void, org.forgerock.json.resource.ResultHandler<Filter>> visitor = new QueryFilterVisitor<Void, org.forgerock.json.resource.ResultHandler<Filter>>(){

            public Void visitAndFilter(org.forgerock.json.resource.ResultHandler<Filter> p, List<QueryFilter> subFilters) {
                org.forgerock.json.resource.ResultHandler<Filter> handler = Utils.accumulate(subFilters.size(), Utils.transform(new Function<List<Filter>, Filter, Void>(){

                    public Filter apply(List<Filter> value, Void p) {
                        Iterator<Filter> i = value.iterator();
                        while (i.hasNext()) {
                            Filter f = i.next();
                            if (f == Filter.alwaysFalse()) {
                                return Filter.alwaysFalse();
                            }
                            if (f != Filter.alwaysTrue()) continue;
                            i.remove();
                        }
                        switch (value.size()) {
                            case 0: {
                                return Filter.alwaysTrue();
                            }
                            case 1: {
                                return value.get(0);
                            }
                        }
                        return Filter.and(value);
                    }
                }, p));
                for (QueryFilter subFilter : subFilters) {
                    subFilter.accept((QueryFilterVisitor)this, handler);
                }
                return null;
            }

            public Void visitBooleanLiteralFilter(org.forgerock.json.resource.ResultHandler<Filter> p, boolean value) {
                p.handleResult((Object)Utils.toFilter(value));
                return null;
            }

            public Void visitContainsFilter(org.forgerock.json.resource.ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.CONTAINS, null, valueAssertion, p);
                return null;
            }

            public Void visitEqualsFilter(org.forgerock.json.resource.ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.EQUAL_TO, null, valueAssertion, p);
                return null;
            }

            public Void visitExtendedMatchFilter(org.forgerock.json.resource.ResultHandler<Filter> p, JsonPointer field, String operator, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.EXTENDED, operator, valueAssertion, p);
                return null;
            }

            public Void visitGreaterThanFilter(org.forgerock.json.resource.ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.GREATER_THAN, null, valueAssertion, p);
                return null;
            }

            public Void visitGreaterThanOrEqualToFilter(org.forgerock.json.resource.ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.GREATER_THAN_OR_EQUAL_TO, null, valueAssertion, p);
                return null;
            }

            public Void visitLessThanFilter(org.forgerock.json.resource.ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.LESS_THAN, null, valueAssertion, p);
                return null;
            }

            public Void visitLessThanOrEqualToFilter(org.forgerock.json.resource.ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.LESS_THAN_OR_EQUAL_TO, null, valueAssertion, p);
                return null;
            }

            public Void visitNotFilter(org.forgerock.json.resource.ResultHandler<Filter> p, QueryFilter subFilter) {
                subFilter.accept((QueryFilterVisitor)this, Utils.transform(new Function<Filter, Filter, Void>(){

                    public Filter apply(Filter value, Void p) {
                        if (value == null || value == Filter.alwaysFalse()) {
                            return Filter.alwaysTrue();
                        }
                        if (value == Filter.alwaysTrue()) {
                            return Filter.alwaysFalse();
                        }
                        return Filter.not((Filter)value);
                    }
                }, p));
                return null;
            }

            public Void visitOrFilter(org.forgerock.json.resource.ResultHandler<Filter> p, List<QueryFilter> subFilters) {
                org.forgerock.json.resource.ResultHandler<Filter> handler = Utils.accumulate(subFilters.size(), Utils.transform(new Function<List<Filter>, Filter, Void>(){

                    public Filter apply(List<Filter> value, Void p) {
                        Iterator<Filter> i = value.iterator();
                        while (i.hasNext()) {
                            Filter f = i.next();
                            if (f == Filter.alwaysFalse()) {
                                i.remove();
                                continue;
                            }
                            if (f != Filter.alwaysTrue()) continue;
                            return Filter.alwaysTrue();
                        }
                        switch (value.size()) {
                            case 0: {
                                return Filter.alwaysFalse();
                            }
                            case 1: {
                                return value.get(0);
                            }
                        }
                        return Filter.or(value);
                    }
                }, p));
                for (QueryFilter subFilter : subFilters) {
                    subFilter.accept((QueryFilterVisitor)this, handler);
                }
                return null;
            }

            public Void visitPresentFilter(org.forgerock.json.resource.ResultHandler<Filter> p, JsonPointer field) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.PRESENT, null, null, p);
                return null;
            }

            public Void visitStartsWithFilter(org.forgerock.json.resource.ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.STARTS_WITH, null, valueAssertion, p);
                return null;
            }
        };
        queryFilter.accept((QueryFilterVisitor)visitor, h);
    }

    private String getRevisionFromEntry(Entry entry) {
        return this.etagAttribute != null ? entry.parseAttribute(this.etagAttribute).asString() : null;
    }

    private ResultHandler<Result> postUpdateHandler(final Context c, final org.forgerock.json.resource.ResultHandler<Resource> handler) {
        return new ResultHandler<Result>(){

            public void handleErrorResult(ErrorResultException error) {
                handler.handleError(Rest2LDAP.asResourceException((Throwable)error));
            }

            public void handleResult(Result result) {
                Object entry;
                try {
                    PreReadResponseControl preReadControl;
                    PostReadResponseControl postReadControl = (PostReadResponseControl)result.getControl(PostReadResponseControl.DECODER, LDAPCollectionResourceProvider.this.config.decodeOptions());
                    entry = postReadControl != null ? postReadControl.getEntry() : ((preReadControl = (PreReadResponseControl)result.getControl(PreReadResponseControl.DECODER, LDAPCollectionResourceProvider.this.config.decodeOptions())) != null ? preReadControl.getEntry() : null);
                }
                catch (DecodeException e) {
                    entry = null;
                }
                if (entry != null) {
                    LDAPCollectionResourceProvider.this.adaptEntry(c, entry, (org.forgerock.json.resource.ResultHandler<Resource>)handler);
                } else {
                    Resource resource = new Resource(null, null, new JsonValue(Collections.emptyMap()));
                    handler.handleResult((Object)resource);
                }
            }
        };
    }

    private QueryResultHandler wrap(final Context c, final QueryResultHandler handler) {
        return new QueryResultHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleError(ResourceException error) {
                try {
                    handler.handleError(error);
                }
                finally {
                    c.close();
                }
            }

            public boolean handleResource(Resource resource) {
                return handler.handleResource(resource);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResult(QueryResult result) {
                try {
                    handler.handleResult(result);
                }
                finally {
                    c.close();
                }
            }
        };
    }

    private <V> org.forgerock.json.resource.ResultHandler<V> wrap(final Context c, final org.forgerock.json.resource.ResultHandler<V> handler) {
        return new org.forgerock.json.resource.ResultHandler<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleError(ResourceException error) {
                try {
                    handler.handleError(error);
                }
                finally {
                    c.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResult(V result) {
                try {
                    handler.handleResult(result);
                }
                finally {
                    c.close();
                }
            }
        };
    }

    private Context wrap(ServerContext context) {
        return new Context(this.config, context);
    }
}

