/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.Context;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.Utils;

final class JSONConstantAttributeMapper
extends AttributeMapper {
    private final JsonValue value;

    JSONConstantAttributeMapper(Object value) {
        this.value = new JsonValue(value);
    }

    public String toString() {
        return "constant(" + this.value.toString() + ")";
    }

    @Override
    void create(Context c, JsonPointer path, JsonValue v, ResultHandler<List<Attribute>> h) {
        if (!Utils.isNullOrEmpty(v) && !v.getObject().equals(this.value.getObject())) {
            h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to create the read-only field '%s'", path)));
        } else {
            h.handleResult(Collections.emptyList());
        }
    }

    @Override
    void getLDAPAttributes(Context c, JsonPointer path, JsonPointer subPath, Set<String> ldapAttributes) {
    }

    @Override
    void getLDAPFilter(Context c, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion, ResultHandler<Filter> h) {
        Filter filter;
        JsonValue subValue = this.value.get(subPath);
        if (subValue == null) {
            filter = Filter.alwaysFalse();
        } else if (type == FilterType.PRESENT) {
            filter = Filter.alwaysTrue();
        } else if (this.value.isString() && valueAssertion instanceof String) {
            String v1 = Utils.toLowerCase(this.value.asString());
            String v2 = Utils.toLowerCase((String)valueAssertion);
            switch (type) {
                case CONTAINS: {
                    filter = Utils.toFilter(v1.contains(v2));
                    break;
                }
                case STARTS_WITH: {
                    filter = Utils.toFilter(v1.startsWith(v2));
                    break;
                }
                default: {
                    filter = this.compare(c, type, v1, v2);
                    break;
                }
            }
        } else if (this.value.isNumber() && valueAssertion instanceof Number) {
            Double v1 = this.value.asDouble();
            Double v2 = ((Number)valueAssertion).doubleValue();
            filter = this.compare(c, type, v1, v2);
        } else if (this.value.isBoolean() && valueAssertion instanceof Boolean) {
            Boolean v1 = this.value.asBoolean();
            Boolean v2 = (Boolean)valueAssertion;
            filter = this.compare(c, type, v1, v2);
        } else {
            filter = Filter.alwaysFalse();
        }
        h.handleResult((Object)filter);
    }

    @Override
    void patch(Context c, JsonPointer path, PatchOperation operation, ResultHandler<List<Modification>> h) {
        h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to patch the read-only field '%s'", path)));
    }

    @Override
    void read(Context c, JsonPointer path, Entry e, ResultHandler<JsonValue> h) {
        h.handleResult((Object)this.value.copy());
    }

    @Override
    void update(Context c, JsonPointer path, Entry e, JsonValue v, ResultHandler<List<Modification>> h) {
        if (!Utils.isNullOrEmpty(v) && !v.getObject().equals(this.value.getObject())) {
            h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to modify the read-only field '%s'", path)));
        } else {
            h.handleResult(Collections.emptyList());
        }
    }

    private <T extends Comparable<T>> Filter compare(Context c, FilterType type, T v1, T v2) {
        Filter filter;
        switch (type) {
            case EQUAL_TO: {
                filter = Utils.toFilter(v1.equals(v2));
                break;
            }
            case GREATER_THAN: {
                filter = Utils.toFilter(v1.compareTo(v2) > 0);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                filter = Utils.toFilter(v1.compareTo(v2) >= 0);
                break;
            }
            case LESS_THAN: {
                filter = Utils.toFilter(v1.compareTo(v2) < 0);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                filter = Utils.toFilter(v1.compareTo(v2) <= 0);
                break;
            }
            default: {
                filter = Filter.alwaysFalse();
            }
        }
        return filter;
    }
}

