/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.SecurityContext;
import org.forgerock.json.resource.ServerContext;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ProxiedAuthV2RequestControl;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.rest2ldap.AuthenticatedConnectionContext;
import org.forgerock.opendj.rest2ldap.AuthorizationPolicy;
import org.forgerock.opendj.rest2ldap.Config;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;

final class Context
implements Closeable {
    private final Map<DN, CachedRead> cachedReads = new LinkedHashMap<DN, CachedRead>(){
        private static final int MAX_CACHED_ENTRIES = 32;

        @Override
        protected boolean removeEldestEntry(Map.Entry<DN, CachedRead> eldest) {
            return this.size() > 32;
        }
    };
    private final Config config;
    private final ServerContext context;
    private Connection connection;
    private Control proxiedAuthzControl = null;

    Context(Config config, ServerContext context) {
        this.config = config;
        this.context = context;
        if (config.getAuthorizationPolicy() != AuthorizationPolicy.NONE && context.containsContext(AuthenticatedConnectionContext.class)) {
            Connection connection = ((AuthenticatedConnectionContext)context.asContext(AuthenticatedConnectionContext.class)).getConnection();
            this.connection = this.wrap(connection);
        } else {
            this.connection = null;
        }
    }

    @Override
    public void close() {
        this.connection.close();
    }

    Config getConfig() {
        return this.config;
    }

    Connection getConnection() {
        return this.connection;
    }

    ServerContext getServerContext() {
        return this.context;
    }

    void run(final org.forgerock.json.resource.ResultHandler<?> handler, final Runnable runnable) {
        if (this.connection == null && this.config.getAuthorizationPolicy() == AuthorizationPolicy.PROXY) {
            if (this.context.containsContext(SecurityContext.class)) {
                try {
                    SecurityContext securityContext = (SecurityContext)this.context.asContext(SecurityContext.class);
                    String authzId = this.config.getProxiedAuthorizationTemplate().formatAsAuthzId(securityContext.getAuthorizationId(), this.config.schema());
                    this.proxiedAuthzControl = ProxiedAuthV2RequestControl.newControl((String)authzId);
                }
                catch (ResourceException e) {
                    handler.handleError(e);
                    return;
                }
            } else {
                handler.handleError((ResourceException)new InternalServerErrorException(Utils.i18n("The request could not be authorized because it did not contain a security context", new Object[0])));
                return;
            }
        }
        if (this.connection != null) {
            runnable.run();
        } else if (this.config.connectionFactory() != null) {
            this.config.connectionFactory().getConnectionAsync((ResultHandler)new ResultHandler<Connection>(){

                public final void handleErrorResult(ErrorResultException error) {
                    handler.handleError(Rest2LDAP.asResourceException((Throwable)error));
                }

                public final void handleResult(Connection result) {
                    Context.this.connection = Context.this.wrap(result);
                    runnable.run();
                }
            });
        } else {
            handler.handleError((ResourceException)new InternalServerErrorException(Utils.i18n("The request could not be processed because there was no LDAP connection available for use", new Object[0])));
        }
    }

    private Connection wrap(final Connection connection) {
        return new AbstractAsynchronousConnection(){

            public FutureResult<Void> abandonAsync(AbandonRequest request) {
                return connection.abandonAsync(request);
            }

            public FutureResult<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
                return connection.addAsync(this.withControls(request), intermediateResponseHandler, resultHandler);
            }

            public void addConnectionEventListener(ConnectionEventListener listener) {
                connection.addConnectionEventListener(listener);
            }

            public FutureResult<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super BindResult> resultHandler) {
                this.evictAll();
                return connection.bindAsync(request, intermediateResponseHandler, resultHandler);
            }

            public void close() {
                connection.close();
            }

            public void close(UnbindRequest request, String reason) {
                connection.close(request, reason);
            }

            public FutureResult<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super CompareResult> resultHandler) {
                return connection.compareAsync(this.withControls(request), intermediateResponseHandler, resultHandler);
            }

            public FutureResult<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
                this.evict(request.getName());
                return connection.deleteAsync(this.withControls(request), intermediateResponseHandler, resultHandler);
            }

            public <R extends ExtendedResult> FutureResult<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super R> resultHandler) {
                this.evictAll();
                return connection.extendedRequestAsync(this.withControls((R)request), intermediateResponseHandler, resultHandler);
            }

            public boolean isClosed() {
                return connection.isClosed();
            }

            public boolean isValid() {
                return connection.isValid();
            }

            public FutureResult<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
                this.evict(request.getName());
                return connection.modifyAsync(this.withControls(request), intermediateResponseHandler, resultHandler);
            }

            public FutureResult<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
                this.evictAll();
                return connection.modifyDNAsync(this.withControls(request), intermediateResponseHandler, resultHandler);
            }

            public void removeConnectionEventListener(ConnectionEventListener listener) {
                connection.removeConnectionEventListener(listener);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FutureResult<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler resultHandler) {
                CachedRead cachedRead;
                if (!request.getScope().equals((Object)SearchScope.BASE_OBJECT) || intermediateResponseHandler != null) {
                    return connection.searchAsync(this.withControls(request), intermediateResponseHandler, resultHandler);
                }
                Map map = Context.this.cachedReads;
                synchronized (map) {
                    cachedRead = (CachedRead)Context.this.cachedReads.get(request.getName());
                }
                if (cachedRead != null && cachedRead.isMatchingRead(request)) {
                    cachedRead.addResultHandler(resultHandler);
                    return cachedRead.getFutureResult();
                }
                CachedRead pendingCachedRead = new CachedRead(request, resultHandler);
                Map map2 = Context.this.cachedReads;
                synchronized (map2) {
                    Context.this.cachedReads.put(request.getName(), pendingCachedRead);
                }
                FutureResult future = connection.searchAsync(this.withControls(request), intermediateResponseHandler, (SearchResultHandler)pendingCachedRead);
                pendingCachedRead.setFuture((FutureResult<Result>)future);
                return future;
            }

            public String toString() {
                return connection.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void evict(DN name) {
                Map map = Context.this.cachedReads;
                synchronized (map) {
                    Context.this.cachedReads.remove(name);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void evictAll() {
                Map map = Context.this.cachedReads;
                synchronized (map) {
                    Context.this.cachedReads.clear();
                }
            }

            private <R extends Request> R withControls(R request) {
                if (Context.this.proxiedAuthzControl != null) {
                    request.addControl(Context.this.proxiedAuthzControl);
                }
                return request;
            }
        };
    }

    private static final class CachedRead
    implements SearchResultHandler {
        private SearchResultEntry cachedEntry;
        private final String cachedFilterString;
        private FutureResult<Result> cachedFuture;
        private final CountDownLatch cachedFutureLatch = new CountDownLatch(1);
        private final SearchRequest cachedRequest;
        private volatile Result cachedResult;
        private final ConcurrentLinkedQueue<SearchResultHandler> waitingResultHandlers = new ConcurrentLinkedQueue();

        CachedRead(SearchRequest request, SearchResultHandler resultHandler) {
            this.cachedRequest = request;
            this.cachedFilterString = request.getFilter().toString();
            this.waitingResultHandlers.add(resultHandler);
        }

        public boolean handleEntry(SearchResultEntry entry) {
            this.cachedEntry = entry;
            return true;
        }

        public void handleErrorResult(ErrorResultException error) {
            this.handleResult(error.getResult());
        }

        public boolean handleReference(SearchResultReference reference) {
            return true;
        }

        public void handleResult(Result result) {
            this.cachedResult = result;
            this.drainQueue();
        }

        void addResultHandler(SearchResultHandler resultHandler) {
            if (this.cachedResult != null) {
                this.invokeResultHandler(resultHandler);
                return;
            }
            this.waitingResultHandlers.add(resultHandler);
            if (this.cachedResult != null) {
                this.drainQueue();
            }
        }

        FutureResult<Result> getFutureResult() {
            boolean wasInterrupted = false;
            while (true) {
                try {
                    this.cachedFutureLatch.await();
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return this.cachedFuture;
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                    continue;
                }
                break;
            }
        }

        boolean isMatchingRead(SearchRequest request) {
            if (!request.getScope().equals((Object)SearchScope.BASE_OBJECT)) {
                return false;
            }
            if (!request.getFilter().toString().equals(this.cachedFilterString)) {
                return false;
            }
            return request.getAttributes().equals(this.cachedRequest.getAttributes());
        }

        void setFuture(FutureResult<Result> future) {
            this.cachedFuture = future;
            this.cachedFutureLatch.countDown();
        }

        private void drainQueue() {
            SearchResultHandler resultHandler;
            while ((resultHandler = this.waitingResultHandlers.poll()) != null) {
                this.invokeResultHandler(resultHandler);
            }
        }

        private void invokeResultHandler(SearchResultHandler resultHandler) {
            if (this.cachedEntry != null) {
                resultHandler.handleEntry(this.cachedEntry);
            }
            if (this.cachedResult.isSuccess()) {
                resultHandler.handleResult((Object)this.cachedResult);
            } else {
                resultHandler.handleErrorResult(ErrorResultException.newErrorResult((Result)this.cachedResult));
            }
        }
    }
}

