/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.PersistenceConfig;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.rest2ldap.Utils;

public final class AuthenticatedConnectionContext
extends Context {
    private final Connection connection;

    public AuthenticatedConnectionContext(Context parent, Connection connection) {
        super(Utils.ensureNotNull(parent));
        this.connection = connection;
    }

    public AuthenticatedConnectionContext(String id, Context parent, Connection connection) {
        super(id, Utils.ensureNotNull(parent));
        this.connection = connection;
    }

    AuthenticatedConnectionContext(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super(savedContext, config);
        throw new InternalServerErrorException(Utils.i18n("Cached LDAP connections cannot be restored", new Object[0]));
    }

    protected void saveToJson(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super.saveToJson(savedContext, config);
        throw new InternalServerErrorException(Utils.i18n("Cached LDAP connections cannot be persisted", new Object[0]));
    }

    Connection getConnection() {
        return this.connection;
    }
}

