/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.util.ProgressMessageFormatter;

public class PlainTextProgressMessageFormatter
implements ProgressMessageFormatter {
    private Message doneText;
    private Message errorText;
    private static String SPACE = " ";

    @Override
    public Message getFormattedText(Message text) {
        return text;
    }

    @Override
    public Message getFormattedSummary(Message text) {
        return text;
    }

    @Override
    public Message getFormattedError(Message text, boolean applyMargin) {
        Message result = applyMargin ? new MessageBuilder().append(Constants.LINE_SEPARATOR).append(text).toMessage() : text;
        return result;
    }

    @Override
    public Message getFormattedWarning(Message text, boolean applyMargin) {
        Message result = applyMargin ? new MessageBuilder(Constants.LINE_SEPARATOR).append(text).toMessage() : text;
        return result;
    }

    @Override
    public Message getFormattedSuccess(Message text) {
        return text;
    }

    @Override
    public Message getFormattedLogError(Message text) {
        return text;
    }

    @Override
    public Message getFormattedLog(Message text) {
        return text;
    }

    @Override
    public Message getFormattedDone() {
        if (this.doneText == null) {
            this.doneText = QuickSetupMessages.INFO_PROGRESS_DONE.get();
        }
        return this.doneText;
    }

    @Override
    public Message getFormattedError() {
        if (this.errorText == null) {
            this.errorText = QuickSetupMessages.INFO_PROGRESS_ERROR.get();
        }
        return this.errorText;
    }

    @Override
    public Message getFormattedWithPoints(Message text) {
        return new MessageBuilder(text).append(SPACE).append(QuickSetupMessages.INFO_PROGRESS_POINTS.get()).append(SPACE).toMessage();
    }

    @Override
    public Message getFormattedPoint() {
        return Message.raw(".", new Object[0]);
    }

    @Override
    public Message getSpace() {
        return Message.raw(SPACE, new Object[0]);
    }

    @Override
    public Message getFormattedProgress(Message text) {
        return text;
    }

    @Override
    public Message getFormattedError(Throwable t, boolean applyMargin) {
        String msg = t.getMessage();
        if (msg == null) {
            msg = t.toString();
        }
        String result = applyMargin ? Constants.LINE_SEPARATOR + msg : msg;
        return Message.raw(result, new Object[0]);
    }

    @Override
    public Message getLineBreak() {
        return Message.raw(Constants.LINE_SEPARATOR, new Object[0]);
    }

    @Override
    public Message getTab() {
        return Message.raw("     ", new Object[0]);
    }

    @Override
    public Message getTaskSeparator() {
        return Message.raw(Constants.LINE_SEPARATOR + "-----------------------------------------------------------------" + Constants.LINE_SEPARATOR + Constants.LINE_SEPARATOR, new Object[0]);
    }

    @Override
    public Message getFormattedAfterUrlClick(String url, Message lastText) {
        throw new IllegalStateException("PlainTextProgressMessageFormatter.getFormattedAfterUrlClick must not be called");
    }
}

