/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.opends.quicksetup.ui.UIFactory;

public class FramePanel
extends JPanel {
    private static final long serialVersionUID = 7733658951410876078L;
    private Icon backgroundIcon;
    private Component stepsPanel;
    private Component buttonsPanel;
    private int buttonsPanelVerticalInsets;
    private int stepsPanelHorizontalInsets;

    public FramePanel(Component stepsPanel, Component currentStepPanel, Component buttonsPanel) {
        super(new GridBagLayout());
        this.setBackground(UIFactory.DEFAULT_BACKGROUND);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 3;
        gbc.insets = UIFactory.getStepsPanelInsets();
        this.add(stepsPanel, gbc);
        this.stepsPanelHorizontalInsets = gbc.insets.left + gbc.insets.right;
        JPanel currentPanelContainer = new JPanel(new GridBagLayout());
        currentPanelContainer.setBorder(UIFactory.CURRENT_STEP_PANEL_BORDER);
        currentPanelContainer.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        currentPanelContainer.setOpaque(false);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = UIFactory.getCurrentStepPanelInsets();
        currentPanelContainer.add(currentStepPanel, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        this.add((Component)currentPanelContainer, gbc);
        gbc.gridwidth = -1;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        this.add(buttonsPanel, gbc);
        this.buttonsPanelVerticalInsets = gbc.insets.top + gbc.insets.bottom;
        this.backgroundIcon = UIFactory.getImageIcon(UIFactory.IconType.BACKGROUND);
        int backGroundIconWidth = 0;
        int backGroundIconHeight = 0;
        if (this.backgroundIcon != null) {
            backGroundIconWidth = this.backgroundIcon.getIconWidth();
            backGroundIconHeight = this.backgroundIcon.getIconHeight();
        }
        this.buttonsPanel = buttonsPanel;
        this.stepsPanel = stepsPanel;
        int width = Math.max((int)this.getPreferredSize().getWidth(), backGroundIconWidth + 20 + 20);
        int height = Math.max((int)this.getPreferredSize().getHeight(), backGroundIconHeight + 70 + 30);
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(UIFactory.DEFAULT_BACKGROUND);
        int width = this.getWidth();
        int height = this.getHeight();
        int buttonsTotalHeight = this.buttonsPanel.getHeight() + this.buttonsPanelVerticalInsets;
        int stepsPanelTotalWidth = this.stepsPanel.getWidth() + this.stepsPanelHorizontalInsets;
        g.fillRect(0, 0, stepsPanelTotalWidth, height);
        g.fillRect(stepsPanelTotalWidth, height - buttonsTotalHeight, width, height);
        g.setColor(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        g.fillRect(stepsPanelTotalWidth, 0, width, height - buttonsTotalHeight);
        if (this.backgroundIcon != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.1f));
            this.backgroundIcon.paintIcon(this, g2d, 20, 70);
            g2d.dispose();
        }
    }
}

