/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.server.types.OpenDsException;

public class ADSContextException
extends OpenDsException {
    private static final long serialVersionUID = 1984039711031042813L;
    private String toString;
    ErrorType error;
    Throwable embeddedException;

    public ADSContextException(ErrorType error) {
        this(error, null);
    }

    public ADSContextException(ErrorType error, Throwable x) {
        this(error, ADSContextException.getMessage(error, x), x);
    }

    public ADSContextException(ErrorType error, Message msg, Throwable x) {
        super(msg);
        this.error = error;
        this.embeddedException = x;
        this.toString = "ADSContextException: error type " + (Object)((Object)error) + ".";
        if (this.getCause() != null) {
            this.toString = this.toString + "  Root cause: " + this.getCause().toString();
        }
    }

    public ErrorType getError() {
        return this.error;
    }

    @Override
    public Throwable getCause() {
        return this.embeddedException;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.embeddedException != null) {
            System.out.println("embeddedException = {");
            this.embeddedException.printStackTrace();
            System.out.println("}");
        }
    }

    @Override
    public String toString() {
        return this.toString;
    }

    private static Message getMessage(ErrorType error, Throwable x) {
        Message msg = x != null ? (x instanceof OpenDsException ? QuickSetupMessages.INFO_ADS_CONTEXT_EXCEPTION_WITH_DETAILS_MSG.get(error.toString(), ((OpenDsException)x).getMessageObject()) : QuickSetupMessages.INFO_ADS_CONTEXT_EXCEPTION_WITH_DETAILS_MSG.get(error.toString(), x.toString())) : QuickSetupMessages.INFO_ADS_CONTEXT_EXCEPTION_MSG.get(error.toString());
        return msg;
    }

    public static enum ErrorType {
        MISSING_HOSTNAME,
        NOVALID_HOSTNAME,
        MISSING_IPATH,
        NOVALID_IPATH,
        ACCESS_PERMISSION,
        ALREADY_REGISTERED,
        BROKEN_INSTALL,
        NOT_YET_REGISTERED,
        MISSING_PORT,
        NOVALID_PORT,
        MISSING_NAME,
        MISSING_ADMIN_UID,
        MISSING_ADMIN_PASSWORD,
        UNEXPECTED_ADS_BACKEND_TYPE,
        ERROR_MERGING,
        ERROR_UNEXPECTED;

    }
}

