/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.fido2.ctap;

import java.util.HashMap;
import java.util.Map;

public enum AuthenticatorAttachment {
    PLATFORM("platform"),
    CROSS_PLATFORM("cross-platform");

    private final String attachment;
    private static Map<String, AuthenticatorAttachment> KEY_MAPPINGS;

    private AuthenticatorAttachment(String attachment) {
        this.attachment = attachment;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public static AuthenticatorAttachment fromAttachmentValue(String attachment) {
        return KEY_MAPPINGS.get(attachment);
    }

    static {
        KEY_MAPPINGS = new HashMap<String, AuthenticatorAttachment>();
        for (AuthenticatorAttachment enumType : AuthenticatorAttachment.values()) {
            KEY_MAPPINGS.put(enumType.getAttachment(), enumType);
        }
    }
}

