/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.fido.model.entry;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.gluu.fido.model.entry.DeviceRegistrationConfiguration;
import org.gluu.fido.model.entry.DeviceRegistrationStatus;
import org.gluu.oxauth.model.fido.u2f.protocol.DeviceData;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.Expiration;
import org.gluu.persist.annotation.JsonObject;
import org.gluu.persist.annotation.ObjectClass;
import org.gluu.persist.model.base.BaseEntry;

@DataEntry(sortBy={"creationDate"})
@ObjectClass(value="oxDeviceRegistration")
public class DeviceRegistration
extends BaseEntry
implements Serializable {
    private static final long serialVersionUID = -4542931562244920585L;
    @AttributeName(ignoreDuringUpdate=true, name="oxId")
    private String id;
    @AttributeName
    private String displayName;
    @AttributeName
    private String description;
    @AttributeName(name="oxNickName")
    private String nickname;
    @JsonObject
    @AttributeName(name="oxDeviceRegistrationConf")
    private DeviceRegistrationConfiguration deviceRegistrationConfiguration;
    @JsonObject
    @AttributeName(name="oxDeviceNotificationConf")
    private String deviceNotificationConf;
    @AttributeName(name="oxCounter")
    private long counter;
    @AttributeName(name="oxStatus")
    private DeviceRegistrationStatus status;
    @AttributeName(name="oxApplication")
    private String application;
    @AttributeName(name="oxDeviceKeyHandle")
    private String keyHandle;
    @AttributeName(name="oxDeviceHashCode")
    private Integer keyHandleHashCode;
    @JsonObject
    @AttributeName(name="oxDeviceData")
    private DeviceData deviceData;
    @AttributeName(name="creationDate")
    private Date creationDate;
    @AttributeName(name="oxLastAccessTime")
    private Date lastAccessTime;
    @AttributeName(name="exp")
    private Date expirationDate;
    @AttributeName(name="del")
    private boolean deletable = true;
    @Expiration
    private Integer ttl;

    public DeviceRegistration() {
    }

    public DeviceRegistration(String keyHandle, String publicKey, String attestationCert, long counter, DeviceRegistrationStatus status, String application, Integer keyHandleHashCode, Date creationDate) {
        this.deviceRegistrationConfiguration = new DeviceRegistrationConfiguration(publicKey, attestationCert);
        this.counter = counter;
        this.status = status;
        this.application = application;
        this.keyHandle = keyHandle;
        this.keyHandleHashCode = keyHandleHashCode;
        this.creationDate = creationDate;
        this.updateExpirationDate();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public DeviceRegistrationConfiguration getDeviceRegistrationConfiguration() {
        return this.deviceRegistrationConfiguration;
    }

    public void setDeviceRegistrationConfiguration(DeviceRegistrationConfiguration deviceRegistrationConfiguration) {
        this.deviceRegistrationConfiguration = deviceRegistrationConfiguration;
    }

    public String getDeviceNotificationConf() {
        return this.deviceNotificationConf;
    }

    public void setDeviceNotificationConf(String deviceNotificationConf) {
        this.deviceNotificationConf = deviceNotificationConf;
    }

    public long getCounter() {
        return this.counter;
    }

    public void setCounter(long counter) {
        this.counter = counter;
    }

    public DeviceRegistrationStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeviceRegistrationStatus status) {
        this.status = status;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    public void setKeyHandle(String keyHandle) {
        this.keyHandle = keyHandle;
    }

    public Integer getKeyHandleHashCode() {
        return this.keyHandleHashCode;
    }

    public void setKeyHandleHashCode(Integer keyHandleHashCode) {
        this.keyHandleHashCode = keyHandleHashCode;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        this.updateExpirationDate();
    }

    private void updateExpirationDate() {
        if (this.creationDate != null) {
            int expiration = 90;
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            calendar.setTime(this.creationDate);
            ((Calendar)calendar).add(13, 90);
            this.expirationDate = calendar.getTime();
            this.ttl = 90;
        }
    }

    public void clearExpiration() {
        this.expirationDate = null;
        this.deletable = false;
        this.ttl = 0;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public DeviceData getDeviceData() {
        return this.deviceData;
    }

    public void setDeviceData(DeviceData deviceData) {
        this.deviceData = deviceData;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public boolean isCompromised() {
        return DeviceRegistrationStatus.COMPROMISED == this.status;
    }

    public void markCompromised() {
        this.status = DeviceRegistrationStatus.COMPROMISED;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public String toString() {
        return "DeviceRegistration{id='" + this.id + '\'' + ", displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", nickname='" + this.nickname + '\'' + ", deviceRegistrationConfiguration=" + this.deviceRegistrationConfiguration + ", deviceNotificationConf='" + this.deviceNotificationConf + '\'' + ", counter=" + this.counter + ", status=" + (Object)((Object)this.status) + ", application='" + this.application + '\'' + ", keyHandle='" + this.keyHandle + '\'' + ", keyHandleHashCode=" + this.keyHandleHashCode + ", deviceData=" + this.deviceData + ", creationDate=" + this.creationDate + ", lastAccessTime=" + this.lastAccessTime + ", expirationDate=" + this.expirationDate + ", deletable=" + this.deletable + "} " + super.toString();
    }
}

