/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.strongauthn.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.gluu.casa.core.model.PersonPreferences;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.strongauthn.conf.Configuration;
import org.gluu.casa.plugins.strongauthn.conf.TrustedDevicesSettings;
import org.gluu.casa.plugins.strongauthn.model.TrustedDevice;
import org.gluu.casa.plugins.strongauthn.model.TrustedOrigin;
import org.gluu.casa.plugins.strongauthn.service.StrongAuthSettingsService;
import org.gluu.casa.service.IPersistenceService;
import org.gluu.search.filter.Filter;
import org.gluu.util.security.StringEncrypter;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedDevicesSweeper
implements Job {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPersistenceService persistenceService;
    private StringEncrypter stringEncrypter;
    private long locationExpiration;
    private long deviceExpiration;
    private ObjectMapper mapper = new ObjectMapper();

    public TrustedDevicesSweeper() {
        this.persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);
        Configuration settings = (Configuration)StrongAuthSettingsService.instance().getSettingsHandler().getSettings();
        Optional<TrustedDevicesSettings> tsettings = Optional.ofNullable(settings.getTrustedDevicesSettings());
        this.locationExpiration = TimeUnit.DAYS.toMillis(tsettings.map(TrustedDevicesSettings::getLocationExpirationDays).orElse(15).intValue());
        this.deviceExpiration = TimeUnit.DAYS.toMillis(tsettings.map(TrustedDevicesSettings::getDeviceExpirationDays).orElse(30).intValue());
        try {
            this.stringEncrypter = Utils.stringEncrypter();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.warn("Problem grabbing an instance of StringEncrypter. Device sweeping will not be available");
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (this.stringEncrypter == null) {
            return;
        }
        this.logger.info("TrustedDevicesSweeper. Running timer job");
        long now = System.currentTimeMillis();
        List<PersonPreferences> people = this.getPeopleTrustedDevices();
        for (PersonPreferences person : people) {
            String jsonStr = null;
            try {
                String trustedDevicesInfo = this.stringEncrypter.decrypt(person.getTrustedDevices());
                List list = (List)this.mapper.readValue(trustedDevicesInfo, (TypeReference)new TypeReference<List<TrustedDevice>>(){});
                if (!this.removeExpiredData(list, now)) continue;
                if (list.size() > 0) {
                    jsonStr = this.mapper.writeValueAsString((Object)list);
                    this.updateTrustedDevices(person, this.stringEncrypter.encrypt(jsonStr));
                    continue;
                }
                this.updateTrustedDevices(person, null);
            }
            catch (Exception e) {
                if (jsonStr == null) {
                    this.updateTrustedDevices(person, null);
                }
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean removeExpiredData(List<TrustedDevice> list, long time) {
        boolean changed = false;
        ArrayList<Integer> deviceIndexes = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            TrustedDevice device = list.get(i);
            List<TrustedOrigin> origins = device.getOrigins();
            if (origins != null) {
                ArrayList<Integer> origIndexes = new ArrayList<Integer>();
                for (int j = 0; j < origins.size(); ++j) {
                    long timeStamp = origins.get(j).getTimestamp();
                    if (time - timeStamp <= this.locationExpiration) continue;
                    origIndexes.add(0, j);
                }
                origIndexes.forEach(ind -> origins.remove((int)ind));
                boolean bl = changed = origIndexes.size() > 0;
            }
            if (device.getAddedOn() <= 0L || time - device.getAddedOn() <= this.deviceExpiration) continue;
            deviceIndexes.add(0, i);
            changed = true;
        }
        deviceIndexes.forEach(ind -> list.remove((int)ind));
        return changed;
    }

    private List<PersonPreferences> getPeopleTrustedDevices() {
        List<Object> list = new ArrayList<PersonPreferences>();
        try {
            list = this.persistenceService.find(PersonPreferences.class, this.persistenceService.getPeopleDn(), Filter.createPresenceFilter((String)"oxTrustedDevicesInfo"));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    private void updateTrustedDevices(PersonPreferences person, String value) {
        String uid = person.getUid();
        this.logger.trace("TrustedDevicesSweeper. Cleaning expired trusted devices for user '{}'", (Object)uid);
        person.setTrustedDevices(value);
        this.persistenceService.modify((Object)person);
    }
}

