/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.strongauthn;

import java.util.Collections;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.gluu.casa.core.ITrackable;
import org.gluu.casa.core.pojo.Basic2FASettings;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.strongauthn.conf.Configuration;
import org.gluu.casa.plugins.strongauthn.conf.EnforcementPolicy;
import org.gluu.casa.plugins.strongauthn.service.StrongAuthSettingsService;
import org.gluu.casa.plugins.strongauthn.service.TrustedDevicesSweeper;
import org.gluu.casa.service.settings.IPluginSettingsHandler;
import org.gluu.service.cache.CacheInterface;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrongAuthnSettingsPlugin
extends Plugin
implements ITrackable {
    public static final int TRUSTED_DEVICE_EXPIRATION_DAYS = 30;
    public static final int TRUSTED_LOCATION_EXPIRATION_DAYS = 15;
    private static final int ONE_DAY = (int)TimeUnit.DAYS.toSeconds(1L);
    private final String ACTIVE_INSTANCE_PRESENCE = ((Object)((Object)this)).getClass().getName() + "_activeInstanceSet";
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IPluginSettingsHandler<Configuration> settingsHandler;
    private Scheduler scheduler;
    private JobKey jobKey;
    private CacheInterface storeService;

    public StrongAuthnSettingsPlugin(PluginWrapper wrapper) throws Exception {
        super(wrapper);
        this.settingsHandler = StrongAuthSettingsService.instance(wrapper.getPluginId()).getSettingsHandler();
        this.storeService = (CacheInterface)Utils.managedBean(CacheInterface.class);
        this.scheduler = StdSchedulerFactory.getDefaultScheduler();
    }

    public void start() {
        if (this.settingsHandler.getSettings() == null) {
            try {
                this.logger.info("Initializing missing 2FA settings");
                Configuration conf = new Configuration();
                conf.setBasic2FASettings(new Basic2FASettings());
                conf.setEnforcement2FA(Collections.singletonList(EnforcementPolicy.EVERY_LOGIN));
                this.settingsHandler.setSettings((Object)conf);
                this.settingsHandler.save();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.storeService.get(this.ACTIVE_INSTANCE_PRESENCE) == null) {
            this.storeService.put(ONE_DAY, this.ACTIVE_INSTANCE_PRESENCE, (Object)true);
            this.jobKey = this.initTimer(10);
        }
    }

    public void delete() {
        try {
            if (this.jobKey != null) {
                this.logger.info("Removing trusted devices sweeper job");
                this.scheduler.deleteJob(this.jobKey);
            }
            this.logger.warn("Resetting strong authentication settings...");
            Configuration currentConfig = (Configuration)this.settingsHandler.getSettings();
            currentConfig.setBasic2FASettings(new Basic2FASettings());
            currentConfig.setTrustedDevicesSettings(null);
            currentConfig.setEnforcement2FA(Collections.singletonList(EnforcementPolicy.EVERY_LOGIN));
            this.settingsHandler.save();
            this.logger.info("Done.");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private JobKey initTimer(int gap) {
        try {
            if (!this.scheduler.isStarted()) {
                this.scheduler.start();
            }
            Class<TrustedDevicesSweeper> cls = TrustedDevicesSweeper.class;
            String name = cls.getSimpleName();
            String group = ((Object)((Object)this)).getClass().getSimpleName();
            this.logger.info("Scheduling timer {}", (Object)name);
            JobDetail job = JobBuilder.newJob(cls).withIdentity("job_" + name, group).build();
            SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("trigger_" + name, group).startAt(new Date(System.currentTimeMillis() + (long)(gap * 1000))).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(ONE_DAY).repeatForever()).build();
            this.scheduler.scheduleJob(job, (Trigger)trigger);
            return job.getKey();
        }
        catch (SchedulerException e) {
            this.logger.warn("Device sweeping won't be available");
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

