/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.strongauthn.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.gluu.casa.core.model.PersonPreferences;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.strongauthn.conf.Configuration;
import org.gluu.casa.plugins.strongauthn.conf.EnforcementPolicy;
import org.gluu.casa.plugins.strongauthn.model.TrustedDevice;
import org.gluu.casa.plugins.strongauthn.model.TrustedDeviceComparator;
import org.gluu.casa.service.IPersistenceService;
import org.gluu.casa.service.settings.IPluginSettingsHandler;
import org.gluu.casa.service.settings.IPluginSettingsHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.Pair;

public class StrongAuthSettingsService {
    private Logger logger;
    private IPersistenceService persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);
    private ObjectMapper mapper = new ObjectMapper();
    private IPluginSettingsHandler<Configuration> settingsHandler;
    private static StrongAuthSettingsService instance;

    private StrongAuthSettingsService(String pluginId) throws Exception {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.settingsHandler = ((IPluginSettingsHandlerFactory)Utils.managedBean(IPluginSettingsHandlerFactory.class)).getHandler(pluginId, Configuration.class);
    }

    public static StrongAuthSettingsService instance() {
        return instance;
    }

    public IPluginSettingsHandler<Configuration> getSettingsHandler() {
        return this.settingsHandler;
    }

    public static StrongAuthSettingsService instance(String pluginId) throws Exception {
        if (instance == null && pluginId != null) {
            instance = new StrongAuthSettingsService(pluginId);
        }
        return instance;
    }

    public Pair<Set<String>, List<TrustedDevice>> get2FAPolicyData(String userId) {
        HashSet list = new HashSet();
        List trustedDevices = new ArrayList();
        try {
            String trustedDevicesInfo;
            PersonPreferences person = this.personPreferencesInstance(userId);
            String policy = person.getStrongAuthPolicy();
            if (Utils.isNotEmpty((String)policy)) {
                Stream.of(policy.split(",\\s*")).forEach(str -> {
                    try {
                        list.add(EnforcementPolicy.valueOf(str.toUpperCase()).toString());
                    }
                    catch (Exception e) {
                        this.logger.error("The policy '{}' is not recognized", str);
                    }
                });
            }
            if (Utils.isNotEmpty((String)person.getTrustedDevices()) && Utils.isNotEmpty((String)(trustedDevicesInfo = Utils.stringEncrypter().decrypt(person.getTrustedDevices())))) {
                trustedDevices = (List)this.mapper.readValue(trustedDevicesInfo, (TypeReference)new TypeReference<List<TrustedDevice>>(){});
                trustedDevices.forEach(TrustedDevice::sortOriginsDescending);
                TrustedDeviceComparator comparator = new TrustedDeviceComparator(true);
                trustedDevices.sort((first, second) -> comparator.compare((TrustedDevice)second, (TrustedDevice)first));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return new Pair(list, trustedDevices);
    }

    public boolean update2FAPolicies(String userId, Set<String> policies) {
        boolean updated = false;
        String str = policies.stream().map(String::toLowerCase).reduce("", (partial, next) -> partial + ", " + next);
        try {
            PersonPreferences person = this.personPreferencesInstance(userId);
            person.setStrongAuthPolicy(str.substring(2));
            updated = this.persistenceService.modify((Object)person);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return updated;
    }

    public boolean deleteTrustedDevice(String userId, List<TrustedDevice> devices, int index) {
        boolean updated = false;
        ArrayList<TrustedDevice> copyOfDevices = new ArrayList<TrustedDevice>(devices);
        try {
            copyOfDevices.remove(index);
            String updatedJson = Utils.stringEncrypter().encrypt(this.mapper.writeValueAsString(copyOfDevices));
            PersonPreferences person = this.personPreferencesInstance(userId);
            person.setTrustedDevices(updatedJson);
            if (this.persistenceService.modify((Object)person)) {
                devices.remove(index);
                updated = true;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return updated;
    }

    private PersonPreferences personPreferencesInstance(String id) {
        return (PersonPreferences)this.persistenceService.get(PersonPreferences.class, this.persistenceService.getPersonDn(id));
    }
}

