/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.strongauthn.vm;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gluu.casa.core.pojo.User;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.strongauthn.conf.Configuration;
import org.gluu.casa.plugins.strongauthn.conf.EnforcementPolicy;
import org.gluu.casa.plugins.strongauthn.model.TrustedDevice;
import org.gluu.casa.plugins.strongauthn.service.StrongAuthSettingsService;
import org.gluu.casa.service.ISessionContext;
import org.gluu.casa.ui.UIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.Pair;
import org.zkoss.zul.Checkbox;

public class PolicyViewModel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean uiHasPreferredMethod;
    private boolean uiAllowedToSetPolicy;
    private Set<String> enforcementPolicies;
    private Set<String> enforcementPoliciesCopy;
    private List<TrustedDevice> trustedDevices;
    private StrongAuthSettingsService sass;
    private User user;
    private ISessionContext sessionContext;

    public boolean isUiHasPreferredMethod() {
        return this.uiHasPreferredMethod;
    }

    public boolean isUiAllowedToSetPolicy() {
        return this.uiAllowedToSetPolicy;
    }

    public Set<String> getEnforcementPolicies() {
        return this.enforcementPolicies;
    }

    public List<TrustedDevice> getTrustedDevices() {
        return this.trustedDevices;
    }

    @Init
    public void init() {
        this.logger.debug("Initializing ViewModel");
        this.sass = StrongAuthSettingsService.instance();
        Configuration settings = (Configuration)this.sass.getSettingsHandler().getSettings();
        this.user = ((ISessionContext)Utils.managedBean(ISessionContext.class)).getLoggedUser();
        this.uiHasPreferredMethod = this.user.getPreferredMethod() != null;
        this.uiAllowedToSetPolicy = settings.getEnforcement2FA().contains((Object)EnforcementPolicy.CUSTOM);
        this.logger.trace("User has a preferred method: {}", (Object)this.uiHasPreferredMethod);
        this.logger.trace("Users are allowed to set their own policy: {}", (Object)this.uiAllowedToSetPolicy);
        Pair<Set<String>, List<TrustedDevice>> police = this.sass.get2FAPolicyData(this.user.getId());
        this.enforcementPolicies = (Set)police.getX();
        this.trustedDevices = (List)police.getY();
        if (this.enforcementPolicies.isEmpty()) {
            this.resetToDefaultPolicy();
        }
        this.enforcementPoliciesCopy = new HashSet<String>(this.enforcementPolicies);
    }

    @NotifyChange(value={"enforcementPolicies"})
    @Command
    public void checkPolicy(@BindingParam(value="target") Checkbox box) {
        String policy = box.getId();
        if (box.isChecked()) {
            this.enforcementPolicies.add(policy);
        } else {
            this.enforcementPolicies.remove(policy);
        }
        if (this.enforcementPolicies.contains(EnforcementPolicy.EVERY_LOGIN.toString())) {
            this.resetToDefaultPolicy();
        }
        this.logger.debug("Enforcement policies are: {}", (Object)this.enforcementPolicies.toString());
    }

    @Command
    public void updatePolicy() {
        this.logger.trace("Updating user's policies");
        if (this.sass.update2FAPolicies(this.user.getId(), this.enforcementPolicies)) {
            this.enforcementPoliciesCopy = new HashSet<String>(this.enforcementPolicies);
            UIUtils.showMessageUI((boolean)true);
        } else {
            UIUtils.showMessageUI((boolean)false);
        }
    }

    @NotifyChange(value={"trustedDevices"})
    @Command
    public void deleteDevice(@BindingParam(value="idx") int index) {
        this.logger.trace("Deleting user device");
        UIUtils.showMessageUI((boolean)this.sass.deleteTrustedDevice(this.user.getId(), this.trustedDevices, index));
    }

    @NotifyChange(value={"enforcementPolicies"})
    @Command
    public void cancel() {
        this.enforcementPolicies = new HashSet<String>(this.enforcementPoliciesCopy);
    }

    private void resetToDefaultPolicy() {
        this.enforcementPolicies = new HashSet<String>(Collections.singleton(EnforcementPolicy.EVERY_LOGIN.toString()));
    }
}

