/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.duo;

import com.duosecurity.client.Http;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.gluu.casa.core.pojo.User;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.duo.model.DuoCredential;
import org.gluu.casa.plugins.duo.model.DuoResponse;
import org.gluu.casa.plugins.duo.model.PersonDuo;
import org.gluu.casa.plugins.duo.model.Response;
import org.gluu.casa.service.IPersistenceService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuoService {
    private static DuoService SINGLE_INSTANCE = null;
    public static Map<String, String> properties;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static String ACR;
    public static final String UserAgentString = "Duo API Java/0.3.0";
    private static ObjectMapper mapper;
    private IPersistenceService persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);

    private DuoService() {
        this.reloadConfiguration();
        mapper = new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DuoService getInstance() {
        if (SINGLE_INSTANCE != null) return SINGLE_INSTANCE;
        Class<DuoService> clazz = DuoService.class;
        synchronized (DuoService.class) {
            SINGLE_INSTANCE = new DuoService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return SINGLE_INSTANCE;
        }
    }

    public void reloadConfiguration() {
        ObjectMapper mapper = new ObjectMapper();
        properties = this.persistenceService.getCustScriptConfigProperties(ACR);
        if (properties == null) {
            this.logger.warn("Config. properties for custom script '{}' could not be read. Features related to {} will not be accessible", (Object)ACR, (Object)ACR.toUpperCase());
        } else {
            try {
                String duo_creds_file = properties.get("duo_creds_file");
                if (Utils.isNotEmpty((String)duo_creds_file)) {
                    String contents = new String(Files.readAllBytes(Paths.get(duo_creds_file, new String[0])), StandardCharsets.UTF_8);
                    properties.put("ikey", mapper.readTree(contents).get("ikey").textValue());
                    properties.put("skey", mapper.readTree(contents).get("skey").textValue());
                    properties.put("akey", mapper.readTree(contents).get("akey").textValue());
                    properties.put("admin_api_ikey", mapper.readTree(contents).get("admin_api_ikey").textValue());
                    properties.put("admin_api_skey", mapper.readTree(contents).get("admin_api_skey").textValue());
                } else {
                    this.logger.error("Property 'duo_creds_file' not found");
                }
                this.logger.info("Duo settings found were: {}", (Object)mapper.writeValueAsString(properties));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getScriptPropertyValue(String value) {
        return properties.get(value);
    }

    public int getDeviceTotal(User user) {
        return this.getDuoCredentials(user) == null ? 0 : 1;
    }

    public DuoCredential getDuoCredentials(User user) {
        DuoCredential device;
        block5: {
            device = null;
            try {
                String duoUserId;
                PersonDuo person = (PersonDuo)((Object)this.persistenceService.get(PersonDuo.class, this.persistenceService.getPersonDn(user.getId())));
                if (person == null) break block5;
                String json = person.getDuoDevices();
                DuoCredential duoCredential = device = Utils.isEmpty((String)json) ? null : (DuoCredential)mapper.readValue(json, (TypeReference)new TypeReference<DuoCredential>(){});
                if (device != null || (duoUserId = DuoService.getInstance().getUserId(user.getUserName())) == null) break block5;
                try {
                    boolean write = DuoService.getInstance().writeToPersistence(duoUserId, user.getId());
                    if (write) {
                        device = new DuoCredential();
                        device.setDuoUserId(duoUserId);
                        device.setNickName("DUO credential");
                        device.setAddedOn(System.currentTimeMillis());
                    }
                }
                catch (JsonProcessingException e) {
                    this.logger.error("Failed to initialize " + e.getMessage());
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return device;
    }

    public boolean writeToPersistence(String duoUserId, String inum) throws JsonProcessingException {
        DuoCredential cred = new DuoCredential();
        cred.setNickName("DUO credentials");
        cred.setAddedOn(System.currentTimeMillis());
        cred.setDuoUserId(duoUserId);
        String json = mapper.writeValueAsString((Object)cred);
        PersonDuo person = (PersonDuo)((Object)this.persistenceService.get(PersonDuo.class, this.persistenceService.getPersonDn(inum)));
        person.setDuoDevices(json);
        boolean success = this.persistenceService.modify((Object)person);
        return success;
    }

    public boolean removeFromPersistence(String userId) throws JsonProcessingException {
        PersonDuo person = (PersonDuo)((Object)this.persistenceService.get(PersonDuo.class, this.persistenceService.getPersonDn(userId)));
        person.setDuoDevices(null);
        return this.persistenceService.modify((Object)person);
    }

    public String getUserId(String username) {
        try {
            Http request = new Http("GET", this.getScriptPropertyValue("duo_host"), "/admin/v1/users");
            String limit = "10";
            request.addParam("username", username);
            request.signRequest(this.getScriptPropertyValue("admin_api_ikey"), this.getScriptPropertyValue("admin_api_skey"));
            JSONObject result = (JSONObject)request.executeJSONRequest();
            JSONArray response = result.getJSONArray("response");
            if (response.length() == 1) {
                JSONObject user = response.getJSONObject(0);
                this.logger.info("Fetched user: " + user.get("user_id"));
                return user.get("user_id").toString();
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
        return null;
    }

    public boolean deleteDUOCredential(String userName) throws Exception {
        String duoUserId = this.getUserId(userName);
        this.logger.info("duoUserId" + duoUserId);
        try {
            Http request = new Http("DELETE", this.getScriptPropertyValue("duo_host"), "/admin/v1/users/" + duoUserId);
            request.signRequest(this.getScriptPropertyValue("admin_api_ikey"), this.getScriptPropertyValue("admin_api_skey"));
            String responseRaw = request.executeRequestRaw();
            String stat = mapper.readTree(responseRaw).get("stat").textValue();
            this.logger.info("delete result + stat -" + responseRaw + ":" + stat);
            if ("OK".equals(stat)) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("error in the delete request" + e.getMessage());
            return false;
        }
        return false;
    }

    public Response getUser(String username) {
        try {
            Http request = new Http("GET", this.getScriptPropertyValue("duo_host"), "/admin/v1/users");
            String limit = "10";
            request.addParam("username", username);
            request.signRequest(this.getScriptPropertyValue("admin_api_ikey"), this.getScriptPropertyValue("admin_api_skey"));
            JSONObject result = (JSONObject)request.executeJSONRequest();
            DuoResponse duoResponse = (DuoResponse)mapper.readValue(result.toString(), DuoResponse.class);
            if (duoResponse != null && "OK".equals(duoResponse.getStat()) && duoResponse.getResponse().size() == 1) {
                this.logger.info(duoResponse.toString());
                return duoResponse.getResponse().get(0);
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
        return null;
    }

    static {
        ACR = "duo";
    }
}

