/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.duo.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.gluu.casa.credential.BasicCredential;
import org.gluu.casa.extension.AuthnMethod;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.duo.DuoService;
import org.gluu.casa.plugins.duo.model.DuoCredential;
import org.gluu.casa.service.ISessionContext;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class DuoExtension
implements AuthnMethod {
    private DuoService duoService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ISessionContext sessionContext = (ISessionContext)Utils.managedBean(ISessionContext.class);

    public DuoExtension() {
        this.duoService = DuoService.getInstance();
    }

    public String getUINameKey() {
        return "duo_label";
    }

    public String getAcr() {
        DuoService.getInstance();
        return DuoService.ACR;
    }

    public String getPanelTitleKey() {
        return "duo_title";
    }

    public String getPanelTextKey() {
        return "duo_text";
    }

    public String getPanelButtonKey() {
        return "duo_manage";
    }

    public String getPanelBottomTextKey() {
        return "duo_download";
    }

    public String getPageUrl() {
        return "user/cred_details.zul";
    }

    public List<BasicCredential> getEnrolledCreds(String id) {
        ArrayList<BasicCredential> creds = new ArrayList<BasicCredential>();
        try {
            DuoCredential device = DuoService.getInstance().getDuoCredentials(this.sessionContext.getLoggedUser());
            if (device != null) {
                creds.add(new BasicCredential(device.getNickName(), device.getAddedOn()));
            }
            return creds;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public int getTotalUserCreds(String id) {
        return DuoService.getInstance().getDeviceTotal(this.sessionContext.getLoggedUser());
    }

    public void reloadConfiguration() {
        DuoService.getInstance().reloadConfiguration();
    }

    public boolean mayBe2faActivationRequisite() {
        return Boolean.parseBoolean(Optional.ofNullable(DuoService.getInstance().getScriptPropertyValue("2fa_requisite")).orElse("false"));
    }
}

