/*
 * Decompiled with CFR 0.152.
 */
package com.duosecurity.client;

import com.duosecurity.client.Base64;
import com.duosecurity.client.Util;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class Http {
    public static final int BACKOFF_FACTOR = 2;
    public static final int INITIAL_BACKOFF_MS = 1000;
    public static final int MAX_BACKOFF_MS = 32000;
    public static final int DEFAULT_TIMEOUT_SECS = 60;
    private static final int RATE_LIMIT_ERROR_CODE = 429;
    public static final String HmacSHA1 = "HmacSHA1";
    public static final String HmacSHA512 = "HmacSHA512";
    public static final String UserAgentString = "Duo API Java/0.3.0";
    private String method;
    private String host;
    private String uri;
    private String signingAlgorithm;
    private Headers.Builder headers;
    Map<String, String> params = new HashMap<String, String>();
    private Random random = new Random();
    private OkHttpClient httpClient;
    public static SimpleDateFormat RFC_2822_DATE_FORMAT = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
    public static MediaType FORM_ENCODED = MediaType.parse("application/x-www-form-urlencoded");

    public Http(String inMethod, String inHost, String inUri) {
        this(inMethod, inHost, inUri, 60);
    }

    public Http(String inMethod, String inHost, String inUri, int timeout) {
        this.method = inMethod.toUpperCase();
        this.host = inHost;
        this.uri = inUri;
        this.signingAlgorithm = HmacSHA1;
        this.headers = new Headers.Builder();
        this.headers.add("Host", this.host);
        this.headers.add("user-agent", UserAgentString);
        this.httpClient = new OkHttpClient();
        this.httpClient.setConnectTimeout(timeout, TimeUnit.SECONDS);
        this.httpClient.setWriteTimeout(timeout, TimeUnit.SECONDS);
        this.httpClient.setReadTimeout(timeout, TimeUnit.SECONDS);
    }

    public Object executeJSONRequest() throws Exception {
        JSONObject result = new JSONObject(this.executeRequestRaw());
        if (!result.getString("stat").equals("OK")) {
            throw new Exception("Duo error code (" + result.getInt("code") + "): " + result.getString("message"));
        }
        return result;
    }

    public String executeRequestRaw() throws Exception {
        Response response = this.executeHttpRequest();
        return response.body().string();
    }

    public Response executeHttpRequest() throws Exception {
        String url = "https://" + this.host + this.uri;
        String queryString = this.createQueryString();
        Request.Builder builder = new Request.Builder();
        if (this.method.equals("POST")) {
            builder.post(RequestBody.create(FORM_ENCODED, queryString));
        } else if (this.method.equals("PUT")) {
            builder.put(RequestBody.create(FORM_ENCODED, queryString));
        } else if (this.method.equals("GET")) {
            if (queryString.length() > 0) {
                url = url + "?" + queryString;
            }
            builder.get();
        } else if (this.method.equals("DELETE")) {
            if (queryString.length() > 0) {
                url = url + "?" + queryString;
            }
            builder.delete();
        } else {
            throw new UnsupportedOperationException("Unsupported method: " + this.method);
        }
        Request request = builder.headers(this.headers.build()).url(url).build();
        return this.executeRequest(request);
    }

    public Object executeRequest() throws Exception {
        JSONObject result = (JSONObject)this.executeJSONRequest();
        return result.get("response");
    }

    private Response executeRequest(Request request) throws Exception {
        long backoffMs = 1000L;
        Response response;
        while ((response = this.httpClient.newCall(request).execute()).code() == 429 && backoffMs <= 32000L) {
            this.sleep(backoffMs + (long)this.random.nextInt(1000));
            backoffMs *= 2L;
        }
        return response;
    }

    protected void sleep(long ms) throws Exception {
        Thread.sleep(ms);
    }

    public void signRequest(String ikey, String skey) throws UnsupportedEncodingException {
        this.signRequest(ikey, skey, 2);
    }

    public void signRequest(String ikey, String skey, int sigVersion) throws UnsupportedEncodingException {
        String date = this.formatDate(new Date());
        String canon = this.canonRequest(date, sigVersion);
        String sig = this.signHMAC(skey, canon);
        String auth = ikey + ":" + sig;
        String header = "Basic " + Base64.encodeBytes(auth.getBytes());
        this.addHeader("Authorization", header);
        if (sigVersion == 2) {
            this.addHeader("Date", date);
        }
    }

    protected String signHMAC(String skey, String msg) {
        try {
            byte[] sigBytes = Util.hmac(this.signingAlgorithm, skey.getBytes(), msg.getBytes());
            String sig = Util.bytes_to_hex(sigBytes);
            return sig;
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = RFC_2822_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return RFC_2822_DATE_FORMAT.format(date);
        }
    }

    public void addHeader(String name, String value) {
        this.headers.add(name, value);
    }

    public void addParam(String name, String value) {
        this.params.put(name, value);
    }

    public void setProxy(String host, int port) {
        this.httpClient.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)));
    }

    public void setSigningAlgorithm(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm != HmacSHA1 && algorithm != HmacSHA512) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        this.signingAlgorithm = algorithm;
    }

    protected String canonRequest(String date, int sigVersion) throws UnsupportedEncodingException {
        String canon = "";
        if (sigVersion == 2) {
            canon = canon + date + "\n";
        }
        canon = canon + this.method.toUpperCase() + "\n";
        canon = canon + this.host.toLowerCase() + "\n";
        canon = canon + this.uri + "\n";
        canon = canon + this.createQueryString();
        return canon;
    }

    private String createQueryString() throws UnsupportedEncodingException {
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.params.keySet()) {
            keys.add(key);
        }
        Collections.sort(keys);
        for (String key : keys) {
            String name = URLEncoder.encode(key, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            String value = URLEncoder.encode(this.params.get(key), "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            args.add(name + "=" + value);
        }
        return Util.join(args.toArray(), "&");
    }
}

