/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.duo.vm;

import com.duosecurity.duoweb.DuoWeb;
import com.duosecurity.duoweb.DuoWebException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.duo.DuoService;
import org.gluu.casa.plugins.duo.model.DuoCredential;
import org.gluu.casa.plugins.duo.model.Response;
import org.gluu.casa.service.ISessionContext;
import org.gluu.casa.service.SndFactorAuthenticationUtils;
import org.gluu.casa.ui.UIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.Pair;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Messagebox;

public class DuoViewModel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @WireVariable
    private ISessionContext sessionContext;
    private DuoCredential device;
    private Response duoCreds;
    private DuoCredential newDevice;
    private SndFactorAuthenticationUtils sndFactorUtils;
    private String host;
    private String sigRequest;
    private String postAction;

    public Response getDuoCreds() {
        return this.duoCreds;
    }

    public void setDuoCreds(Response duoCreds) {
        this.duoCreds = duoCreds;
    }

    public DuoCredential getNewDevice() {
        return this.newDevice;
    }

    public void setNewDevice(DuoCredential newDevice) {
        this.newDevice = newDevice;
    }

    public DuoCredential getDevice() {
        return this.device;
    }

    public void setDevice(DuoCredential device) {
        this.device = device;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getSigRequest() {
        return this.sigRequest;
    }

    public void setSigRequest(String sigRequest) {
        this.sigRequest = sigRequest;
    }

    public String getPostAction() {
        return this.postAction;
    }

    public void setPostAction(String postAction) {
        this.postAction = postAction;
    }

    @Init
    public void init() {
        this.sndFactorUtils = (SndFactorAuthenticationUtils)Utils.managedBean(SndFactorAuthenticationUtils.class);
        this.sessionContext = (ISessionContext)Utils.managedBean(ISessionContext.class);
        this.host = DuoService.getInstance().getScriptPropertyValue("duo_host");
        String sigResponse = Executions.getCurrent().getParameter("sig_response");
        if (sigResponse != null) {
            try {
                String authenticated_username = DuoWeb.verifyResponse(DuoService.getInstance().getScriptPropertyValue("ikey"), DuoService.getInstance().getScriptPropertyValue("skey"), DuoService.getInstance().getScriptPropertyValue("akey"), sigResponse);
                Clients.response((AuResponse)new AuInvoke("showIframe", new Object[0]));
            }
            catch (InvalidKeyException e) {
                this.logger.error(e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error(e.getMessage());
            }
            catch (DuoWebException e) {
                this.logger.error(e.getMessage());
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
            Session session = Sessions.getCurrent();
            this.sigRequest = session.getAttribute("sigRequest").toString();
        } else {
            this.device = DuoService.getInstance().getDuoCredentials(this.sessionContext.getLoggedUser());
            if (this.device == null) {
                String duoUserId = DuoService.getInstance().getUserId(this.sessionContext.getLoggedUser().getUserName());
                if (duoUserId != null) {
                    try {
                        boolean write = DuoService.getInstance().writeToPersistence(duoUserId, this.sessionContext.getLoggedUser().getId());
                        if (write) {
                            this.device = DuoService.getInstance().getDuoCredentials(this.sessionContext.getLoggedUser());
                        }
                    }
                    catch (JsonProcessingException e) {
                        this.logger.error("Failed to initialize " + e.getMessage());
                    }
                } else {
                    Clients.response((AuResponse)new AuInvoke("showIframe", new Object[0]));
                }
            }
            if (this.device != null) {
                this.duoCreds = DuoService.getInstance().getUser(this.sessionContext.getLoggedUser().getUserName());
            }
            this.sigRequest = DuoWeb.signRequest(DuoService.getInstance().getScriptPropertyValue("ikey"), DuoService.getInstance().getScriptPropertyValue("skey"), DuoService.getInstance().getScriptPropertyValue("akey"), this.sessionContext.getLoggedUser().getUserName());
            Session session = Sessions.getCurrent();
            session.setAttribute("sigRequest", (Object)this.sigRequest);
        }
        this.logger.debug("init invoked");
    }

    @AfterCompose
    public void afterCompose(@ContextParam(value=ContextType.VIEW) Component view) {
        this.logger.debug("afterCompose invoked");
        Selectors.wireEventListeners((Component)view, (Object)this);
    }

    public boolean delete() {
        this.logger.debug("delete invoked");
        String resetMessages = (String)this.sndFactorUtils.removalConflict(DuoService.ACR, 1, this.sessionContext.getLoggedUser()).getY();
        boolean reset = resetMessages != null;
        Pair<String, String> delMessages = this.getDeleteMessages(resetMessages);
        Messagebox.show((String)((String)delMessages.getY()), (String)((String)delMessages.getX()), (int)48, (String)"z-messagebox-icon z-messagebox-exclamation", event -> {
            if ("onYes".equals(event.getName())) {
                boolean result = false;
                try {
                    result = DuoService.getInstance().deleteDUOCredential(this.sessionContext.getLoggedUser().getUserName());
                    if (result) {
                        DuoService.getInstance().removeFromPersistence(this.sessionContext.getLoggedUser().getId());
                        BindUtils.postNotifyChange((Object)this, (String)"device");
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error during delete - " + e.getMessage());
                }
                UIUtils.showMessageUI((boolean)result);
                Executions.sendRedirect(null);
            }
        });
        return false;
    }

    Pair<String, String> getDeleteMessages(String extraMessage) {
        StringBuilder text = new StringBuilder();
        if (extraMessage != null) {
            text.append(extraMessage).append("\n\n");
        }
        text.append(Labels.getLabel((String)"duo_del_confirm", (Object[])new String[]{Labels.getLabel((String)"duo_credentials")}));
        if (extraMessage != null) {
            text.append("\n");
        }
        return new Pair((Object)Labels.getLabel((String)"duo_del_title"), (Object)text.toString());
    }

    public boolean edit() {
        this.logger.info("edit invoked");
        return true;
    }
}

