/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gluu.oxtrust.model.scim2.AttributeDefinition;
import org.gluu.oxtrust.model.scim2.annotations.Attribute;
import org.gluu.oxtrust.model.scim2.util.IntrospectUtil;

class traversalClass {
    private Logger log = LogManager.getLogger(this.getClass());
    String error;
    private Class base;

    traversalClass(Class baseClass) {
        this.base = baseClass;
    }

    private String getNewPrefix(String prefix, String key) {
        return prefix + (prefix.length() == 0 ? "" : ".") + key;
    }

    private Map<String, Object> smallerMap(String prefix, Map<String, Object> source, Object destination, boolean replacing) {
        HashMap<String, Object> smallMap = destination == null ? new HashMap() : IntrospectUtil.strObjMap(destination);
        this.traverse(prefix, source, smallMap, replacing);
        return smallMap.isEmpty() ? null : smallMap;
    }

    void traverse(String prefix, Map<String, Object> source, Map<String, Object> destination, boolean replacing) {
        for (String key : source.keySet()) {
            Attribute attrAnnot;
            Map<String, Object> value = source.get(key);
            Object destValue = destination.get(key);
            if (value == null || this.error != null || (attrAnnot = IntrospectUtil.getFieldAnnotation(this.getNewPrefix(prefix, key), this.base, Attribute.class)) == null || attrAnnot.mutability().equals((Object)AttributeDefinition.Mutability.READ_ONLY)) continue;
            if (value instanceof Map) {
                value = this.smallerMap(this.getNewPrefix(prefix, key), IntrospectUtil.strObjMap(value), destValue, replacing);
            } else if (attrAnnot.mutability().equals((Object)AttributeDefinition.Mutability.IMMUTABLE) && destValue != null && !((Object)value).equals(destValue)) {
                this.error = "Invalid value passed for immutable attribute " + key;
                value = null;
            }
            if (value == null) continue;
            if (IntrospectUtil.isCollection(value.getClass())) {
                Collection col = (Collection)((Object)value);
                int size = col.size();
                if (!replacing && destValue != null) {
                    if (IntrospectUtil.isCollection(destValue.getClass())) {
                        col.addAll((Collection)destValue);
                    } else {
                        this.log.warn("Value {} was expected to be a collection", destValue);
                    }
                }
                value = col.isEmpty() ? null : this.adjustPrimarySubAttributes(col, size);
            }
            destination.put(key, value);
        }
    }

    void traverseDelete(Map<String, Object> source, String path) {
        block6: {
            int i = path.indexOf(".");
            Object value = null;
            if (i == -1) {
                source.remove(path);
            } else {
                String key = path.substring(0, i);
                value = source.get(key);
                path = path.substring(i + 1);
            }
            if (value != null) {
                try {
                    this.traverseDelete(IntrospectUtil.strObjMap(value), path);
                }
                catch (Exception e) {
                    if (!IntrospectUtil.isCollection(value.getClass())) break block6;
                    Collection col = (Collection)value;
                    for (Object item : col) {
                        if (!(item instanceof Map)) continue;
                        this.traverseDelete(IntrospectUtil.strObjMap(item), path);
                    }
                }
            }
        }
    }

    private Collection adjustPrimarySubAttributes(Collection input, int nFreshEntries) {
        Object primaryObj;
        Map<String, Object> map;
        Object item;
        int i;
        Object[] array = input.toArray();
        for (i = 0; i < nFreshEntries; ++i) {
            item = array[i];
            if (item != null && item instanceof Map) {
                map = IntrospectUtil.strObjMap(item);
                primaryObj = map.get("primary");
                if (primaryObj == null || !primaryObj.toString().equals("true")) continue;
                break;
            }
            i = array.length;
        }
        ++i;
        while (i < array.length) {
            item = array[i];
            if (item != null && item instanceof Map && (primaryObj = (map = IntrospectUtil.strObjMap(item)).get("primary")) != null && primaryObj.toString().equals("true")) {
                map.put("primary", false);
                this.log.info("Setting primary = false for item whose associated value is {}", map.get("value"));
            }
            ++i;
        }
        return Arrays.asList(array);
    }
}

