/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InvalidAttributeValueException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gluu.oxtrust.model.scim2.AttributeDefinition;
import org.gluu.oxtrust.model.scim2.BaseScimResource;
import org.gluu.oxtrust.model.scim2.annotations.Attribute;
import org.gluu.oxtrust.model.scim2.annotations.Schema;
import org.gluu.oxtrust.model.scim2.extensions.Extension;
import org.gluu.oxtrust.model.scim2.extensions.ExtensionField;
import org.gluu.oxtrust.model.scim2.util.IntrospectUtil;
import org.gluu.oxtrust.model.scim2.util.traversalClass;

public class ScimResourceUtil {
    private static Logger log = LogManager.getLogger(ScimResourceUtil.class);
    private static ObjectMapper mapper = new ObjectMapper();

    private ScimResourceUtil() {
    }

    private static void attachExtensionInfo(Map<String, Object> source, Map<String, Object> destination, List<Extension> extensions, boolean replacing) {
        log.debug("attachExtensionInfo");
        for (Extension extension : extensions) {
            String urn = extension.getUrn();
            Object extendedAttrsObj = source.get(urn);
            if (extendedAttrsObj == null) continue;
            Map<String, Object> extendedAttrs = IntrospectUtil.strObjMap(extendedAttrsObj);
            Map<String, ExtensionField> fields = extension.getFields();
            Map<Object, Object> destMap = destination.get(urn) == null ? new HashMap() : IntrospectUtil.strObjMap(destination.get(urn));
            for (String attr : fields.keySet()) {
                Object value = extendedAttrs.get(attr);
                if (value == null) continue;
                if (IntrospectUtil.isCollection(value.getClass())) {
                    Object destValue;
                    Collection col = (Collection)value;
                    if (!replacing && (destValue = destMap.get(attr)) != null) {
                        if (!IntrospectUtil.isCollection(destValue.getClass())) {
                            log.warn("Value {} was expected to be a collection", destValue);
                        } else {
                            col.addAll((Collection)destMap.get(attr));
                        }
                    }
                    value = col.size() == 0 ? null : col;
                }
                destMap.put(attr, value);
            }
            destination.put(urn, destMap);
        }
    }

    private static void deleteCustomAttribute(Map<String, Object> source, String path, List<Extension> extensions) {
        int i = path.lastIndexOf(".");
        if (i == -1) {
            log.warn("Path not recognized {}", (Object)path);
        } else {
            String key = path.substring(i + 1);
            path = path.substring(0, i);
            for (Extension ext : extensions) {
                Map<String, Object> submap;
                if (!ext.getUrn().equals(path) || (submap = IntrospectUtil.strObjMap(source.get(path))) == null) continue;
                submap.put(key, null);
            }
        }
    }

    private static BaseScimResource transferToResource(BaseScimResource origin, BaseScimResource destination, List<Extension> extensions, boolean replacing) throws InvalidAttributeValueException {
        log.debug("transferToResource. Processing {} operation", (Object)(replacing ? "replace" : "add"));
        Map fromMap = (Map)mapper.convertValue((Object)origin, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map toMap = (Map)mapper.convertValue((Object)destination, (TypeReference)new TypeReference<Map<String, Object>>(){});
        log.debug("transferToResource. Recursive traversal of resource is taking place");
        traversalClass tclass = new traversalClass(origin.getClass());
        tclass.traverse("", fromMap, toMap, replacing);
        ScimResourceUtil.attachExtensionInfo(fromMap, toMap, extensions, replacing);
        if (tclass.error == null) {
            return (BaseScimResource)mapper.convertValue((Object)toMap, origin.getClass());
        }
        throw new InvalidAttributeValueException(tclass.error);
    }

    public static BaseScimResource transferToResourceReplace(BaseScimResource replacementDataSource, BaseScimResource originalDataSource, List<Extension> extensions) throws InvalidAttributeValueException {
        return ScimResourceUtil.transferToResource(replacementDataSource, originalDataSource, extensions, true);
    }

    public static BaseScimResource transferToResourceAdd(BaseScimResource replacementDataSource, BaseScimResource originalDataSource, List<Extension> extensions) throws InvalidAttributeValueException {
        return ScimResourceUtil.transferToResource(replacementDataSource, originalDataSource, extensions, false);
    }

    public static BaseScimResource deleteFromResource(BaseScimResource origin, String path, List<Extension> extensions) throws InvalidAttributeValueException {
        Attribute attrAnnot;
        Field f = IntrospectUtil.findFieldFromPath(origin.getClass(), path);
        if (f != null && (attrAnnot = f.getAnnotation(Attribute.class)) != null && (attrAnnot.mutability().equals((Object)AttributeDefinition.Mutability.READ_ONLY) || attrAnnot.isRequired())) {
            throw new InvalidAttributeValueException("Cannot remove read-only or required attribute " + path);
        }
        Map map = (Map)mapper.convertValue((Object)origin, (TypeReference)new TypeReference<Map<String, Object>>(){});
        traversalClass tclass = new traversalClass(origin.getClass());
        if (f == null) {
            ScimResourceUtil.deleteCustomAttribute(map, path, extensions);
        } else {
            tclass.traverseDelete(map, path);
        }
        return (BaseScimResource)mapper.convertValue((Object)map, origin.getClass());
    }

    public static Schema getSchemaAnnotation(Class<? extends BaseScimResource> cls) {
        return cls.getAnnotation(Schema.class);
    }

    public static String getDefaultSchemaUrn(Class<? extends BaseScimResource> cls) {
        Schema schema = ScimResourceUtil.getSchemaAnnotation(cls);
        return schema == null ? null : schema.id();
    }

    public static String stripDefaultSchema(Class<? extends BaseScimResource> cls, String attribute) {
        String val = attribute;
        String defaultSchema = ScimResourceUtil.getDefaultSchemaUrn(cls);
        if (StringUtils.isNotEmpty((String)attribute) && StringUtils.isNotEmpty((String)defaultSchema) && attribute.startsWith(defaultSchema + ":")) {
            val = attribute.substring(defaultSchema.length() + 1);
        }
        return val;
    }

    public static String getType(Class<? extends BaseScimResource> cls) {
        Schema annot = ScimResourceUtil.getSchemaAnnotation(cls);
        return annot == null ? null : annot.name();
    }

    public static String adjustNotationInPath(String path, String defaultUrn, List<String> schemas) {
        for (String urn : schemas) {
            if (!path.startsWith(urn + ":")) continue;
            if (urn.equals(defaultUrn)) {
                path = path.substring(urn.length() + 1);
                continue;
            }
            path = path.substring(0, urn.length()) + "." + path.substring(urn.length() + 1);
        }
        return path;
    }

    public static String[] splitPath(String path, List<String> urns) {
        String prefix = "";
        for (String urn : urns) {
            if (!path.startsWith(urn)) continue;
            prefix = urn;
            break;
        }
        if (prefix.length() > 0) {
            ArrayList<String> pieces = new ArrayList<String>();
            pieces.add(prefix);
            path = path.substring(prefix.length());
            if (path.length() > 0) {
                String subpath = path.substring(path.startsWith(".") ? 1 : 0);
                pieces.addAll(Arrays.asList(subpath.split("\\.")));
            }
            return pieces.toArray(new String[0]);
        }
        return path.split("\\.");
    }

    public static void adjustPrimarySubAttributes(BaseScimResource resource) {
        String fragment = ".primary";
        Class<?> cls = resource.getClass();
        ArrayList<String> parents = new ArrayList<String>();
        for (String path : IntrospectUtil.allAttrs.get(cls)) {
            if (!path.endsWith(fragment)) continue;
            parents.add(path.substring(0, path.length() - fragment.length()));
        }
        List<Map> niceList = Arrays.asList(IntrospectUtil.defaultCoreAttrs.get(cls), IntrospectUtil.neverCoreAttrs.get(cls), IntrospectUtil.alwaysCoreAttrs.get(cls));
        log.info("adjustPrimarySubAttributes. Revising \"primary\":true uniqueness constraints");
        block3: for (String path : parents) {
            for (Map niceMap : niceList) {
                try {
                    if (!niceMap.containsKey(path)) continue;
                    List list = IntrospectUtil.getAttributeValues(resource, (List)niceMap.get(path));
                    if (list.size() <= 0 || (list = (List)list.get(0)) == null || list.size() <= 1) continue block3;
                    Class<?> clz = list.get(0).getClass();
                    Method setter = IntrospectUtil.getSetter(fragment.substring(1), clz);
                    Method getter = IntrospectUtil.getGetter(fragment.substring(1), clz);
                    int trues = 0;
                    for (Object item : list) {
                        Object primaryVal = getter.invoke(item, new Object[0]);
                        if ((trues += primaryVal != null && primaryVal.toString().equals("true") ? 1 : 0) <= 1) continue;
                        setter.invoke(item, false);
                        log.info("adjustPrimarySubAttributes. Setting primary = false for an item (a previous one was already primary = true)");
                    }
                    continue block3;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static BaseScimResource clone(BaseScimResource object) {
        Map map = (Map)mapper.convertValue((Object)object, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return (BaseScimResource)mapper.convertValue((Object)map, object.getClass());
    }
}

