/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gluu.oxtrust.model.exception.SCIMException;
import org.gluu.oxtrust.model.scim2.BaseScimResource;
import org.gluu.oxtrust.model.scim2.Validations;
import org.gluu.oxtrust.model.scim2.annotations.Attribute;
import org.gluu.oxtrust.model.scim2.annotations.Validator;
import org.gluu.oxtrust.model.scim2.extensions.Extension;
import org.gluu.oxtrust.model.scim2.extensions.ExtensionField;
import org.gluu.oxtrust.model.scim2.util.IntrospectUtil;
import org.gluu.oxtrust.model.scim2.util.ScimResourceUtil;

public class ResourceValidator {
    private Logger log = LogManager.getLogger(this.getClass());
    private static final String REQUIRED_ATTR_NOTFOUND = "Required attribute %s not found";
    private static final String WRONG_SCHEMAS_ATTR = "Wrong value of schemas attribute";
    private static final String UNKNOWN_EXTENSION = "Extension %s not recognized";
    private static final String ATTR_NOT_RECOGNIZED = "Attribute %s not part of schema %s";
    private static final String ERROR_PARSING_EXTENDED = "Error parsing extended attributes";
    private static final String ATTR_VALIDATION_FAILED = "Unexpected value for attribute %s";
    private static final String WRONG_CARDINALITY = "Value passed has wrong cardinality";
    private BaseScimResource resource;
    private Class<? extends BaseScimResource> resourceClass;
    private List<Extension> extensions;

    public ResourceValidator(BaseScimResource resource, List<Extension> extensions) {
        this.resource = resource;
        this.resourceClass = resource.getClass();
        this.extensions = extensions;
    }

    public void validateRequiredAttributes(boolean laxRequiredness) throws SCIMException {
        Map<String, List<Method>> map = IntrospectUtil.requiredCoreAttrs.get(this.resourceClass);
        for (String attributePath : map.keySet()) {
            Method parentMethod;
            int len;
            boolean checkValues = !laxRequiredness;
            List<Method> methods = map.get(attributePath);
            if (laxRequiredness && (len = methods.size()) > 1 && IntrospectUtil.isCollection((parentMethod = methods.get(len - 2)).getReturnType())) {
                List<Object> items = IntrospectUtil.getAttributeValues(this.resource, methods.subList(0, len - 1));
                boolean bl = checkValues = !items.isEmpty();
            }
            if (!checkValues) continue;
            this.log.debug("Validating existence of required attribute '{}'", (Object)attributePath);
            for (Object val : IntrospectUtil.getAttributeValues(this.resource, methods)) {
                if (val != null) continue;
                this.log.error("Error getting value of required attribute '{}'", (Object)attributePath);
                throw new SCIMException(String.format(REQUIRED_ATTR_NOTFOUND, attributePath));
            }
        }
    }

    public void validateValidableAttributes() throws SCIMException {
        Map<String, List<Method>> map = IntrospectUtil.validableCoreAttrs.get(this.resourceClass);
        for (String attributePath : map.keySet()) {
            Field f = IntrospectUtil.findFieldFromPath(this.resourceClass, attributePath);
            Validations valToApply = f.getAnnotation(Validator.class).value();
            this.log.debug("Validating value(s) of attribute '{}'", (Object)attributePath);
            for (Object val : IntrospectUtil.getAttributeValues(this.resource, map.get(attributePath))) {
                if (val == null || Validations.apply(valToApply, val)) continue;
                this.log.error("Error validating attribute '{}', wrong value supplied: '{}'", (Object)attributePath, (Object)val.toString());
                throw new SCIMException(String.format(ATTR_VALIDATION_FAILED, attributePath));
            }
        }
    }

    public void validateCanonicalizedAttributes() throws SCIMException {
        Map<String, List<Method>> map = IntrospectUtil.canonicalCoreAttrs.get(this.resourceClass);
        for (String attributePath : map.keySet()) {
            Attribute attrAnnot = IntrospectUtil.getFieldAnnotation(attributePath, this.resourceClass, Attribute.class);
            List<String> canonicalVals = Arrays.asList(attrAnnot.canonicalValues());
            this.log.debug("Validating values of canonical attribute '{}'", (Object)attributePath);
            for (Object val : IntrospectUtil.getAttributeValues(this.resource, map.get(attributePath))) {
                if (canonicalVals.contains(val.toString())) continue;
                this.log.error("Error validating canonical attribute '{}', wrong value supplied: '{}'", (Object)attributePath, (Object)val.toString());
                throw new SCIMException(String.format(ATTR_VALIDATION_FAILED, attributePath));
            }
        }
    }

    public void validateSchemasAttribute() throws SCIMException {
        HashSet<String> schemaList = new HashSet<String>(this.resource.getSchemas());
        if (schemaList.isEmpty()) {
            throw new SCIMException(WRONG_SCHEMAS_ATTR);
        }
        HashSet<String> allSchemas = new HashSet<String>();
        allSchemas.add(ScimResourceUtil.getDefaultSchemaUrn(this.resourceClass));
        for (Extension ext : this.extensions) {
            allSchemas.add(ext.getUrn());
        }
        schemaList.removeAll(allSchemas);
        if (schemaList.size() > 0) {
            throw new SCIMException(WRONG_SCHEMAS_ATTR);
        }
    }

    private void validateDataTypeExtendedAttr(Extension extension, String attribute, Object value) throws SCIMException {
        ExtensionField field = extension.getFields().get(attribute);
        if (field == null) {
            throw new SCIMException(String.format(ATTR_NOT_RECOGNIZED, attribute, extension.getUrn()));
        }
        this.log.debug("validateDataTypeExtendedAttr. Checking attribute '{}' for type '{}' with value '{}'", (Object)attribute, (Object)field.getType().toString(), (Object)value.toString());
        if (ExtensionField.valueOf(field, value) == null) {
            throw new SCIMException(String.format(ATTR_VALIDATION_FAILED, attribute));
        }
    }

    public void validateExtendedAttributes() throws SCIMException {
        Map<String, Object> extendedAttributes = this.resource.getCustomAttributes();
        for (String schema : extendedAttributes.keySet()) {
            Extension extension = null;
            for (Extension ext : this.extensions) {
                if (!ext.getUrn().equals(schema)) continue;
                extension = ext;
                break;
            }
            if (extension != null) {
                this.log.debug("validateExtendedAttributes. Revising attributes under schema {}", (Object)schema);
                try {
                    Map<String, Object> attrsMap = IntrospectUtil.strObjMap(extendedAttributes.get(schema));
                    for (String attr : attrsMap.keySet()) {
                        Object value = attrsMap.get(attr);
                        if (value == null) continue;
                        Class<?> cls = value.getClass();
                        boolean isCollection = IntrospectUtil.isCollection(cls);
                        this.log.debug("validateExtendedAttributes. Got value(s) for attribute '{}'", (Object)attr);
                        if (isCollection == extension.getFields().get(attr).isMultiValued()) {
                            if (isCollection) {
                                for (Object elem : (Collection)value) {
                                    if (elem == null) continue;
                                    this.validateDataTypeExtendedAttr(extension, attr, elem);
                                }
                                continue;
                            }
                            this.validateDataTypeExtendedAttr(extension, attr, value);
                            continue;
                        }
                        throw new SCIMException(String.format(ATTR_VALIDATION_FAILED, attr) + "; " + WRONG_CARDINALITY);
                    }
                    continue;
                }
                catch (SCIMException se) {
                    this.log.error(se.getMessage(), (Throwable)se);
                    throw se;
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    throw new SCIMException(ERROR_PARSING_EXTENDED);
                }
            }
            throw new SCIMException(String.format(UNKNOWN_EXTENSION, schema));
        }
    }
}

