/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;

public enum Validations {
    EMAIL,
    PHONE,
    PHOTO,
    COUNTRY,
    LOCALE,
    TIMEZONE;

    private static final Pattern EmailPattern;
    private static Set<String> validCountries;
    private static Set<String> validTimeZones;

    public static boolean apply(Validations validation, Object value) {
        boolean pass = false;
        switch (validation) {
            case EMAIL: {
                pass = Validations.validateEmail(value.toString());
                break;
            }
            case PHONE: {
                pass = true;
                break;
            }
            case PHOTO: {
                pass = Validations.validateURI(value.toString());
                break;
            }
            case COUNTRY: {
                pass = Validations.validateCountry(value.toString());
                break;
            }
            case LOCALE: {
                pass = Validations.validateLocale(value.toString());
                break;
            }
            case TIMEZONE: {
                pass = Validations.validateTimezone(value.toString());
            }
        }
        return pass;
    }

    private static boolean validateEmail(String val) {
        return EmailPattern.matcher(val).matches();
    }

    private static boolean validateCountry(String val) {
        return validCountries.contains(val.toUpperCase());
    }

    private static boolean validateTimezone(String val) {
        return validTimeZones.contains(val);
    }

    private static boolean validateURI(String val) {
        boolean valid = true;
        try {
            new URI(val);
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    private static boolean validateLocale(String val) {
        val = val.replaceAll("_", "-");
        try {
            new Locale.Builder().setLanguageTag(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        EmailPattern = Pattern.compile("^.+@.+$");
        validCountries = new HashSet<String>(Arrays.asList(Locale.getISOCountries()));
        validTimeZones = new HashSet<String>(Arrays.asList(TimeZone.getAvailableIDs()));
    }
}

