/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.cert.fingerprint;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerprintHelper {
    private static final Logger log = LoggerFactory.getLogger(FingerprintHelper.class);

    public static String getPublicKeySshFingerprint(PublicKey publicKey) throws NoSuchAlgorithmException, IOException {
        if (publicKey instanceof RSAPublicKey) {
            return FingerprintHelper.getPublicKeySshFingerprint((RSAPublicKey)publicKey);
        }
        throw new NoSuchAlgorithmException("Unsopported PublicKey type");
    }

    public static String getPublicKeySshFingerprint(RSAPublicKey publicKey) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] derEncoded = FingerprintHelper.getDerEncoding(publicKey);
        byte[] fingerprint = digest.digest(derEncoded);
        return Hex.encodeHexString((byte[])fingerprint);
    }

    private static byte[] getDerEncoding(RSAPublicKey key) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(buffer);
        FingerprintHelper.writeDataWithLength("ssh-rsa".getBytes(), dataOutput);
        FingerprintHelper.writeDataWithLength(key.getPublicExponent().toByteArray(), dataOutput);
        FingerprintHelper.writeDataWithLength(key.getModulus().toByteArray(), dataOutput);
        return buffer.toByteArray();
    }

    private static void writeDataWithLength(byte[] data, DataOutput byteBuffer) throws IOException {
        byteBuffer.writeInt(data.length);
        byteBuffer.write(data);
    }
}

