/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.cert.vm;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.servlet.http.Cookie;
import org.gluu.casa.core.pojo.User;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.misc.WebUtils;
import org.gluu.casa.plugins.cert.service.CertService;
import org.gluu.casa.plugins.cert.service.UserCertificateMatch;
import org.gluu.casa.service.IPersistenceService;
import org.gluu.casa.service.ISessionContext;
import org.gluu.casa.service.SndFactorAuthenticationUtils;
import org.gluu.oxauth.model.util.CertUtils;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.select.annotation.WireVariable;

public class CertAuthenticationViewModel {
    private static final String RND_KEY = "key";
    private static final String CERT_HEADER = "X-ClientCert";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private CertService certService;
    private StringEncrypter stringEncrypter;
    @WireVariable
    private ISessionContext sessionContext;
    private User user;
    private boolean hasConfigErrors;
    private boolean present;
    private boolean parsed;
    private boolean valid;
    private boolean inCasaSession;
    private UserCertificateMatch userCertMatch;
    private String userId;

    public boolean isPresent() {
        return this.present;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isHasConfigErrors() {
        return this.hasConfigErrors;
    }

    public boolean isInCasaSession() {
        return this.inCasaSession;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserCertificateMatch getUserCertMatch() {
        return this.userCertMatch;
    }

    @Init
    public void init() throws Exception {
        this.logger.info("Loading certificate validation page...");
        this.user = this.sessionContext.getLoggedUser();
        this.stringEncrypter = Utils.stringEncrypter();
        this.inCasaSession = this.user != null;
        this.logger.info("There is{} user in session", (Object)(this.inCasaSession ? "" : " no"));
        String key = WebUtils.getQueryParam((String)RND_KEY);
        if (this.inCasaSession) {
            this.userId = this.user.getId();
        } else {
            if (Utils.isEmpty((String)key)) {
                this.logger.warn("Expected parameter '{}' not specified in URL.", (Object)RND_KEY);
            } else {
                Pair<String, String> pair = this.getTokens(key);
                key = (String)pair.getX();
                this.userId = (String)pair.getY();
            }
            if (this.userId != null) {
                this.logger.debug("User id is {}", (Object)this.userId);
            } else {
                this.logger.error("No user ID could be obtained. Aborting...");
                return;
            }
        }
        this.certService = CertService.getInstance();
        boolean bl = this.hasConfigErrors = !this.certService.isHasValidProperties();
        if (this.hasConfigErrors) {
            this.logger.info("Configuration errors were detected. Please check the log file and plugin documentation");
            return;
        }
        X509Certificate userCert = this.processCert();
        UserCertificateMatch userCertificateMatch = this.userCertMatch = this.valid ? this.certService.processMatch(userCert, this.userId, this.inCasaSession) : null;
        if (this.inCasaSession) {
            if (this.userCertMatch.equals((Object)UserCertificateMatch.SUCCESS)) {
                ((SndFactorAuthenticationUtils)Utils.managedBean(SndFactorAuthenticationUtils.class)).notifyEnrollment(this.user, "cert");
            }
        } else {
            this.logger.debug("Setting cookie with outcome of operation");
            this.setCookie(key, this.present, this.parsed, this.valid, this.userCertMatch);
            this.logger.info("Preparing redirect for completion of authentication flow");
            String url = ((IPersistenceService)Utils.managedBean(IPersistenceService.class)).getIssuerUrl();
            WebUtils.execRedirect((String)String.format("%s/oxauth/postlogin.htm", url), (boolean)true);
        }
    }

    private X509Certificate processCert() {
        X509Certificate clientCert = null;
        String clientCertString = WebUtils.getRequestHeader((String)CERT_HEADER);
        try {
            if (Utils.isEmpty((String)clientCertString)) {
                String attribute = "javax.servlet.request.X509Certificate";
                Optional<Object> optAttr = Optional.ofNullable(WebUtils.getServletRequest().getAttribute(attribute));
                if (optAttr.isPresent()) {
                    this.logger.info("Got a certificate in request attribute '{}'", (Object)attribute);
                    this.present = true;
                    clientCert = optAttr.map(X509Certificate[].class::cast).map(certs -> certs[0]).orElse(null);
                }
            } else {
                this.logger.info("Got a certificate in request header '{}'", (Object)CERT_HEADER);
                this.present = true;
                clientCert = CertUtils.x509CertificateFromPem((String)clientCertString);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (clientCert == null) {
            this.logger.warn("No client certificate was found. Probably the user hit the Cancel button in the browser prompt");
        } else {
            this.parsed = true;
            this.valid = this.certService.validate(clientCert);
        }
        return clientCert;
    }

    private Pair<String, String> getTokens(String encrypted) {
        Pair pair = new Pair(null, null);
        try {
            String decrypted = this.stringEncrypter.decrypt(encrypted);
            String[] tokens = decrypted.split(";");
            return new Pair((Object)tokens[0], (Object)tokens[1]);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return pair;
        }
    }

    private void setCookie(String rndkey, boolean present, boolean parsed, boolean valid, UserCertificateMatch match) {
        try {
            int val = present ? 1 : 0;
            val += parsed ? 1 : 0;
            int n = valid ? 1 : 0;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(RND_KEY, rndkey);
            map.put("status", val += n);
            if (valid) {
                map.put("match", match.name());
            }
            String value = new ObjectMapper().writeValueAsString(map);
            Cookie coo = new Cookie("casa-cert-authn", this.stringEncrypter.encrypt(value));
            coo.setPath("/");
            coo.setSecure(true);
            coo.setHttpOnly(true);
            coo.setMaxAge(10);
            WebUtils.getServletResponse().addCookie(coo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

