/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim;

import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.AttributesList;
import org.gluu.persist.annotation.CustomObjectClass;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.ObjectClass;
import org.gluu.persist.model.base.CustomObjectAttribute;
import org.gluu.persist.model.base.Entry;

@DataEntry
@ObjectClass(value="gluuPerson")
public class ScimCustomPerson
extends Entry
implements Serializable {
    private static final long serialVersionUID = -234934710284710189L;
    @CustomObjectClass
    private String[] customObjectClasses;
    @AttributeName(name="oxCreationTimestamp")
    private Date creationDate;
    @AttributeName
    private Date updatedAt;
    @AttributeName(name="oxPPID")
    private List<String> oxPPID;
    @AttributesList(name="name", value="values", multiValued="multiValued", sortByName=true, attributesConfiguration={@AttributeName(name="inum", ignoreDuringUpdate=true), @AttributeName(name="uid"), @AttributeName(name="userPassword", ignoreDuringRead=true)})
    private List<CustomObjectAttribute> typedCustomAttributes = new ArrayList<CustomObjectAttribute>();

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getDisplayName() {
        return this.getAttribute("displayName");
    }

    public String getGivenName() {
        return this.getAttribute("givenName");
    }

    public String getInum() {
        return this.getAttribute("inum");
    }

    public List<String> getMemberOf() {
        return this.getAttributeList("memberOf");
    }

    public List<String> getOxPPID() {
        return this.oxPPID;
    }

    public String getPreferredLanguage() {
        return this.getAttribute("preferredLanguage");
    }

    public String getSurname() {
        return this.getAttribute("sn");
    }

    public String getTimezone() {
        return this.getAttribute("zoneinfo");
    }

    public String getUid() {
        return this.getAttribute("uid");
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUserPassword() {
        return this.getAttribute("userPassword");
    }

    public List<String> getAttributeList(String attributeName) {
        List list = Optional.ofNullable(this.getTypedAttribute(attributeName)).map(CustomObjectAttribute::getValues).orElse(Collections.emptyList()).stream().filter(el -> el != null).collect(Collectors.toList());
        ArrayList<String> result = new ArrayList<String>();
        for (Object obj : list) {
            if (obj.getClass().equals(Date.class)) {
                long millis = ((Date)Date.class.cast(obj)).getTime();
                result.add(DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(millis)));
                continue;
            }
            result.add(obj.toString());
        }
        return result;
    }

    public String getAttribute(String attributeName) {
        List<String> values = this.getAttributeList(attributeName);
        return values.isEmpty() ? null : values.get(0);
    }

    public String[] getAttributes(String attributeName) {
        List<String> values = this.getAttributeList(attributeName);
        return values.isEmpty() ? null : values.toArray(new String[0]);
    }

    public List<CustomObjectAttribute> getTypedCustomAttributes() {
        return this.typedCustomAttributes;
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }

    public void setTypedCustomAttributes(List<CustomObjectAttribute> typedCustomAttributes) {
        this.typedCustomAttributes = typedCustomAttributes;
    }

    public CustomObjectAttribute getTypedAttribute(String attributeName) {
        return this.typedCustomAttributes.stream().filter(tca -> tca.getName().equals(attributeName)).findFirst().orElse(null);
    }

    public void setCommonName(String value) {
        this.setAttribute("cn", value);
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setInum(String value) {
        this.setAttribute("inum", value);
    }

    public void setOxPPID(List<String> oxPPID) {
        this.oxPPID = oxPPID;
    }

    public void setUid(String value) {
        this.setCustomAttribute("uid", value);
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setUserPassword(String value) {
        this.setCustomAttribute("userPassword", value);
    }

    public void setAttribute(String attributeName, String[] attributeValue) {
        this.setCustomAttribute(attributeName, Arrays.asList(attributeValue));
    }

    public void setAttribute(String attributeName, String attributeValue) {
        if (attributeValue == null || attributeValue.length() == 0) {
            this.setCustomAttribute(attributeName, Collections.emptyList());
        } else {
            this.setCustomAttribute(attributeName, attributeValue);
        }
    }

    public void setCustomAttribute(String attributeName, Object attributeValue) {
        CustomObjectAttribute attribute = new CustomObjectAttribute(attributeName, attributeValue);
        this.typedCustomAttributes.remove(attribute);
        this.typedCustomAttributes.add(attribute);
    }

    public void setCustomAttribute(String attributeName, List<Object> attributeValue) {
        CustomObjectAttribute attribute = new CustomObjectAttribute(attributeName, attributeValue);
        attribute.setMultiValued(true);
        this.typedCustomAttributes.remove(attribute);
        this.typedCustomAttributes.add(attribute);
    }
}

