/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2.provider.schema;

import java.util.List;
import org.gluu.oxtrust.model.scim2.AttributeDefinition;
import org.gluu.oxtrust.model.scim2.annotations.Attribute;

public class SchemaAttribute {
    @Attribute(description="The attribute's name", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String name;
    @Attribute(description="The attribute's data type", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String type;
    @Attribute(description="When an attribute is of type \"complex\", \"subAttributes\" defines a set of sub-attributes", mutability=AttributeDefinition.Mutability.READ_ONLY, type=AttributeDefinition.Type.COMPLEX, multiValueClass=SchemaAttribute.class)
    private List<SchemaAttribute> subAttributes;
    @Attribute(description="A Boolean value indicating the attribute's plurality", mutability=AttributeDefinition.Mutability.READ_ONLY, type=AttributeDefinition.Type.BOOLEAN)
    private boolean multiValued;
    @Attribute(description="The attribute's human-readable description", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String description;
    @Attribute(description="A Boolean value that specifies whether or not the attribute is required", mutability=AttributeDefinition.Mutability.READ_ONLY, type=AttributeDefinition.Type.BOOLEAN)
    private boolean required;
    @Attribute(description="A Boolean value that specifies whether or not the attribute is required", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private List<String> canonicalValues;
    @Attribute(description="A Boolean value that specifies whether or not a string attribute is case sensitive", mutability=AttributeDefinition.Mutability.READ_ONLY, type=AttributeDefinition.Type.BOOLEAN)
    private boolean caseExact;
    @Attribute(description="A single keyword indicating the circumstances under which the value of the attribute can be (re)defined", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String mutability;
    @Attribute(description="A single keyword that indicates when an attribute and associated values are returned in response to a GET request or in response to a PUT, POST, or PATCH request", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String returned;
    @Attribute(description="A single keyword value that specifies how the service provider enforces uniqueness of attribute values", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String uniqueness;
    @Attribute(description="A multi-valued array of JSON strings that indicate the SCIM resource types that may be referenced", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private List<String> referenceTypes;

    public SchemaAttribute() {
    }

    public SchemaAttribute(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<SchemaAttribute> getSubAttributes() {
        return this.subAttributes;
    }

    public void setSubAttributes(List<SchemaAttribute> subAttributes) {
        this.subAttributes = subAttributes;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public void setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public List<String> getCanonicalValues() {
        return this.canonicalValues;
    }

    public void setCanonicalValues(List<String> canonicalValues) {
        this.canonicalValues = canonicalValues;
    }

    public boolean isCaseExact() {
        return this.caseExact;
    }

    public void setCaseExact(boolean caseExact) {
        this.caseExact = caseExact;
    }

    public String getMutability() {
        return this.mutability;
    }

    public void setMutability(String mutability) {
        this.mutability = mutability;
    }

    public String getReturned() {
        return this.returned;
    }

    public void setReturned(String returned) {
        this.returned = returned;
    }

    public String getUniqueness() {
        return this.uniqueness;
    }

    public void setUniqueness(String uniqueness) {
        this.uniqueness = uniqueness;
    }

    public List<String> getReferenceTypes() {
        return this.referenceTypes;
    }

    public void setReferenceTypes(List<String> referenceTypes) {
        this.referenceTypes = referenceTypes;
    }

    public boolean equals(Object other) {
        boolean eq = false;
        if (other instanceof SchemaAttribute) {
            eq = ((SchemaAttribute)other).getName().equals(this.name);
        }
        return eq;
    }
}

