/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.NullType;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxtrust.model.scim2.util.DateUtil;
import org.gluu.oxtrust.model.scim2.util.IntrospectUtil;

public class CustomAttributes {
    private Map<String, Object> attributeMap;
    private String uri;

    public CustomAttributes(String uri) {
        this.uri = uri;
        this.attributeMap = new HashMap<String, Object>();
    }

    CustomAttributes(String uri, Map<String, Object> attributeMap) {
        this.uri = uri;
        this.attributeMap = attributeMap;
    }

    private void set(String name, Object value) {
        if (StringUtils.isNotEmpty((String)name) && value != null) {
            this.attributeMap.put(name, value);
        }
    }

    Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public String getUri() {
        return this.uri;
    }

    public Set<String> getAttributeNames() {
        return this.attributeMap.keySet();
    }

    public void remove(String name) {
        this.attributeMap.remove(name);
    }

    public void setAttribute(String name, String value) {
        this.set(name, value);
    }

    public void setAttribute(String name, Boolean value) {
        this.set(name, value);
    }

    public void setAttribute(String name, Double value) {
        this.set(name, value);
    }

    public void setAttribute(String name, Integer value) {
        this.set(name, value);
    }

    public void setAttribute(String name, Date value) {
        if (value != null) {
            this.setAttribute(name, DateUtil.millisToISOString(value.getTime()));
        }
    }

    public void setAttribute(String name, List<?> values) {
        if (values != null && values.size() > 0) {
            this.set(name, values);
        }
    }

    public <T> List<T> getValues(String name, Class<T> cls) {
        Object val = this.attributeMap.get(name);
        List<Object> list = null;
        if (val != null) {
            if (IntrospectUtil.isCollection(val.getClass())) {
                list = new ArrayList();
                for (Object item : (Collection)val) {
                    T aValue = CustomAttributes.getTypedValue(item, cls);
                    if (aValue == null) {
                        list = null;
                        break;
                    }
                    list.add(aValue);
                }
                if (list != null && list.size() == 0) {
                    list = null;
                }
            } else {
                T aValue = CustomAttributes.getTypedValue(val, cls);
                list = aValue == null ? null : Collections.singletonList(aValue);
            }
        }
        return list;
    }

    public <T> T getValue(String name, Class<T> cls) {
        if (!IntrospectUtil.isCollection(cls)) {
            Object val = this.attributeMap.get(name);
            return CustomAttributes.getTypedValue(val, cls);
        }
        return null;
    }

    private static <T> T getTypedValue(Object val, Class<T> cls) {
        if (val != null) {
            Class<Object> classOfVal = val.getClass();
            if (IntrospectUtil.isCollection(classOfVal)) {
                Collection coll = (Collection)val;
                Iterator iterator = coll.iterator();
                if (iterator.hasNext()) {
                    val = iterator.next();
                    classOfVal = val.getClass();
                } else {
                    val = null;
                    classOfVal = NullType.class;
                }
            }
            if (val != null) {
                if (Date.class.equals(cls)) {
                    try {
                        val = new Date(DateUtil.ISOToMillis(val.toString()));
                    }
                    catch (Exception e) {
                        val = null;
                    }
                } else if (String.class.equals(cls)) {
                    val = val.toString();
                } else if (!classOfVal.equals(cls)) {
                    val = null;
                }
            }
        }
        try {
            return cls.cast(val);
        }
        catch (Exception e) {
            return null;
        }
    }
}

