/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxtrust.model.scim2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gluu.oxtrust.model.scim2.AttributeDefinition;
import org.gluu.oxtrust.model.scim2.CustomAttributes;
import org.gluu.oxtrust.model.scim2.Meta;
import org.gluu.oxtrust.model.scim2.annotations.Attribute;
import org.gluu.oxtrust.model.scim2.annotations.StoreReference;
import org.gluu.oxtrust.model.scim2.fido.Fido2DeviceResource;
import org.gluu.oxtrust.model.scim2.fido.FidoDeviceResource;
import org.gluu.oxtrust.model.scim2.group.GroupResource;
import org.gluu.oxtrust.model.scim2.user.UserResource;
import org.gluu.oxtrust.model.scim2.util.IntrospectUtil;
import org.gluu.oxtrust.model.scim2.util.ScimResourceUtil;

public class BaseScimResource {
    @Attribute(description="The schemas attribute is a REQUIRED attribute and is an array of Strings containing URIs that are used to indicate the namespaces of the SCIM schemas that define the attributes present in the current JSON structure", isRequired=true, returned=AttributeDefinition.Returned.ALWAYS)
    private Set<String> schemas;
    @Attribute(description="A unique identifier for a SCIM resource as defined by the service provider", isRequired=false, isCaseExact=true, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.ALWAYS, uniqueness=AttributeDefinition.Uniqueness.SERVER)
    @StoreReference(resourceType={UserResource.class, GroupResource.class, FidoDeviceResource.class, Fido2DeviceResource.class}, refs={"inum", "inum", "oxId", "oxId"})
    private String id;
    @Attribute(description="A String that is an identifier for the resource as defined by the provisioning client", isCaseExact=true)
    @StoreReference(resourceType={UserResource.class}, refs={"oxTrustExternalId"})
    private String externalId;
    @Attribute(description="A complex attribute containing resource metadata", mutability=AttributeDefinition.Mutability.READ_ONLY, type=AttributeDefinition.Type.COMPLEX)
    private Meta meta;
    private Map<String, Object> extendedAttrs = new HashMap<String, Object>();

    @JsonAnySetter
    public void addCustomAttributes(String uri, Map<String, Object> map) {
        this.extendedAttrs.put(uri, map);
        this.schemas.add(uri);
    }

    public void addCustomAttributes(CustomAttributes customAttributes) {
        this.addCustomAttributes(customAttributes.getUri(), customAttributes.getAttributeMap());
    }

    @JsonAnyGetter
    public Map<String, Object> getCustomAttributes() {
        return this.extendedAttrs;
    }

    public CustomAttributes getCustomAttributes(String uri) {
        if (this.extendedAttrs.get(uri) == null) {
            return null;
        }
        return new CustomAttributes(uri, IntrospectUtil.strObjMap(this.extendedAttrs.get(uri)));
    }

    public BaseScimResource() {
        this.schemas = new HashSet<String>();
        String defSchema = ScimResourceUtil.getDefaultSchemaUrn(this.getClass());
        if (defSchema != null) {
            this.schemas.add(defSchema);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public Set<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Set<String> schemas) {
        this.schemas = schemas;
    }
}

