/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.cert.vm;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gluu.casa.core.pojo.User;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.cert.model.Certificate;
import org.gluu.casa.plugins.cert.service.CertService;
import org.gluu.casa.service.ISessionContext;
import org.gluu.casa.service.SndFactorAuthenticationUtils;
import org.gluu.casa.ui.UIUtils;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.Pair;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Messagebox;

public class CertAuthenticationSummaryViewModel {
    private Logger logger = LogManager.getLogger(this.getClass());
    @WireVariable
    private ISessionContext sessionContext;
    private User user;
    private List<Certificate> certificates;
    private CertService certService;
    private SndFactorAuthenticationUtils sndFactorUtils;

    public List<Certificate> getCertificates() {
        return this.certificates;
    }

    @Init
    public void init() {
        this.certService = CertService.getInstance();
        this.user = this.sessionContext.getLoggedUser();
        this.sndFactorUtils = (SndFactorAuthenticationUtils)Utils.managedBean(SndFactorAuthenticationUtils.class);
        this.certificates = this.certService.getUserCerts(this.user.getId());
    }

    @Command
    public void delete(@BindingParam(value="cert") Certificate certificate) {
        String resetMessages = (String)this.sndFactorUtils.removalConflict("cert", this.certificates.size(), this.user).getY();
        boolean reset = resetMessages != null;
        Pair<String, String> delMessages = this.getDeleteMessages(resetMessages);
        Messagebox.show((String)((String)delMessages.getY()), (String)((String)delMessages.getX()), (int)48, (String)(reset ? "z-messagebox-icon z-messagebox-exclamation" : "z-messagebox-icon z-messagebox-question"), event -> {
            if ("onYes".equals(event.getName())) {
                try {
                    boolean success = this.certService.removeFromUser(certificate.getFingerPrint(), this.user.getId());
                    if (success) {
                        if (reset) {
                            this.sndFactorUtils.turn2faOff(this.user);
                        }
                        this.certificates.remove(certificate);
                        BindUtils.postNotifyChange(null, null, (Object)this, (String)"certificates");
                    }
                    UIUtils.showMessageUI((boolean)success);
                }
                catch (Exception e) {
                    UIUtils.showMessageUI((boolean)false);
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private Pair<String, String> getDeleteMessages(String msg) {
        StringBuilder text = new StringBuilder();
        if (msg != null) {
            text.append(msg).append("\n\n");
        }
        text.append(Labels.getLabel((String)"usercert.del_confirm"));
        if (msg != null) {
            text.append("\n");
        }
        return new Pair(null, (Object)text.toString());
    }
}

