/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.cert;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gluu.casa.credential.BasicCredential;
import org.gluu.casa.extension.AuthnMethod;
import org.gluu.casa.plugins.cert.service.CertService;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class CertAuthenticationExtension
implements AuthnMethod {
    public static final String ACR = "cert";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private CertService certService = CertService.getInstance();

    public String getUINameKey() {
        return "usrcert.cert_label";
    }

    public String getAcr() {
        return ACR;
    }

    public String getPanelTitleKey() {
        return "usrcert.cert_title";
    }

    public String getPanelTextKey() {
        return "usrcert.cert_text";
    }

    public String getPanelButtonKey() {
        return "usrcert.cert_manage";
    }

    public String getPageUrl() {
        return "cert-detail.zul";
    }

    public List<BasicCredential> getEnrolledCreds(String id) {
        try {
            return this.certService.getUserCerts(id).stream().map(cert -> new BasicCredential(cert.getFormattedName(), -1L)).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void reloadConfiguration() {
        this.certService.reloadConfiguration();
    }

    public int getTotalUserCreds(String id) {
        return this.certService.getDevicesTotal(id);
    }
}

