/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.bioid.vm;

import java.util.List;
import org.gluu.casa.core.pojo.User;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.bioid.BioIDService;
import org.gluu.casa.plugins.bioid.model.BioIDCredential;
import org.gluu.casa.service.ISessionContext;
import org.gluu.casa.service.SndFactorAuthenticationUtils;
import org.gluu.casa.ui.UIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.Pair;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Messagebox;

public class BioidViewModel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @WireVariable
    private ISessionContext sessionContext;
    private List<BioIDCredential> devices;
    private BioIDCredential newDevice;
    private String accessToken;
    private String apiUrl;
    private String task;
    private String trait;
    private boolean uiBioidShown;
    private SndFactorAuthenticationUtils sndFactorUtils;
    private User user;

    public String getAccessToken() {
        return this.accessToken;
    }

    public boolean isUiBioidShown() {
        return this.uiBioidShown;
    }

    public void setUiBioidShown(boolean uiBioidShown) {
        this.uiBioidShown = uiBioidShown;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getTrait() {
        return this.trait;
    }

    public void setTrait(String trait) {
        this.trait = trait;
    }

    public BioIDCredential getNewDevice() {
        return this.newDevice;
    }

    public void setNewDevice(BioIDCredential newDevice) {
        this.newDevice = newDevice;
    }

    public List<BioIDCredential> getDevices() {
        return this.devices;
    }

    @Init
    public void init() {
        this.logger.debug("init invoked");
        this.sessionContext = (ISessionContext)Utils.managedBean(ISessionContext.class);
        this.user = this.sessionContext.getLoggedUser();
        this.sndFactorUtils = (SndFactorAuthenticationUtils)Utils.managedBean(SndFactorAuthenticationUtils.class);
        this.devices = BioIDService.getInstance().getBioIDDevices(this.sessionContext.getLoggedUser().getId());
    }

    @NotifyChange(value={"uiBioidShown"})
    public void show(String mode) {
        this.logger.debug("showBioID");
        this.uiBioidShown = true;
        try {
            this.sessionContext = (ISessionContext)Utils.managedBean(ISessionContext.class);
            this.apiUrl = BioIDService.getInstance().getScriptPropertyValue("ENDPOINT");
            this.trait = "Face,Periocular";
            String bcid = BioIDService.getInstance().getScriptPropertyValue("STORAGE") + "." + BioIDService.getInstance().getScriptPropertyValue("PARTITION") + "." + this.sessionContext.getLoggedUser().getUserName().hashCode();
            try {
                this.accessToken = BioIDService.getInstance().getAccessToken(bcid, "enroll");
                this.task = "enroll";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Clients.response((AuResponse)new AuInvoke("initPage", new Object[]{this.accessToken, this.trait, "enroll".equals(this.task) ? "enrollment" : "verification", this.apiUrl, Executions.getCurrent().getContextPath() + "/pl/bioid-plugin/user/cred_details.zul"}));
            Clients.scrollBy((int)0, (int)700);
        }
        catch (Exception e) {
            UIUtils.showMessageUI((boolean)false);
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    Pair<String, String> getDeleteMessages(String nick, String extraMessage) {
        StringBuilder text = new StringBuilder();
        if (extraMessage != null) {
            text.append(extraMessage).append("\n\n");
        }
        text.append(Labels.getLabel((String)"bioid_del_confirm", (Object[])new String[]{nick == null ? Labels.getLabel((String)"general.no_named") : nick}));
        if (extraMessage != null) {
            text.append("\n");
        }
        return new Pair((Object)Labels.getLabel((String)"bioid_del_title"), (Object)text.toString());
    }

    public void delete() {
        this.logger.debug("delete invoked");
        String resetMessages = (String)this.sndFactorUtils.removalConflict(BioIDService.ACR, 1, this.user).getY();
        boolean reset = resetMessages != null;
        Pair<String, String> delMessages = this.getDeleteMessages(resetMessages, null);
        Messagebox.show((String)((String)delMessages.getY()), (String)((String)delMessages.getX()), (int)48, (String)"z-messagebox-icon z-messagebox-exclamation", event -> {
            if ("onYes".equals(event.getName())) {
                boolean success = false;
                try {
                    this.sessionContext = (ISessionContext)Utils.managedBean(ISessionContext.class);
                    this.apiUrl = BioIDService.getInstance().getScriptPropertyValue("ENDPOINT");
                    this.trait = "Face,Periocular";
                    String bcid = BioIDService.getInstance().getScriptPropertyValue("STORAGE") + "." + BioIDService.getInstance().getScriptPropertyValue("PARTITION") + "." + this.sessionContext.getLoggedUser().getUserName().hashCode();
                    try {
                        success = BioIDService.getInstance().deleteBioIDCredential(this.sessionContext.getLoggedUser().getUserName());
                        if (success) {
                            BioIDService.getInstance().removeFromPersistence(bcid, "Face,Periocular", this.sessionContext.getLoggedUser().getId());
                            this.sndFactorUtils.turn2faOff(this.user);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    UIUtils.showMessageUI((boolean)false);
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                if (!success) {
                    UIUtils.showMessageUI((boolean)false);
                } else {
                    UIUtils.showMessageUI((boolean)true);
                    BindUtils.postNotifyChange((Object)this, (String)"devices");
                    Executions.sendRedirect(null);
                }
            }
        });
    }

    private boolean persistEnrollment() throws Exception {
        this.logger.debug("persistEnrollment onData=#readyButton");
        String bcid = BioIDService.getInstance().getScriptPropertyValue("STORAGE") + "." + BioIDService.getInstance().getScriptPropertyValue("PARTITION") + "." + this.sessionContext.getLoggedUser().getUserName().hashCode();
        boolean success = BioIDService.getInstance().writeToPersistence(bcid, "enroll", "Face,Periocular", this.sessionContext.getLoggedUser().getId());
        this.logger.debug("persistEnrollment onData=#readyButton : " + success);
        return success;
    }

    @Listen(value="onData=#readyButton")
    public void persistOnAdd(Event event) throws Exception {
        this.logger.trace(" onData add invoked");
        boolean success = this.persistEnrollment();
        if (success) {
            ((SndFactorAuthenticationUtils)Utils.managedBean(SndFactorAuthenticationUtils.class)).notifyEnrollment(this.user, BioIDService.ACR);
            UIUtils.showMessageUI((boolean)true);
        } else {
            UIUtils.showMessageUI((boolean)false);
        }
    }

    @Listen(value="onData=#enrollAgainButton")
    public void persistOnEdit(Event event) throws Exception {
        this.logger.trace(" onData enroll invoked");
        this.persistEnrollment();
        UIUtils.showMessageUI((boolean)true);
    }

    @AfterCompose
    public void afterCompose(@ContextParam(value=ContextType.VIEW) Component view) {
        this.logger.debug("afterCompose invoked");
        Selectors.wireEventListeners((Component)view, (Object)this);
    }
}

