/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.bioid;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.bioid.model.BioIDCredential;
import org.gluu.casa.plugins.bioid.model.PersonBiometric;
import org.gluu.casa.service.IPersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioIDService {
    private static BioIDService SINGLE_INSTANCE = null;
    public static Map<String, String> properties;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static String ACR;
    private int TIMEOUT = 5000;
    public static final String TRAIT_FACE = "Face";
    public static final String TRAIT_PERIOCULAR = "Periocular";
    public static final String TRAIT_FACE_PERIOCULAR = "Face,Periocular";
    public static final String TRAIT_LABEL_FACE_PERIOCULAR = "face_periocular";
    public static final String TRAIT_VOICE = "voice";
    public static final String TASK_ENROLL = "enroll";
    public static final String TASK_VERIFY = "verify";
    private static ObjectMapper mapper;
    private IPersistenceService persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);

    private BioIDService() {
        this.reloadConfiguration();
        mapper = new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BioIDService getInstance() {
        if (SINGLE_INSTANCE != null) return SINGLE_INSTANCE;
        Class<BioIDService> clazz = BioIDService.class;
        synchronized (BioIDService.class) {
            SINGLE_INSTANCE = new BioIDService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return SINGLE_INSTANCE;
        }
    }

    public void reloadConfiguration() {
        ObjectMapper mapper = new ObjectMapper();
        properties = this.persistenceService.getCustScriptConfigProperties(ACR);
        if (properties == null) {
            this.logger.warn("Config. properties for custom script '{}' could not be read. Features related to {} will not be accessible", (Object)ACR, (Object)ACR.toUpperCase());
        } else {
            try {
                this.logger.info("BioID settings found were: {}", (Object)mapper.writeValueAsString(properties));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getScriptPropertyValue(String value) {
        return properties.get(value);
    }

    public int getDeviceTotal(String uniqueIdOfTheUser) {
        return this.getBioIDDevices(uniqueIdOfTheUser).size();
    }

    public boolean deleteBioIDCredential(String userName) throws Exception {
        String bcid = properties.get("STORAGE") + "." + properties.get("PARTITION") + "." + userName.hashCode();
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("bcid", bcid));
        String asB64 = Base64.getEncoder().encodeToString((properties.get("APP_IDENTIFIER") + ":" + properties.get("APP_SECRET")).getBytes("utf-8"));
        String url = properties.get("ENDPOINT") + "deleteclass";
        String result = this.sendDelete(url, params, (NameValuePair)new BasicNameValuePair("Authorization", "Basic " + asB64), this.TIMEOUT);
        this.logger.info(result);
        return result != null;
    }

    public boolean isEnrolled(String bcid, String trait) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("bcid", bcid));
        params.add((NameValuePair)new BasicNameValuePair("trait", trait));
        params.add((NameValuePair)new BasicNameValuePair("livedetection", "true"));
        String asB64 = Base64.getEncoder().encodeToString((properties.get("APP_IDENTIFIER") + ":" + properties.get("APP_SECRET")).getBytes("utf-8"));
        String url = properties.get("ENDPOINT") + "isenrolled";
        String result = this.getUrlContents(url, params, (NameValuePair)new BasicNameValuePair("Authorization", "Basic " + asB64), this.TIMEOUT);
        this.logger.info(result);
        return result != null;
    }

    public boolean performBiometricOperation(String userId, String bcid, String trait, String task, String token) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("livedetection", "true"));
        String url = properties.get("ENDPOINT") + task;
        String result = this.getUrlContents(url, params, (NameValuePair)new BasicNameValuePair("Authorization", "Bearer " + token), this.TIMEOUT);
        this.logger.info(result);
        return true;
    }

    public String getAccessToken(String bcid, String task) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("id", properties.get("APP_IDENTIFIER")));
        params.add((NameValuePair)new BasicNameValuePair("bcid", bcid));
        params.add((NameValuePair)new BasicNameValuePair("task", task));
        String asB64 = Base64.getEncoder().encodeToString((properties.get("APP_IDENTIFIER") + ":" + properties.get("APP_SECRET")).getBytes("utf-8"));
        String url = properties.get("ENDPOINT") + "token";
        String result = this.getUrlContents(url, params, (NameValuePair)new BasicNameValuePair("Authorization", "Basic " + asB64), this.TIMEOUT);
        this.logger.info(result);
        return result;
    }

    private String getUrlContents(String url, List<NameValuePair> nvPairList, NameValuePair header, int timeout) throws Exception {
        String contents = null;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpParams params = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeout);
        HttpGet httpGet = new HttpGet(url);
        URIBuilder uribe = new URIBuilder(httpGet.getURI());
        nvPairList.forEach(pair -> uribe.addParameter(pair.getName(), pair.getValue()));
        httpGet.setURI(uribe.build());
        httpGet.setHeader(header.getName(), header.getValue());
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
        HttpEntity entity = response.getEntity();
        this.logger.debug("GET request is {}", (Object)(httpGet.getURI() + " response status is:" + response.getStatusLine().getStatusCode()));
        if (response.getStatusLine().getStatusCode() == 200) {
            contents = EntityUtils.toString((HttpEntity)entity);
        }
        EntityUtils.consume((HttpEntity)entity);
        return contents;
    }

    private String sendDelete(String url, List<NameValuePair> nvPairList, NameValuePair header, int timeout) throws Exception {
        String contents = null;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpParams params = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeout);
        HttpDelete httpDelete = new HttpDelete(url);
        URIBuilder uribe = new URIBuilder(httpDelete.getURI());
        nvPairList.forEach(pair -> uribe.addParameter(pair.getName(), pair.getValue()));
        httpDelete.setURI(uribe.build());
        httpDelete.setHeader(header.getName(), header.getValue());
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpDelete);
        HttpEntity entity = response.getEntity();
        this.logger.debug("Delete request is {}", (Object)(httpDelete.getURI() + " response status is:" + response.getStatusLine().getStatusCode()));
        if (response.getStatusLine().getStatusCode() == 200) {
            contents = EntityUtils.toString((HttpEntity)entity);
        }
        EntityUtils.consume((HttpEntity)entity);
        return contents;
    }

    public List<BioIDCredential> getBioIDDevices(String userId) {
        ArrayList<BioIDCredential> devices = new ArrayList<BioIDCredential>();
        try {
            String json;
            PersonBiometric person = (PersonBiometric)((Object)this.persistenceService.get(PersonBiometric.class, this.persistenceService.getPersonDn(userId)));
            if (person != null && !Utils.isEmpty((String)(json = person.getBioMetricDevices()))) {
                json = Utils.isEmpty((String)json) ? "[]" : mapper.readTree(json).get("bioid").toString();
                BioIDCredential device = (BioIDCredential)mapper.readValue(json, (TypeReference)new TypeReference<BioIDCredential>(){});
                devices.add(device);
                this.logger.trace("getBioIDDevices. User '{}' has {}", (Object)userId, (Object)device.getBcid());
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return devices;
    }

    public boolean writeToPersistence(String bcid, String task, String trait, String userId) throws JsonProcessingException {
        BioIDService.getInstance();
        if (TASK_ENROLL.equals(task)) {
            BioIDCredential cred = new BioIDCredential();
            cred.setBcid(bcid);
            cred.setTrait(trait);
            cred.setAddedOn(System.currentTimeMillis());
            String json = mapper.writeValueAsString(Collections.singletonMap("bioid", cred));
            PersonBiometric person = (PersonBiometric)((Object)this.persistenceService.get(PersonBiometric.class, this.persistenceService.getPersonDn(userId)));
            person.setBioMetricDevices(json);
            boolean success = this.persistenceService.modify((Object)person);
            return success;
        }
        return false;
    }

    public boolean removeFromPersistence(String bcid, String trait, String userId) throws JsonProcessingException {
        PersonBiometric person = (PersonBiometric)((Object)this.persistenceService.get(PersonBiometric.class, this.persistenceService.getPersonDn(userId)));
        person.setBioMetricDevices(null);
        return this.persistenceService.modify((Object)person);
    }

    static {
        ACR = "bioid";
    }
}

