/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.credentials.extensions;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gluu.casa.credential.BasicCredential;
import org.gluu.casa.extension.AuthnMethod;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.bioid.BioIDService;
import org.gluu.casa.service.ISessionContext;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.resource.Labels;

@Extension
public class BioidExtension
implements AuthnMethod {
    private BioIDService bioidService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ISessionContext sessionContext = (ISessionContext)Utils.managedBean(ISessionContext.class);

    public BioidExtension() {
        this.bioidService = BioIDService.getInstance();
    }

    public String getUINameKey() {
        return "bioid_label";
    }

    public String getAcr() {
        BioIDService.getInstance();
        return BioIDService.ACR;
    }

    public String getPanelTitleKey() {
        return "bioid_title";
    }

    public String getPanelTextKey() {
        return "bioid_text";
    }

    public String getPanelButtonKey() {
        return "bioid_manage";
    }

    public String getPanelBottomTextKey() {
        return "bioid_download";
    }

    public String getPageUrl() {
        return "user/cred_details.zul";
    }

    public List<BasicCredential> getEnrolledCreds(String id) {
        String userName = this.sessionContext.getLoggedUser().getUserName();
        try {
            return BioIDService.getInstance().getBioIDDevices(this.sessionContext.getLoggedUser().getId()).stream().map(dev -> {
                BioIDService.getInstance();
                return new BasicCredential(Labels.getLabel((String)"face_periocular"), dev.getAddedOn());
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public int getTotalUserCreds(String id) {
        String userName = this.sessionContext.getLoggedUser().getUserName();
        return BioIDService.getInstance().getDeviceTotal(this.sessionContext.getLoggedUser().getId());
    }

    public void reloadConfiguration() {
        BioIDService.getInstance().reloadConfiguration();
    }

    public boolean mayBe2faActivationRequisite() {
        return Boolean.parseBoolean(Optional.ofNullable(BioIDService.getInstance().getScriptPropertyValue("2fa_requisite")).orElse("false"));
    }
}

