/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.consent.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gluu.casa.core.model.Client;
import org.gluu.casa.core.model.Scope;
import org.gluu.casa.misc.Utils;
import org.gluu.casa.plugins.consent.model.ClientAuthorization;
import org.gluu.casa.plugins.consent.model.Token;
import org.gluu.casa.service.IPersistenceService;
import org.gluu.search.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAuthorizationsService {
    private static final String TOKENS_DN = "ou=tokens,o=gluu";
    private static final String AUTHORIZATIONS_DN = "ou=authorizations,o=gluu";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPersistenceService persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);

    public Map<Client, Set<Scope>> getUserClientPermissions(String userId) {
        ClientAuthorization caSample = new ClientAuthorization();
        caSample.setBaseDn(AUTHORIZATIONS_DN);
        caSample.setUserId(userId);
        List authorizations = this.persistenceService.find((Object)caSample);
        Set clientIds = authorizations.stream().map(ClientAuthorization::getOxAuthClientId).collect(Collectors.toSet());
        Filter[] filters = clientIds.stream().map(id -> Filter.createEqualityFilter((String)"inum", (Object)id)).collect(Collectors.toList()).toArray(new Filter[0]);
        List clients = this.persistenceService.find(Client.class, this.persistenceService.getClientsDn(), Filter.createORFilter((Filter[])filters));
        Set scopeIds = authorizations.stream().map(ClientAuthorization::getScopes).flatMap(Collection::stream).collect(Collectors.toSet());
        filters = scopeIds.stream().map(id -> Filter.createEqualityFilter((String)"oxId", (Object)id)).collect(Collectors.toList()).toArray(new Filter[0]);
        List scopes = this.persistenceService.find(Scope.class, this.persistenceService.getScopesDn(), Filter.createORFilter((Filter[])filters));
        this.logger.info("Found {} client authorizations for user {}", (Object)clients.size(), (Object)userId);
        HashMap<Client, Set<Scope>> perms = new HashMap<Client, Set<Scope>>();
        for (Client client : clients) {
            HashSet clientScopes = new HashSet();
            for (ClientAuthorization auth : authorizations) {
                if (!auth.getOxAuthClientId().equals(client.getInum())) continue;
                for (String scopeName : auth.getScopes()) {
                    scopes.stream().filter(sc -> sc.getId().equals(scopeName)).findAny().ifPresent(clientScopes::add);
                }
            }
            perms.put(client, clientScopes);
        }
        return perms;
    }

    public void removeClientAuthorizations(String userId, String userName, String clientId) {
        ClientAuthorization caSample = new ClientAuthorization();
        caSample.setOxAuthClientId(clientId);
        caSample.setBaseDn(AUTHORIZATIONS_DN);
        caSample.setUserId(userId);
        this.logger.info("Removing client authorizations for user {}", (Object)userName);
        this.persistenceService.find((Object)caSample).forEach(auth -> this.persistenceService.delete((Object)auth));
        Token sampleToken = new Token();
        sampleToken.setBaseDn(TOKENS_DN);
        sampleToken.setOxAuthClientId(clientId);
        sampleToken.setOxAuthTokenType("refresh_token");
        sampleToken.setOxAuthUserId(userName);
        this.logger.info("Removing refresh tokens associated to this user/client pair");
        this.persistenceService.find((Object)sampleToken).forEach(token -> {
            this.logger.debug("Deleting token {}", (Object)token.getOxAuthTokenCode());
            this.persistenceService.delete((Object)token);
        });
    }
}

