/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.casa.plugins.accounts.vm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gluu.casa.plugins.accounts.pojo.ExternalAccount;
import org.gluu.casa.plugins.accounts.pojo.LinkingSummary;
import org.gluu.casa.plugins.accounts.pojo.PendingLinks;
import org.gluu.casa.plugins.accounts.pojo.Provider;
import org.gluu.casa.plugins.accounts.service.AccountLinkingService;
import org.gluu.casa.plugins.accounts.service.AvailableProviders;
import org.gluu.casa.service.ISessionContext;
import org.gluu.casa.ui.UIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.Pair;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Messagebox;

public class AccountLinkingViewModel {
    public static final String LINK_QUEUE = "social_queue";
    public static final String EVENT_NAME = "linked";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Provider, Pair<Boolean, String>> accounts;
    private List<Provider> providers;
    private AccountLinkingService slService;
    @WireVariable
    private ISessionContext sessionContext;
    private int linkedTotal;
    private String userId;

    public List<Provider> getProviders() {
        return this.providers;
    }

    public Map<Provider, Pair<Boolean, String>> getAccounts() {
        return this.accounts;
    }

    @Init
    public void init() {
        this.logger.debug("Initializing ViewModel");
        this.userId = this.sessionContext.getLoggedUser().getId();
        this.slService = new AccountLinkingService();
        this.providers = AvailableProviders.get(true);
        this.parseLinkedAccounts();
        if (this.providers.size() > 0) {
            EventQueues.lookup((String)LINK_QUEUE, (String)"session", (boolean)true).subscribe(event -> {
                if (event.getName().equals(EVENT_NAME)) {
                    this.logger.info("Received linked event");
                    LinkingSummary summary = (LinkingSummary)event.getData();
                    String provider = summary.getProvider();
                    PendingLinks.remove(this.userId, provider);
                    if (this.slService.link(this.userId, provider, summary.getUid())) {
                        this.parseLinkedAccounts();
                        BindUtils.postNotifyChange((Object)this, (String)"providers");
                    }
                }
            });
        }
    }

    @AfterCompose
    public void afterCompose(@ContextParam(value=ContextType.VIEW) Component view) {
        Selectors.wireEventListeners((Component)view, (Object)this);
    }

    @Listen(value="onData=#temp")
    public void link(Event evt) {
        PendingLinks.add(this.userId, evt.getData().toString(), null);
    }

    @NotifyChange(value={"providers"})
    public void disable(Provider provider) {
        if (this.linkedTotal > 1 || this.slService.hasPassword(this.userId)) {
            boolean succ = this.slService.unlink(this.userId, provider);
            if (succ) {
                this.parseLinkedAccounts();
            }
            UIUtils.showMessageUI((boolean)succ);
        } else {
            Messagebox.show((String)Labels.getLabel((String)"sociallogin.linking_pass_needed"), null, (int)1, (String)"z-messagebox-icon z-messagebox-information");
        }
    }

    @NotifyChange(value={"providers"})
    public void enable(Provider provider) {
        boolean succ = this.slService.enableLink(this.userId, provider);
        if (succ) {
            this.parseLinkedAccounts();
        }
        UIUtils.showMessageUI((boolean)succ);
    }

    public void remove(Provider provider) {
        if (this.linkedTotal > 1 || this.slService.hasPassword(this.userId)) {
            Messagebox.show((String)Labels.getLabel((String)"sociallogin.remove_hint"), null, (int)48, (String)"z-messagebox-icon z-messagebox-question", event -> {
                if ("onYes".equals(event.getName())) {
                    if (this.slService.delete(this.userId, provider)) {
                        this.parseLinkedAccounts();
                        UIUtils.showMessageUI((boolean)true, (String)Labels.getLabel((String)"sociallogin.removed_link", (Object[])new String[]{provider.getDisplayName()}));
                        BindUtils.postNotifyChange((Object)this, (String)"providers");
                    } else {
                        UIUtils.showMessageUI((boolean)false);
                    }
                }
            });
        } else {
            Messagebox.show((String)Labels.getLabel((String)"sociallogin.linking_pass_needed"), null, (int)1, (String)"z-messagebox-icon z-messagebox-information");
        }
    }

    private void parseLinkedAccounts() {
        this.logger.info("Parsing linked/unlinked accounts for {}", (Object)this.userId);
        List<ExternalAccount> linked = this.slService.getAccounts(this.userId, true);
        List<ExternalAccount> unlinked = this.slService.getAccounts(this.userId, false);
        this.accounts = new HashMap<Provider, Pair<Boolean, String>>();
        this.linkedTotal = linked.size();
        linked.forEach(acc -> this.accounts.put(acc.getProvider(), (Pair<Boolean, String>)new Pair((Object)true, (Object)acc.getUid())));
        unlinked.forEach(acc -> this.accounts.put(acc.getProvider(), (Pair<Boolean, String>)new Pair((Object)false, (Object)acc.getUid())));
    }
}

